/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.isc.iscb.platform.core.constant.ExecutionStatus;
import kd.isc.iscb.platform.core.util.SendMsgUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class MessageSender {
    private static final String FIELD_STATE = "state";
    private static final Log log = LogFactory.getLog(MessageSender.class);
    private static final String ISC_MSG_NOTIFICATION = "isc_message_notification";
    private static final String MESSAGE = "message";
    private static final String WARNING = "warning";
    private static final String ALARM = "alarm";

    public static void executeSend(DynamicObject exe) {
        for (DynamicObject msgInfo : MessageSender.getSendMsg(exe)) {
            try {
                MessageSender.sendMsg(msgInfo, exe);
                log.info("Message have been send\uff01task: " + exe.get("number") + "[" + exe.get("id") + "]");
            }
            catch (Throwable e) {
                log.warn("Send message failed! task: " + exe.get("number") + "[" + exe.get("id") + "]", e);
            }
        }
    }

    private static void sendMsg(DynamicObject msgNotification, DynamicObject exe) {
        MessageInfo messageInfo = new MessageInfo();
        if (exe.getString(FIELD_STATE).equals(ExecutionStatus.FINISHED.getStatus())) {
            messageInfo.setType(MESSAGE);
        } else if (exe.getString(FIELD_STATE).equals(ExecutionStatus.FAIL.getStatus()) || exe.getString(FIELD_STATE).equals(ExecutionStatus.PART.getStatus())) {
            messageInfo.setType(ALARM);
        } else {
            messageInfo.setType(WARNING);
        }
        String person = msgNotification.getString("person");
        String outsidePerson = msgNotification.getString("outsideperson");
        if (StringUtils.isEmpty((String)person) && StringUtils.isEmpty((String)outsidePerson)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6d88\u606f\u63a5\u6536\u4eba\u4e3a\u7a7a.", (String)"MessageSender_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String content = SendMsgUtil.getStrContainData(exe, msgNotification.getString("msg_content"), "{", "}", true);
        if (StringUtils.isNotEmpty((String)person)) {
            String[] users = person.split(",");
            HashSet<Long> ids = new HashSet<Long>();
            if (users.length > 0) {
                for (String user : users) {
                    ids.add(Long.valueOf(user.substring(user.indexOf(40) + 1, user.indexOf(41))));
                }
            }
            messageInfo.setUserIds(new ArrayList(ids));
            messageInfo.setTag(ResManager.loadKDString((String)"\u96c6\u6210\u4e91", (String)"MessageSender_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            messageInfo.setTitle(String.format(ResManager.loadKDString((String)"%s\u6267\u884c\u65e5\u5fd7\u4fe1\u606f", (String)"MessageSender_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), exe.getString("name")));
            messageInfo.setContent(content);
            messageInfo.setContentUrl(SendMsgUtil.getUrlInfoWithModal(exe.getString("id")));
            messageInfo.setPubaccNumber("systempubacc");
            log.info("\u5f85\u53d1\u9001\u7684\u6d88\u606f\u4f53\uff1a" + messageInfo);
            messageInfo.setContent(StringUtil.trim((String)content, (int)1000));
            long id = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            log.info("\u6d88\u606f\u4e2d\u5fc3\u8fd4\u56de\u7684\u6d88\u606fid:" + id);
        }
        SendMsgUtil.sendShortMesagge(outsidePerson, content);
    }

    private static DynamicObject[] getSendMsg(DynamicObject exe) {
        long triggerId = exe.getLong("data_copy_trigger_id");
        String sql = "select distinct n.fid AS fid  from t_isc_msg_object t  inner join t_isc_msg_notification n on t.fid=n.fid  where n.fstate='1' and t.ftrigger=" + triggerId + " and t.fexcute like '%" + exe.getString(FIELD_STATE) + "%'";
        ArrayList<Long> msgIds = new ArrayList<Long>();
        try (Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);){
            for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList())) {
                msgIds.add(D.l((Object)row.get((Object)"fid")));
            }
        }
        catch (Throwable e) {
            log.warn("MessageSender.getSendMsg(DynamicObject exe) failed.", e);
        }
        QFilter[] qfs = new QFilter[]{new QFilter("id", "in", msgIds)};
        return BusinessDataServiceHelper.load((String)ISC_MSG_NOTIFICATION, (String)"number,name,channel,person,outsideperson,msg_content", (QFilter[])qfs);
    }
}

