/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util.setter;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulComboProp;
import kd.isc.iscb.platform.core.util.setter.Setter;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;

public class ComboPropSetter
implements Setter {
    private ComboProp comboProp;

    public ComboPropSetter(ComboProp comboProp) {
        this.comboProp = comboProp;
    }

    @Override
    public void setObjValue(DynamicObject object, String property, Object value) {
        if (value instanceof Collection && !((Collection)value).isEmpty() && this.comboProp instanceof MulComboProp) {
            StringBuilder sb = new StringBuilder();
            sb.append(',');
            for (Object o : (List)value) {
                sb.append(o).append(',');
            }
            object.set(property, (Object)sb.toString());
        } else {
            object.set(property, value);
        }
    }

    @Override
    public void setMapValue(Map<String, Object> map, Map<String, Object> requires, String property, DynamicObject obj) {
        Object val = obj.get(property);
        map.put(property, val);
    }

    @Override
    public void setSchema(Map<String, Object> map, String parentEntityName, String property) {
        List vItems = this.comboProp.getComboItems();
        HashMap<String, String> constantMap = new HashMap<String, String>();
        for (ValueMapItem item : vItems) {
            if (item == null || D.s((Object)item.getName()) == null) continue;
            constantMap.put(D.s((Object)item.getName()), item.getValue());
        }
        map.put("data_type", "ENUM");
        map.put("data_schema", Hash.mur32((Object[])new Object[]{parentEntityName + "." + this.comboProp.getName()}));
        map.put("consts", constantMap);
        map.put("is_nullable", !this.comboProp.isMustInput());
        map.put("label", this.comboProp.getDisplayName().toString());
    }
}

