/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util.setter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.property.FlexProp;
import kd.bos.flex.FlexService;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.util.setter.Setter;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class FlexPropSetter
implements Setter {
    private static final String BD_MATERIAL = "bd_material";
    private FlexProp prop;

    public FlexPropSetter(FlexProp property) {
        this.prop = property;
    }

    @Override
    public void setObjValue(DynamicObject object, String property, Object value) {
        throw new UnsupportedOperationException("use next setObjValue");
    }

    @Override
    public void setObjValue(DynamicObject object, String property, Object value, Map<String, Object> data) {
        if (value instanceof Long) {
            this.setFlexById(object, property, value, data);
        } else if (value instanceof Map) {
            Map<String, Object> resultmap = this.buildResultMap((Map)value);
            ArrayList<FlexEntireData> flexEntireDatas = new ArrayList<FlexEntireData>(1);
            FlexEntireData fet = this.buildFlexEntireData(resultmap, flexEntireDatas);
            FlexService.batchSaveFlexData((int)this.prop.getFlexTypeId(), flexEntireDatas);
            this.writeFlex(object, property, fet.getId(), data);
        }
    }

    private void writeFlex(DynamicObject obj, String property, long fetID, Map<String, Object> data) {
        boolean save_flex_with_Ref = D.x((Object)data.get("save_flex_with_ref"));
        if (save_flex_with_Ref) {
            obj.set(this.prop.getRefIdProp().getName(), (Object)fetID);
            BusinessDataServiceHelper.loadRefence((Object[])new Object[]{obj}, (IDataEntityType)obj.getDataEntityType());
        } else {
            boolean save_flex_with_dynamicObject;
            boolean dataContainsKey = D.x((Object)data.get("save_flex_with_obj"));
            boolean appParamsContainsKey = D.x((Object)AppParameterServiceHelper.getParameterFromCache("save_flex_with_obj"));
            boolean bl = save_flex_with_dynamicObject = dataContainsKey || appParamsContainsKey;
            if (save_flex_with_dynamicObject) {
                String entity = this.getParentEntityName(obj.getDataEntityType());
                DynamicObject baseData = this.getFlexRefBaseData(obj);
                String flexProperty = this.getFlexProperty(baseData);
                this.setFlexData(obj, entity, property, baseData, flexProperty, fetID);
            } else {
                obj.set(this.prop.getRefIdProp().getName(), (Object)fetID);
            }
        }
    }

    private DynamicObject getFlexRefBaseData(DynamicObject obj) {
        DynamicObject baseData = this.getBaseData(obj);
        DynamicObject master = this.findMasterObject(baseData);
        return master != null ? master : baseData;
    }

    private DynamicObject getBaseData(DynamicObject obj) {
        DynamicObject baseData = obj.getDynamicObject(this.prop.getBasePropertyKey());
        if (baseData == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u7ed1\u5b9a\u7684\u57fa\u7840\u8d44\u6599%s\u672a\u4f20\u5165\u6570\u636e,\u8bf7\u68c0\u67e5\u662f\u5426\u672a\u914d\u7f6e\u6216\u4f20\u5165\u4e86\u9519\u8bef\u7684\u6570\u636e\u3002", (String)"FlexPropSetter_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.prop.getBasePropertyKey()));
        }
        return baseData;
    }

    private String getFlexProperty(DynamicObject baseData) {
        return ((BasedataEntityType)baseData.getDataEntityType()).getFlexProperty();
    }

    private DynamicObject findMasterObject(DynamicObject baseData) {
        String masteridPropName = ((BasedataEntityType)baseData.getDataEntityType()).getMasteridPropName();
        if (masteridPropName != null) {
            Object o = baseData.get(masteridPropName);
            if (o instanceof DynamicObject && BD_MATERIAL.equals(((DynamicObject)o).getDataEntityType().getName())) {
                return (DynamicObject)o;
            }
            return null;
        }
        return null;
    }

    private void setFlexData(DynamicObject obj, String entity, String property, DynamicObject baseData, String flexProperty, long fetID) {
        List flexProperties = FlexService.getBaseUseFlexProperties((String)baseData.getDataEntityType().getName(), (Object)baseData.getPkValue(), (String)flexProperty);
        FlexEntityType flexEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)entity, (String)property, (int)this.prop.getFlexTypeId(), (List)flexProperties);
        DynamicObject flexData = new DynamicObject((DynamicObjectType)flexEntityType, (Object)fetID);
        obj.set(property, (Object)flexData);
    }

    private String getParentEntityName(IDataEntityType dataEntityType) {
        if (!(dataEntityType instanceof EntryType)) {
            return dataEntityType.getName();
        }
        if (dataEntityType.getParent() instanceof EntryType) {
            return this.getParentEntityName(dataEntityType.getParent());
        }
        return dataEntityType.getParent().getName();
    }

    private FlexEntireData buildFlexEntireData(Map<String, Object> resultmap, List<FlexEntireData> flexEntireDatas) {
        FlexEntireData fet = new FlexEntireData();
        flexEntireDatas.add(fet);
        ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>();
        for (Map.Entry<String, Object> entry : resultmap.entrySet()) {
            if (entry.getValue() == null) continue;
            DynamicObject flexPro = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_flex_property", (String)"valuetype", (QFilter[])new QFilter[]{new QFilter("flexfield", "=", (Object)entry.getKey())});
            if (flexPro == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u4e0d\u5b58\u5728\u5b57\u6bb5\u540d\u662f%s\u7684\u5f39\u6027\u57df\u5c5e\u6027", (String)"FlexPropSetter_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entry.getKey()));
            }
            boolean valuetype = "3".equals(flexPro.getString("valuetype"));
            FlexEntireData flexEntireData = fet;
            flexEntireData.getClass();
            FlexEntireData.FlexData f = new FlexEntireData.FlexData(flexEntireData, entry.getKey(), valuetype ? entry.getValue() : Long.valueOf(D.l((Object)entry.getValue())));
            f.setId(IDService.get().genLongId());
            f.setDbType(valuetype ? FlexEntireData.FlexFieldDataType.STRING : FlexEntireData.FlexFieldDataType.LONG);
            flexDatas.add(f);
        }
        fet.setFlexDatas(flexDatas);
        return fet;
    }

    private Map<String, Object> buildResultMap(Map<String, Object> flexs) {
        HashMap<String, Object> resultmap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : flexs.entrySet()) {
            String flexfield = entry.getKey();
            Object flexValue = entry.getValue();
            if (flexValue instanceof Map) {
                this.queryBaseDataIDByMap(resultmap, flexfield, (Map)flexValue);
                continue;
            }
            resultmap.put(flexfield, flexValue);
        }
        return resultmap;
    }

    private void queryBaseDataIDByMap(Map<String, Object> resultmap, String flexfield, Map<String, Object> basedataFilter) {
        if (basedataFilter.containsKey("id")) {
            resultmap.put(flexfield, D.l((Object)basedataFilter.get("id")));
        } else {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(basedataFilter.size());
            for (Map.Entry<String, Object> objectEntry : basedataFilter.entrySet()) {
                filters.add(new QFilter(objectEntry.getKey(), "=", objectEntry.getValue()));
            }
            QFilter filter = new QFilter("flexfield", "=", (Object)flexfield);
            DynamicObject flexproperty = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_flex_property", (String)"valuesource,valuetype", (QFilter[])new QFilter[]{filter});
            if (flexproperty == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5b57\u6bb5flexfield\u7684\u503c\u662f[%s]\u627e\u4e0d\u5230\u5b9e\u4f53bos_flex_property\u4e2d\u5b58\u5728\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"FlexPropSetter_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), flexfield));
            }
            String valuetype = flexproperty.getString("valuetype");
            if ("1".equals(valuetype)) {
                DynamicObject basedata = BusinessDataServiceHelper.loadSingleFromCache((String)D.s((Object)flexproperty.getDynamicObject("valuesource").getPkValue()), (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
                if (basedata == null) {
                    return;
                }
                resultmap.put(flexfield, basedata.getLong("id"));
            } else if ("2".equals(valuetype)) {
                DynamicObject assitantdata = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_assistantdata_detail", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
                if (assitantdata == null) {
                    return;
                }
                resultmap.put(flexfield, assitantdata.getLong("id"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlexById(DynamicObject object, String property, Object value, Map<String, Object> data) {
        String table = this.prop.getFlexDataType().getAlias();
        String db = this.prop.getFlexDataType().getDBRouteKey();
        String sql = "SELECT fvalue FROM " + table + " where fid = ?";
        Connection cn = TX.getConnection((String)db, (boolean)true, (String[])new String[0]);
        String fvalue = null;
        try {
            List<Long> params = Collections.singletonList(D.l((Object)value));
            List<Integer> types = Collections.singletonList(-5);
            Object v = DbUtil.executeScalar((Connection)cn, (String)sql, params, types);
            fvalue = D.s((Object)v);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        if (StringUtil.isEmpty((String)fvalue)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230id\u4e3a[%s]\u7684\u5f39\u6027\u57df\u7ef4\u5ea6", (String)"FlexPropSetter_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), value));
        }
        this.writeFlex(object, property, D.l((Object)value), data);
    }

    @Override
    public void setRequiresMap(String property, Map<String, Object> dbRequires, Map<String, Object> requires) {
        Object value = requires.get(property);
        dbRequires.put(property, value);
    }

    @Override
    public void setMapValue(Map<String, Object> map, Map<String, Object> requires, String property, DynamicObject obj) {
        if (obj.getDataEntityType() instanceof EntryType) {
            this.getEntryFlex(map, requires, property, obj);
        } else {
            long id = obj.getLong("id");
            QFilter qFilter = new QFilter("id", "=", (Object)id);
            String entity = obj.getDataEntityType().getName();
            DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)(property + ".value"), (QFilter[])new QFilter[]{qFilter});
            if (bill == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728\u5b9e\u4f53%1$s\u4e2d\u627e\u4e0d\u5230id\u662f\uff1a%2$s\u7684\u8bb0\u5f55", (String)"FlexPropSetter_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity, id));
            }
            this.setFlexValues(map, requires, property, bill);
        }
    }

    private void setFlexValues(Map<String, Object> map, Map<String, Object> requires, String property, DynamicObject bill) {
        String flexStr = D.s((Object)bill.get(property + ".value"));
        if (flexStr != null && requires.get(property) instanceof Map) {
            Map flexPro = (Map)Json.toObject((String)flexStr);
            this.setFlexRequiresMap(map, requires, property, flexPro);
        } else if (flexStr != null) {
            long id = this.getIdByValue(flexStr);
            map.put(property, id);
        } else {
            map.put(property, null);
        }
    }

    private void getEntryFlex(Map<String, Object> map, Map<String, Object> requires, String property, DynamicObject obj) {
        String entity = obj.getDataEntityType().getParent().getName();
        Object id = ((DynamicObject)obj.getParent()).getPkValue();
        QFilter qFilter = new QFilter("id", "=", id);
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)(property + ".value"), (QFilter[])new QFilter[]{qFilter});
        if (bill == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728\u5b9e\u4f53%1$s\u4e2d\u627e\u4e0d\u5230id\u662f\uff1a%2$s\u7684\u8bb0\u5f55", (String)"FlexPropSetter_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity, id));
        }
        DynamicObjectCollection collection = bill.getDynamicObjectCollection(obj.getDataEntityType().getName());
        for (DynamicObject entry : collection) {
            if (!entry.getPkValue().equals(obj.getPkValue())) continue;
            this.setFlexValues(map, requires, property, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getIdByValue(String flexStr) {
        String table = this.prop.getFlexDataType().getAlias();
        String db = this.prop.getFlexDataType().getDBRouteKey();
        String sql = "SELECT fid  FROM " + table + " where fvalue = ?";
        Connection cn = TX.getConnection((String)db, (boolean)true, (String[])new String[0]);
        try {
            List<String> params = Collections.singletonList(flexStr);
            List<Integer> types = Collections.singletonList(12);
            Object v = DbUtil.executeScalar((Connection)cn, (String)sql, params, types);
            long l = D.l((Object)v);
            return l;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    private void setFlexRequiresMap(Map<String, Object> map, Map<String, Object> requires, String property, Map<String, Object> flexPro) {
        Map m = (Map)requires.get(property);
        HashMap submap = new HashMap();
        map.put(property, submap);
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            if (entry.getValue() instanceof Map) {
                long basedata_id = D.l((Object)flexPro.get(entry.getKey()));
                if (basedata_id > 0L) {
                    HashMap<String, Object> subsubmap = new HashMap<String, Object>();
                    submap.put(entry.getKey(), subsubmap);
                    QFilter filter = new QFilter("flexfield", "=", entry.getKey());
                    DynamicObject flexproperty = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_flex_property", (String)"valuesource,valuetype", (QFilter[])new QFilter[]{filter});
                    if (flexproperty == null) {
                        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5b57\u6bb5flexfield\u7684\u503c\u662f[%s]\u627e\u4e0d\u5230\u5b9e\u4f53bos_flex_property\u4e2d\u5b58\u5728\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"FlexPropSetter_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entry.getKey()));
                    }
                    this.getBaseDataFields(entry, subsubmap, flexproperty, basedata_id);
                    continue;
                }
                submap.put(entry.getKey(), null);
                continue;
            }
            submap.put(entry.getKey(), flexPro.get(entry.getKey()));
        }
    }

    private void getBaseDataFields(Map.Entry<String, Object> entry, Map<String, Object> subsubmap, DynamicObject flexproperty, long basedata_id) {
        block5: {
            String selector;
            Map queryFields;
            QFilter q;
            String valuetype;
            block4: {
                valuetype = flexproperty.getString("valuetype");
                q = new QFilter("id", "=", (Object)basedata_id);
                queryFields = (Map)entry.getValue();
                selector = StringUtil.join(queryFields.keySet(), (String)",");
                if (!"1".equals(valuetype)) break block4;
                String entityName = D.s((Object)flexproperty.getDynamicObject("valuesource").getPkValue());
                DynamicObject basedata = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)selector, (QFilter[])new QFilter[]{q});
                if (basedata == null) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\uff1a%1$s\u627e\u4e0d\u5230id\u662f\uff1a%2$s\u7684\u8bb0\u5f55\u3002", (String)"FlexPropSetter_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entityName, basedata_id));
                }
                for (Map.Entry objectEntry : queryFields.entrySet()) {
                    subsubmap.put(D.s(objectEntry.getKey()), basedata.get(D.s(objectEntry.getKey())));
                }
                break block5;
            }
            if (!"2".equals(valuetype)) break block5;
            DynamicObject basedata = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_assistantdata_detail", (String)selector, (QFilter[])new QFilter[]{q});
            if (basedata == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53bos_assistantdata_detail\u627e\u4e0d\u5230id\u662f\uff1a%s\u7684\u8bb0\u5f55\u3002", (String)"FlexPropSetter_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), basedata_id));
            }
            for (Map.Entry objectEntry : queryFields.entrySet()) {
                subsubmap.put(D.s(objectEntry.getKey()), basedata.get(D.s(objectEntry.getKey())));
            }
        }
    }

    @Override
    public void setSchema(Map<String, Object> map, String parentEntityName, String property) {
        map.put("data_type", "STRUCT");
        map.put("is_nullable", !this.prop.isMustInput());
        map.put("label", this.prop.getDisplayName().toString());
        map.put("data_schema", Hash.mur32((Object[])new Object[]{"FLEX_PROPERTY"}));
    }
}

