/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util.setter;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.setter.BasedataPropSetter;
import kd.isc.iscb.platform.core.util.setter.Setter;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class MulBasedataPropSetter
implements Setter {
    private MulBasedataProp mulBasedataProp;

    public MulBasedataPropSetter(MulBasedataProp mulBasedataProp) {
        this.mulBasedataProp = mulBasedataProp;
    }

    @Override
    public void setObjValue(DynamicObject object, String property, Object value) {
        if (value == null) {
            object.set(property, null);
        } else if (value instanceof DynamicObjectCollection) {
            object.set(property, value);
        } else if (value instanceof List) {
            this.setRefs(object, property, ((List)value).toArray());
        } else if (value instanceof Object[]) {
            this.setRefs(object, property, (Object[])value);
        } else if (value instanceof String) {
            String str = D.s((Object)value);
            if (str.startsWith("[") && str.endsWith("]")) {
                this.setRefs(object, property, JSON.parseArray((String)str).toArray());
            } else {
                this.setRefs(object, property, new Object[]{str});
            }
        } else {
            this.setRefs(object, property, new Object[]{value});
        }
    }

    private void setRefs(DynamicObject object, String property, Object[] values) {
        Map map;
        DynamicObjectCollection rows = object.getDynamicObjectCollection(property);
        rows.clear();
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        BasedataProp bdProp = (BasedataProp)rows.getDynamicObjectType().getProperties().get((Object)"fbasedataid");
        BasedataEntityType refType = (BasedataEntityType)bdProp.getComplexType();
        if (values[0] instanceof Map) {
            map = this.loadFromMap(values, bdProp);
        } else {
            Object[] ids = this.formatIdArray(values, bdProp);
            map = BusinessDataServiceHelper.loadFromCache((Object[])ids, (DynamicObjectType)refType);
            this.checkExistedId(ids, refType, map);
        }
        for (DynamicObject bdObj : map.values()) {
            DynamicObject row = new DynamicObject(rows.getDynamicObjectType());
            bdProp.setValue((Object)row, (Object)bdObj);
            rows.add((Object)row);
        }
    }

    private Map<Object, DynamicObject> loadFromMap(Object[] params, BasedataProp bdProp) {
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(params.length);
        for (Object filter : params) {
            DynamicObject object;
            if (!(filter instanceof Map)) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u591a\u9009\u57fa\u7840\u8d44\u6599\u8d4b\u503c'%s'\u4e0d\u662fMap\u683c\u5f0f\uff0c\u4e0e\u7b2c\u4e00\u4e2a\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MulBasedataPropSetter_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filter));
            }
            if (this.isEmptyMap((Map)filter)) continue;
            HashMap<String, Object> temp = new HashMap<String, Object>((Map)filter);
            String entity = bdProp.getBaseEntityId();
            Object id = this.formatId(bdProp, temp.remove("id"));
            Object defaultValue = this.formatId(bdProp, temp.remove("$default"));
            QFilter[] filters = this.prepareFilters(temp);
            if (id != null && QueryServiceHelper.exists((String)entity, (Object)id)) {
                object = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entity);
                map.put(id, object);
                continue;
            }
            if (!temp.isEmpty() && QueryServiceHelper.exists((String)entity, (QFilter[])filters)) {
                Map objects = BusinessDataServiceHelper.loadFromCache((String)entity, (QFilter[])filters);
                int count = objects.size();
                if (count != 1) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6%1$s\u5728\u5b9e\u4f53%2$s\u4e2d\u67e5\u5230%3$s\u6761\u8bb0\u5f55\u3002", (String)"MulBasedataPropSetter_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), temp, entity, count));
                }
                map.putAll(objects);
                continue;
            }
            if (defaultValue != null && QueryServiceHelper.exists((String)entity, (Object)defaultValue)) {
                object = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entity);
                map.put(defaultValue, object);
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6%1$s\u5728\u5b9e\u4f53%2$s\u4e2d\u67e5\u8be2\u4e0d\u5230\u8bb0\u5f55\u3002", (String)"MulBasedataPropSetter_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), temp, entity));
        }
        return map;
    }

    private boolean isEmptyMap(Map<String, Object> valueMap) {
        boolean isEmpty = true;
        for (Object value : valueMap.values()) {
            if (value == null || "".equals(value)) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    private Object[] formatIdArray(Object[] values, BasedataProp bdProp) {
        boolean isLong = bdProp.getRefIdProp() instanceof LongProp;
        Object[] ids = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            ids[i] = isLong ? Long.valueOf(D.l((Object)values[i])) : D.s((Object)values[i]);
        }
        return ids;
    }

    private Object formatId(BasedataProp bdProp, Object id) {
        if (id != null && bdProp.getRefIdProp() instanceof LongProp) {
            return D.l((Object)id);
        }
        return D.s((Object)id);
    }

    private QFilter[] prepareFilters(Map<String, Object> map) {
        QFilter[] filters = new QFilter[map.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = D.s((Object)entry.getKey());
            filters[i++] = new QFilter(key, "=", entry.getValue());
        }
        return filters;
    }

    private void checkExistedId(Object[] values, BasedataEntityType refType, Map<Object, DynamicObject> map) {
        if (map.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e2d\u4e0d\u5b58\u5728id=%2$s\u7684\u8bb0\u5f55!", (String)"MulBasedataPropSetter_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), refType.getName(), Arrays.toString(values)));
        }
        Set<Object> keys = map.keySet();
        int dbType = refType.getPrimaryKey().getDbType();
        Object[] objectArray = values;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object id;
            Object realId = id = objectArray[i];
            if (dbType == -5 || dbType == 4) {
                realId = D.l((Object)id);
            }
            if (keys.contains(realId)) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e2d\u4e0d\u5b58\u5728id=%2$s\u7684\u8bb0\u5f55!", (String)"MulBasedataPropSetter_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), refType.getName(), id));
        }
    }

    @Override
    public void setMapValue(Map<String, Object> map, Map<String, Object> requires, String property, DynamicObject obj) {
        String name = this.mulBasedataProp.getName();
        Object val = obj.get(name);
        if (val instanceof DynamicObjectCollection) {
            DynamicObjectCollection c = (DynamicObjectCollection)val;
            ArrayList<Object> refs = new ArrayList<Object>(c.size());
            for (DynamicObject d : c) {
                Object value = d.get("fbasedataid");
                if (value instanceof DynamicObject) {
                    refs.add(((DynamicObject)value).getPkValue());
                    continue;
                }
                refs.add(value);
            }
            map.put(name, refs);
        }
    }

    @Override
    public void setSchema(Map<String, Object> map, String parentEntityName, String property) {
        map.put("data_type", CommonUtil.formatDataType(this.mulBasedataProp.getPropertyType().getSimpleName()));
        map.put("data_schema", this.mulBasedataProp.getBaseEntityId());
        map.put("is_nullable", !this.mulBasedataProp.isMustInput());
        map.put("label", this.mulBasedataProp.getDisplayName() != null ? this.mulBasedataProp.getDisplayName().toString() : "");
    }

    @Override
    public void setRequiresMap(String property, Map<String, Object> dbRequires, Map<String, Object> requires) {
        Object value = requires.get(property);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.mulBasedataProp.getComplexType().getName());
        if (value != null) {
            if (value instanceof Map) {
                BasedataPropSetter.recursiveSetValue(property, dbRequires, (IDataEntityType)type, (Map)value);
            } else {
                dbRequires.put(property, value);
            }
        }
    }
}

