/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.vc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.DataCopyMapping;
import kd.isc.iscb.platform.core.dc.e.DataCopyOidLog;
import kd.isc.iscb.platform.core.dc.e.DataCopyOidLookup;
import kd.isc.iscb.platform.core.dc.e.DataCopyOutput;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.dc.e.s.SourceDataDecorator;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.vc.AbstractValueConversionRule;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleFactory;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.trace.TraceTask;

class AutoMappingRule
extends AbstractValueConversionRule {
    private static final String FULL_NAME = "full_name";
    private static final String FILTER_LINK = "filter_link";
    private static final String FILTER_VALUE = "filter_value";
    private static final String FILTER_COMPARE = "filter_compare";
    private static final String FILTER_COLUMN = "filter_column";
    private static final String FIELD_NUMBER = "number";
    private DataCopyParam param;
    private DataCopyMapping mapping;
    private DynamicObject schema;
    private boolean record_oid_mappings;
    private DynamicObject source;
    private DynamicObject target;
    private boolean run_data_copy_on_missed;
    private ConnectionWrapper real_src;
    private ConnectionWrapper real_tar;
    private String value_attribute;

    @Override
    public ConnectionWrapper getSourceConnection() {
        return this.real_src;
    }

    @Override
    public ConnectionWrapper getTargetConnection() {
        return this.real_tar;
    }

    AutoMappingRule(DynamicObject cfg, ConnectionWrapper src, ConnectionWrapper tar) {
        super(cfg, src, tar);
        this.run_data_copy_on_missed = D.x((Object)cfg.get("run_data_copy_on_missed"));
        long data_copy_schema_id = cfg.getLong("data_copy_schema_id");
        this.schema = BusinessDataServiceHelper.loadSingle((Object)data_copy_schema_id, (String)"isc_data_copy");
        if (this.schema.getLong("source_schema_id") != cfg.getLong("source_data_schema_id")) {
            String text = String.format(ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219\uff08%s\uff09\u7684\u6e90\u5bf9\u8c61\u4e0e\u5176\u5f15\u7528\u7684\u96c6\u6210\u65b9\u6848\u7684\u6e90\u5bf9\u8c61\u4e0d\u4e00\u81f4\uff01", (String)"AutoMappingRule_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg.get(FIELD_NUMBER));
            throw new IscBizException(text);
        }
        if (this.schema.getLong("target_schema_id") != cfg.getLong("target_data_schema_id")) {
            String text = String.format(ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219\uff08%s\uff09\u7684\u76ee\u6807\u5bf9\u8c61\u4e0e\u5176\u5f15\u7528\u7684\u96c6\u6210\u65b9\u6848\u7684\u76ee\u6807\u5bf9\u8c61\u4e0d\u4e00\u81f4\uff01", (String)"AutoMappingRule_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg.get(FIELD_NUMBER));
            throw new IscBizException(text);
        }
        this.record_oid_mappings = D.x((Object)this.schema.get("record_oid_mappings"));
        this.value_attribute = D.s((Object)cfg.get("value_attribute"));
        this.setRealSrc(src, tar);
        this.setRealTar(src, tar);
    }

    private void setRealTar(ConnectionWrapper src, ConnectionWrapper tar) {
        long data_target_id = this.schema.getLong("data_target_id");
        DynamicObject data_target = BusinessDataServiceHelper.loadSingle((Object)data_target_id, (String)"isc_data_source");
        long tar_dblink_id = data_target.getLong("dblink_id");
        this.real_tar = tar_dblink_id == tar.getConfig().getLong("id") ? tar : (tar_dblink_id == src.getConfig().getLong("id") ? src : tar);
    }

    private void setRealSrc(ConnectionWrapper src, ConnectionWrapper tar) {
        long data_source_id = this.schema.getLong("data_source_id");
        DynamicObject data_source = BusinessDataServiceHelper.loadSingle((Object)data_source_id, (String)"isc_data_source");
        long src_dblink_id = data_source.getLong("dblink_id");
        this.real_src = src_dblink_id == src.getConfig().getLong("id") ? src : (src_dblink_id == tar.getConfig().getLong("id") ? tar : src);
    }

    @Override
    public Object cast(final String id) {
        String target_oid = this.lookupTargetOid(id);
        if (target_oid != null) {
            return target_oid;
        }
        this.prepareForMapping();
        Map<String, Object> src_data = this.loadSourceJudgeKeys(id);
        DynamicObject cfg = this.getRuleConfig();
        if (src_data == null) {
            if (D.s((Object)cfg.get("default_value")) != null) {
                return null;
            }
            this.prepareForLookup();
            throw new IscBizException(String.format(ResManager.loadKDString((String)"ID\u4e3a\uff08%1$s\uff09\u7684\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff01", (String)"AutoMappingRule_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), id, this.source.getString("name")));
        }
        Map<String, Object> tar_data = this.mapping.translateJudgeFieldsOnly(src_data);
        Object target = this.loadTargetValue(tar_data);
        if (target == null) {
            if (cfg.get("data_copy_trigger") != null) {
                return null;
            }
            if (this.run_data_copy_on_missed) {
                target = TraceStack.run(TraceType.EXE_DCS, this.mapping.getParam().getSchema(), new TraceTask(){

                    public Object invoke() {
                        return AutoMappingRule.this.runDataCopy(id);
                    }
                });
                if (this.value_attribute != null) {
                    target = this.loadTargetValue(tar_data);
                }
            } else if (D.s((Object)cfg.get("default_value")) == null) {
                src_data.remove("$id");
                src_data.remove("$pk");
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff1a%2$s\uff09\u65e0\u6cd5\u5c06\u6e90\u7cfb\u7edf\u5b57\u6bb5\u503c\uff08%3$s\uff09\u8f6c\u6362\u4e3a\u76ee\u6807\u7cfb\u7edf\u503c\uff01", (String)"AutoMappingRule_30", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg.getString(FIELD_NUMBER), cfg.getString("name"), src_data) + "\r\n" + ValueConversionRuleFactory.getExTips());
            }
        }
        return target;
    }

    private String lookupTargetOid(String id) {
        if (!this.record_oid_mappings) {
            return null;
        }
        this.prepareForLookup();
        long source_connection = D.l((Object)this.getSourceConnection().getConfig().getPkValue());
        long target_connection = D.l((Object)this.getTargetConnection().getConfig().getPkValue());
        return DataCopyOidLookup.lookup(id, source_connection, this.source, target_connection, this.target);
    }

    private Object runDataCopy(String src_id) {
        Map<String, Object> src_data = this.loadSourceData(src_id);
        Map<String, Object> tar_data = this.mapping.translateAll(src_data);
        Object tar_id = this.saveTargetData(tar_data);
        if (this.param.isRecordOidLog()) {
            DataCopyOidLog.saveLog(this.param, src_data, tar_data, null);
        }
        if (this.param.recordOidMappings()) {
            DataCopyOidLookup.saveOidMapping(this.param, src_data, tar_data);
        }
        return tar_id;
    }

    private Object saveTargetData(Map<String, Object> tar_data) {
        DataCopyOutput output = new DataCopyOutput(this.param);
        output.prepare();
        output.write(tar_data);
        Object id = tar_data.get(this.param.getTargetPrimaryKey());
        if (id != null) {
            return id;
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\uff08%1$s\uff09\u6267\u884c\u540e\u6ca1\u6709\u8fd4\u56de\u76ee\u6807\u5355ID\uff0c\u81ea\u52a8\u6620\u5c04\u89c4\u5219\uff08%2$s\uff09\u4e0d\u80fd\u5c06\u5176\u7528\u4e8e\u81ea\u52a8\u540c\u6b65\u3002", (String)"AutoMappingRule_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.param.getSchema().get(FIELD_NUMBER), this.getRuleConfig().get(FIELD_NUMBER)));
    }

    private Map<String, Object> loadSourceData(String id) {
        SourceDataDecorator decorator;
        Map data = this.innerLoadSourceData(id);
        if (data instanceof DataRow) {
            data = ((DataRow)data).toMap();
        }
        if ((decorator = this.param.getSourceDataDecorator()) != null) {
            decorator.decorate(data, this.param);
        }
        return data;
    }

    private Map<String, Object> innerLoadSourceData(String id) {
        if (this.param.sourceIsTable()) {
            return this.loadSourceDataFromTable(id);
        }
        if (this.param.sourceIsEntity()) {
            return this.loadSourceDataFromEntity(id);
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\uff08%1$s\uff09\u7684\u6e90\u4e0d\u662f\u6570\u636e\u8868\u6216\u5b9e\u4f53\uff0c\u4e0d\u80fd\u7528\u4e8e\u81ea\u52a8\u6620\u5c04\u89c4\u5219\uff08%2$s\uff09\uff01", (String)"AutoMappingRule_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.param.getSchema().get(FIELD_NUMBER), this.getRuleConfig().get(FIELD_NUMBER)));
    }

    private void prepareForMapping() {
        if (this.mapping == null) {
            this.param = new DataCopyParam(this.schema, this.getSourceConnection(), this.getTargetConnection());
            this.mapping = new DataCopyMapping(this.param);
        }
    }

    private void prepareForLookup() {
        if (this.target == null) {
            this.source = BusinessDataServiceHelper.loadSingle((Object)this.schema.getLong("source_schema_id"), (String)"isc_metadata_schema");
            this.target = BusinessDataServiceHelper.loadSingle((Object)this.schema.getLong("target_schema_id"), (String)"isc_metadata_schema");
        }
    }

    private Object loadTargetValue(Map<String, Object> data) {
        if (this.param.targetIsTable()) {
            return this.loadTargetValueFromTable(data);
        }
        return this.loadTargetValueFromEntity(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadTargetValueFromTable(Map<String, Object> data) {
        ConnectionWrapper tar = this.getTargetConnection();
        Table table = ConnectionManager.getTable(tar, this.param.getTargetTableName());
        String jf = this.param.getJudgeField();
        List<String> judgeFields = this.param.getJudgeFields();
        String attribute = this.getTargetValueAttribute();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        String sql = TableUtil.generateQuerySingleValueSQL((Table)table, (String)attribute, data, (String)jf, judgeFields, values, types);
        try (ObjectReader<DataRow> reader = tar.executeQuery(sql, values, types);){
            DataRow row = (DataRow)reader.read();
            if (row != null) {
                Object object = row.getValue(0);
                return object;
            }
            Object var12_13 = null;
            return var12_13;
        }
    }

    private String getTargetValueAttribute() {
        return this.value_attribute == null ? this.param.getTargetPrimaryKey() : this.value_attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadTargetValueFromEntity(Map<String, Object> tar_data) {
        HashMap<String, Object> requires = new HashMap<String, Object>();
        String attribute = this.getTargetValueAttribute();
        requires.put(attribute, 1);
        ArrayList<Map<String, Object>> filter = new ArrayList<Map<String, Object>>(this.param.getJudgeFields().size());
        for (String name : this.param.getJudgeFields()) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            filter.add(item);
            item.put(FILTER_COLUMN, name);
            item.put(FILTER_COMPARE, "=");
            item.put(FILTER_VALUE, tar_data.get(name));
            item.put(FILTER_LINK, "AND");
        }
        ((Map)filter.get(filter.size() - 1)).remove(FILTER_LINK);
        String entity = this.param.getTargetSchema().getString(FULL_NAME);
        ConnectionWrapper tar = this.getTargetConnection();
        try (ObjectReader<Map<String, Object>> reader = tar.getFactory().query(tar, entity, requires, filter, null);){
            Map map = (Map)reader.read();
            Object var9_9 = map == null ? null : map.get(attribute);
            return var9_9;
        }
    }

    private Map<String, Object> loadSourceJudgeKeys(String id) {
        if (this.param.sourceIsTable()) {
            return this.loadSourceJudgeKeysFromTable(id);
        }
        if (this.param.sourceIsEntity()) {
            return this.loadSourceJudgeKeysFromEntity(id);
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\uff08%1$s\uff09\u7684\u6e90\u4e0d\u662f\u6570\u636e\u8868\u6216\u5b9e\u4f53\uff0c\u4e0d\u80fd\u7528\u4e8e\u81ea\u52a8\u6620\u5c04\u89c4\u5219\uff08%2$s\uff09\uff01", (String)"AutoMappingRule_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.param.getSchema().get(FIELD_NUMBER), this.getRuleConfig().get(FIELD_NUMBER)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadSourceDataFromEntity(String id) {
        Map<String, Object> requires = SQLUtil.prepareRequires(this.param.getSchema());
        ArrayList<Map<String, Object>> filter = new ArrayList<Map<String, Object>>();
        HashMap<String, String> item = new HashMap<String, String>();
        filter.add(item);
        item.put(FILTER_COLUMN, this.param.getSourcePrimaryKey());
        item.put(FILTER_COMPARE, "=");
        item.put(FILTER_VALUE, id);
        String entity = this.param.getSourceSchema().getString(FULL_NAME);
        ConnectionWrapper src = this.getSourceConnection();
        try (ObjectReader<Map<String, Object>> reader = src.getFactory().query(src, entity, requires, filter, null);){
            Map map = (Map)reader.read();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadSourceJudgeKeysFromEntity(String id) {
        HashMap<String, Object> requires = new HashMap<String, Object>(this.param.getSourceJudgeFields().size());
        for (String name : this.param.getSourceJudgeFields()) {
            requires.put(name, 1);
        }
        ArrayList<Map<String, Object>> filter = new ArrayList<Map<String, Object>>();
        HashMap<String, String> item = new HashMap<String, String>();
        filter.add(item);
        item.put(FILTER_COLUMN, this.param.getSourcePrimaryKey());
        item.put(FILTER_COMPARE, "=");
        item.put(FILTER_VALUE, id);
        String entity = this.param.getSourceSchema().getString(FULL_NAME);
        ConnectionWrapper src = this.getSourceConnection();
        try (ObjectReader<Map<String, Object>> reader = src.getFactory().query(src, entity, requires, filter, null);){
            Map map = (Map)reader.read();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadSourceDataFromTable(String id) {
        ConnectionWrapper cn = this.getSourceConnection();
        Table table = ConnectionManager.getTable(cn, this.param.getSourceTableName());
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        for (int i = 0; i < table.getFieldCount(); ++i) {
            Column f = table.getField(i);
            if (sql.length() > "SELECT ".length()) {
                sql.append(", ");
            }
            sql.append(f.getBinding());
        }
        sql.append(" FROM ").append(table.getQuotedName());
        Column pk = table.getPrimaryKey();
        sql.append(" WHERE ").append(pk.getBinding()).append("=?");
        List<Object> values = Collections.singletonList(pk.toSqlParam((Object)id));
        List<Integer> types = Collections.singletonList(pk.getSqlType());
        try (ObjectReader<DataRow> reader = cn.executeQuery(sql.toString(), values, types);){
            Map map = (Map)reader.read();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadSourceJudgeKeysFromTable(String id) {
        ConnectionWrapper cn = this.getSourceConnection();
        Table table = ConnectionManager.getTable(cn, this.param.getSourceTableName());
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        for (String name : this.param.getSourceJudgeFields()) {
            Column f = table.getField(name);
            if (sql.length() > "SELECT ".length()) {
                sql.append(", ");
            }
            sql.append(f.getBinding());
        }
        sql.append(" FROM ").append(table.getQuotedName());
        Column pk = table.getPrimaryKey();
        sql.append(" WHERE ").append(pk.getBinding()).append("=?");
        List<Object> values = Collections.singletonList(pk.toSqlParam((Object)id));
        List<Integer> types = Collections.singletonList(pk.getSqlType());
        try (ObjectReader<DataRow> reader = cn.executeQuery(sql.toString(), values, types);){
            Map map = (Map)reader.read();
            return map;
        }
    }

    @Override
    public boolean useDbCache() {
        DynamicObject cfg = this.getRuleConfig();
        return D.x((Object)cfg.getString("iscached"));
    }

    @Override
    public boolean useRedisCache() {
        return this.useDbCache();
    }
}

