/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.vc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.vc.AbstractValueConversionRule;
import kd.isc.iscb.platform.core.vc.ValueConversionRule;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleConfig;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

class CompositeRule
extends AbstractValueConversionRule {
    private List<ValueConversionRule> rules;

    CompositeRule(DynamicObject cfg, ConnectionWrapper src, ConnectionWrapper tar) {
        super(cfg, src, tar);
        DynamicObjectCollection items = cfg.getDynamicObjectCollection("sub_rules");
        this.rules = new ArrayList<ValueConversionRule>(items.size());
        for (DynamicObject item : items) {
            Object ruleId = item.get("sub_rule_id");
            DynamicObject sub_cfg = ValueConversionRuleConfig.getById(D.l((Object)ruleId));
            ValueConversionRule rule = ValueConversionRuleFactory.getRule(sub_cfg, src, tar);
            if (!(rule instanceof CompositeRule)) {
                this.rules.add(rule);
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u5408\u89c4\u5219\uff08%s\uff09\u4e0d\u5141\u8bb8\u5f15\u7528\u7ec4\u5408\u89c4\u5219\u4f5c\u4e3a\u5b50\u89c4\u5219\uff01", (String)"CompositeRule_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg.get("number")));
        }
    }

    @Override
    public Object cast(String param) {
        ValueConversionRule rule;
        Object value = param;
        Iterator<ValueConversionRule> iterator = this.rules.iterator();
        while (iterator.hasNext() && (value = (rule = iterator.next()).cast(value.toString())) != null) {
        }
        return value;
    }

    @Override
    public boolean useDbCache() {
        DynamicObject cfg = this.getRuleConfig();
        return D.x((Object)cfg.getString("iscached"));
    }

    @Override
    public boolean useRedisCache() {
        return this.useDbCache();
    }
}

