/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.vc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.dc.f.t.excel.SheetDataReadHelper;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.vc.MappingResultImportJobFactory;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class MappingResultImportJob
implements Job {
    public static final JobFactory FACTORY = new MappingResultImportJobFactory();
    public static final String EMPTY_STR = "";
    private AtomicInteger add = new AtomicInteger(0);
    private AtomicInteger update = new AtomicInteger(0);
    private AtomicInteger ignore = new AtomicInteger(0);
    private AtomicInteger sum = new AtomicInteger(0);
    private AtomicInteger errorNum = new AtomicInteger(0);
    private AtomicInteger index = new AtomicInteger(0);
    private AtomicInteger excelIndex = new AtomicInteger(0);
    private int excelNum;
    private long ruleID;
    private String ruleNumber;
    private AtomicInteger sheetTotalSum = new AtomicInteger(0);
    private String params;
    private String title;
    private static final String RULE_NUMBER = "rule_number";
    private static final String SRC_ID = "source_id";
    private static final String TAR_ID = "target_id";
    private static final String TAR_NUMBER = "target_number";
    private static final String SRC_NUMBER = "source_number";
    private static final String SRC_NAME = "source_name";
    private static final String TAR_NAME = "target_name";
    private static final String SIGN = "sign";
    private Object excel_tmp_id;

    public MappingResultImportJob(String params, String title) {
        this.params = params;
        this.title = title;
    }

    @Override
    public String getParam() {
        return this.params;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public final long getOwnerId() {
        return Hash.mur64((byte[])this.params.getBytes(D.UTF_8));
    }

    @Override
    public String refreshProgress() {
        return this.getDescription();
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        return new Job.Progress(this.sheetTotalSum.get(), this.index.get(), this.getDescription());
    }

    private String getDescription() {
        return String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u7b2c %1$s/%2$s \u4e2a\u6587\u4ef6\uff0c\u8fdb\u5ea6\u4e3a%3$s/%4$s\u3002\u603b\u5171\u5df2\u5904\u7406%5$s\u6761\u6570\u636e", (String)"MappingResultImportJob_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.excelIndex.get(), this.excelNum, this.index.get(), this.sheetTotalSum.get(), this.sum.get());
    }

    @Override
    public void run() {
        Map param = (Map)Json.toObject((String)this.params);
        List<Map<String, Object>> urlList = this.prepareUrls(param);
        Map<String, List<String>> judgeFields = this.getJudgeFields();
        this.excelNum = urlList.size();
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            for (Map<String, Object> map : urlList) {
                String fileUrl = D.s((Object)map.get("srcUrl"));
                if (StringUtil.isEmpty((String)fileUrl)) continue;
                this.index.set(0);
                this.excelIndex.incrementAndGet();
                this.handleEachExcelFile(judgeFields, fileUrl, cn);
            }
        }
        catch (Exception e) {
            String message = this.getNumStr() + "\n" + String.format(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"MappingResultImportJob_26", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e));
            this.rewriteRemark(message);
            throw new IscBizException(message, (Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private List<Map<String, Object>> prepareUrls(Map<String, String> param) {
        this.excel_tmp_id = param.get("excel_tmp_id");
        if (param.get("ID") != null) {
            this.ruleID = D.l((Object)param.get("ID"));
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)this.ruleID, (String)"isc_value_conver_rule", (String)"id,number");
            this.ruleNumber = D.s((Object)object.get("number"));
        }
        return AttachmentUtil.getAttachmentList("isc_excel_tmp", this.excel_tmp_id);
    }

    private Map<String, List<String>> getJudgeFields() {
        HashMap<String, List<String>> judgeFields = new HashMap<String, List<String>>();
        judgeFields.put(EMPTY_STR, new ArrayList());
        ((List)judgeFields.get(EMPTY_STR)).add(RULE_NUMBER);
        return judgeFields;
    }

    private void handleEachExcelFile(Map<String, List<String>> judgeFields, String fileUrl, Connection cn) {
        ArrayList<Object> emptySourceID = new ArrayList<Object>(10);
        HashMap<String, Map<String, Object>> dataList = new HashMap<String, Map<String, Object>>(500);
        SheetDataReadHelper reader = this.getReader(judgeFields, fileUrl);
        Map<String, Object> data = reader.read();
        while (data != null) {
            this.sum.incrementAndGet();
            this.index.incrementAndGet();
            SignalManager.checkCancelSignal();
            this.doMapping(data, emptySourceID, dataList, cn);
            data = reader.read();
        }
        if (!dataList.isEmpty()) {
            this.doMapping(dataList, cn);
        }
        if (!emptySourceID.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6e90\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5,\u5e8f\u53f7\u4e3a%s", (String)"MappingResultImportJob_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), Arrays.toString(emptySourceID.toArray())));
        }
    }

    /*
     * Exception decompiling
     */
    private SheetDataReadHelper getReader(Map<String, List<String>> judgeFields, String fileUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doMapping(Map<String, Object> excelData, List<Object> emptySourceID, Map<String, Map<String, Object>> dataList, Connection cn) {
        String sourceID = D.s((Object)excelData.get(SRC_ID));
        if (this.sourceIDIsEmpty(excelData, emptySourceID, sourceID)) {
            return;
        }
        if (!this.ruleNumber.equals(D.s((Object)excelData.get(RULE_NUMBER)))) {
            this.errorNum.incrementAndGet();
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6b64\u754c\u9762\u4e0d\u652f\u6301\u5bfc\u5165\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u503c\u8f6c\u6362\u6570\u636e\uff0c\u8bf7\u5230\u5bf9\u5e94\u503c\u8f6c\u6362\u89c4\u5219\u5bf9\u5e94\u7684\u503c\u8f6c\u6362\u6570\u636e\u5217\u8868\u4e0a\u518d\u8fdb\u884c\u5bfc\u5165", (String)"MappingResultImportJob_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), D.s((Object)excelData.get(RULE_NUMBER))));
        }
        dataList.put(sourceID, excelData);
        if (dataList.size() >= 500) {
            this.doMapping(dataList, cn);
            dataList.clear();
        }
    }

    private boolean sourceIDIsEmpty(Map<String, Object> excelData, List<Object> emptySourceID, String sourceID) {
        if (sourceID == null) {
            emptySourceID.add(D.i((Object)excelData.get("index")));
            this.errorNum.incrementAndGet();
            if (emptySourceID.size() > 100) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6e90\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u9519\u8bef\u6570\u636e\u8d85\u8fc7100\u6761\uff0c\u8bf7\u68c0\u67e5\u6570\u636e,\u5e8f\u53f7\u4e3a%s", (String)"MappingResultImportJob_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]), Arrays.toString(emptySourceID.toArray())));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMapping(Map<String, Map<String, Object>> dataList, Connection cn) {
        ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>(100);
        ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>(100);
        List<String> existedSrcIdList = this.queryExistedSrcIdList(cn, dataList);
        this.classifyData(dataList, updateList, insertList, existedSrcIdList);
        try {
            this.saveData(cn, updateList, insertList);
        }
        finally {
            this.commit(cn);
        }
    }

    private void saveData(Connection cn, List<Map<String, Object>> updateList, List<Map<String, Object>> insertList) {
        if (!insertList.isEmpty()) {
            this.insertData(cn, insertList);
        }
        if (!updateList.isEmpty()) {
            this.updateData(cn, updateList);
        }
    }

    private List<String> queryExistedSrcIdList(Connection cn, Map<String, Map<String, Object>> dataList) {
        int size = dataList.size();
        StringBuilder querySql = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>(size);
        ArrayList<Integer> types = new ArrayList<Integer>(size);
        querySql.append("select fsource_id from t_isc_mapping_data where fsource_id in (");
        for (int i = 0; i < size; ++i) {
            querySql.append('?');
            if (i < size - 1) {
                querySql.append(',');
            }
            types.add(12);
        }
        querySql.append(')');
        for (Map.Entry<String, Map<String, Object>> entry : dataList.entrySet()) {
            values.add(entry.getKey());
        }
        List dataRows = DbUtil.executeList((Connection)cn, (String)querySql.toString(), values, types);
        ArrayList<String> existedSrcIdList = new ArrayList<String>(dataRows.size());
        for (DataRow dataRow : dataRows) {
            existedSrcIdList.add(D.s((Object)dataRow.get((Object)"fsource_id")));
        }
        return existedSrcIdList;
    }

    private void classifyData(Map<String, Map<String, Object>> dataList, List<Map<String, Object>> updateList, List<Map<String, Object>> insertList, List<String> existedSrcIdList) {
        for (Map.Entry<String, Map<String, Object>> entry : dataList.entrySet()) {
            if (existedSrcIdList.contains(entry.getKey())) {
                updateList.add(entry.getValue());
                continue;
            }
            insertList.add(entry.getValue());
        }
    }

    private void commit(Connection cn) {
        try {
            if (cn != null && !cn.getAutoCommit()) {
                cn.commit();
            }
        }
        catch (SQLException e) {
            throw DatabaseError.TRANS_COMMIT_FAILURE.wrap((Throwable)e);
        }
    }

    private void insertData(Connection cn, List<Map<String, Object>> dataList) {
        String sql = "INSERT INTO  t_isc_mapping_data (fid, fmapping_rule, fsource_id, ftarget_id, fsource_number, ftarget_number, fsource_name, ftarget_name, fenable, ftarget_data,fcreatetime,fmodifytime) VALUES(?,    ?, ?, ?,   ?, ?, ?,    ?,?,?,?,?)";
        Timestamp timestamp = D.t((Object)System.currentTimeMillis());
        ArrayList<List<Object>> params = new ArrayList<List<Object>>(dataList.size());
        for (Map<String, Object> map : dataList) {
            if (D.s((Object)map.get(TAR_ID)) == null) {
                this.ignore.incrementAndGet();
                continue;
            }
            List<Object> param = Arrays.asList(IDService.get().genLongId(), this.ruleID, map.get(SRC_ID), D.s((Object)map.get(TAR_ID)), this.getStr(map.get(SRC_NUMBER)), this.getStr(map.get(TAR_NUMBER)), this.getStr(map.get(SRC_NAME)), this.getStr(map.get(TAR_NAME)), this.getEnable(D.s((Object)map.get(SIGN))), 0, timestamp, timestamp);
            params.add(param);
            this.add.incrementAndGet();
        }
        List<Integer> types = Arrays.asList(-5, -5, 12, 12, 12, 12, 12, 12, 12, -5, 93, 93);
        DbUtil.executeBatch((Connection)cn, (String)sql, params, types);
    }

    private String getStr(Object str) {
        String s = D.s((Object)str);
        if (s == null) {
            return EMPTY_STR;
        }
        return s;
    }

    private void updateData(Connection cn, List<Map<String, Object>> dataList) {
        String sql = "UPDATE   t_isc_mapping_data SET ftarget_id=?,fsource_number=?, ftarget_number=?,fsource_name=?,ftarget_name=?,fenable=?,ftarget_data=?,fmodifytime=? where fmapping_rule=? and fsource_id=?";
        ArrayList<List<Object>> params = new ArrayList<List<Object>>(dataList.size());
        for (Map<String, Object> map : dataList) {
            if (D.s((Object)map.get(TAR_ID)) == null) {
                this.ignore.incrementAndGet();
                continue;
            }
            List<Object> param = Arrays.asList(D.s((Object)map.get(TAR_ID)), this.getStr(map.get(SRC_NUMBER)), this.getStr(map.get(TAR_NUMBER)), this.getStr(map.get(SRC_NAME)), this.getStr(map.get(TAR_NAME)), this.getEnable(D.s((Object)map.get(SIGN))), 0, D.t((Object)System.currentTimeMillis()), this.ruleID, map.get(SRC_ID));
            params.add(param);
            this.update.incrementAndGet();
        }
        List<Integer> types = Arrays.asList(12, 12, 12, 12, 12, 12, -5, 93, -5, 12);
        DbUtil.executeBatch((Connection)cn, (String)sql, params, types);
    }

    private String getEnable(String s) {
        if ("valid".equals(s)) {
            return "1";
        }
        if ("unconfirmed".equals(s)) {
            return "0";
        }
        return EMPTY_STR;
    }

    private StringBuilder getNumStr() {
        StringBuilder str = new StringBuilder();
        str.append(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u5230\u7684\u6570\u636e\u603b\u6570:%1$s\uff0c\u65b0\u589e%2$s\uff0c\u66f4\u65b0%3$s\uff0c\u5931\u8d25%4$s\uff0c\u5ffd\u7565%5$s\u3002", (String)"MappingResultImportJob_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.sum.get(), this.add.get(), this.update.get(), this.errorNum.get(), this.ignore.get()));
        if (this.ignore.get() != 0) {
            str.append('\n').append(ResManager.loadKDString((String)"(\u5ffd\u7565\u539f\u56e0\uff1a\u6587\u4ef6\u4e2d\u7684\u76ee\u6807\u5355id\u4e3a\u7a7a)", (String)"MappingResultImportJob_23", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return str;
    }

    @Override
    public String getJobSummary() {
        int s = this.add.get() + this.update.get() + this.ignore.get() + this.errorNum.get();
        StringBuilder str = new StringBuilder();
        str.append(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u5df2\u5b8c\u6210", (String)"MappingResultImportJob_24", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        str.append('\n');
        str.append((CharSequence)this.getNumStr());
        if (s != this.sum.get()) {
            str.append('\n');
            str.append(ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u6e90\u5355id\uff0c\u8bf7\u68c0\u67e5", (String)"MappingResultImportJob_25", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        this.rewriteRemark(str.toString());
        return str.toString();
    }

    private void rewriteRemark(String str) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)this.excel_tmp_id, (String)"isc_excel_tmp", (String)"remark");
        object.set("remark", (Object)str);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }
}

