/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.vc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.self.SelfConnection;
import kd.isc.iscb.platform.core.connector.self.SelfConnectionFactory;
import kd.isc.iscb.platform.core.vc.AbstractValueConversionRule;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.Triple;

public class SQLRule
extends AbstractValueConversionRule {
    private String[] sqls;

    SQLRule(DynamicObject cfg, ConnectionWrapper src, ConnectionWrapper tar) {
        super(cfg, src, tar);
        String s = D.s((Object)cfg.get("sql_tag"));
        if (s == null) {
            s = D.s((Object)cfg.get("sql"));
        }
        if (s == null) {
            throw new NullPointerException(String.format(ResManager.loadKDString((String)"SQL\u89c4\u5219\uff08%s\uff09\u6ca1\u6709SQL\u8bed\u53e5\u3002", (String)"SQLRule_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg.get("number")));
        }
        this.sqls = s.split(";");
    }

    @Override
    public Object cast(String param) {
        String ruleNumber = super.getRuleConfig().getString("number");
        return SQLRule.cast(param, ruleNumber, this.sqls, this.getSourceConnection(), this.getTargetConnection());
    }

    public static Object cast(Object param, String ruleNumber, String[] sqls, ConnectionWrapper $src, ConnectionWrapper $tar) {
        String sql;
        HashMap<String, Triple<DataType, Integer, List<Object>>> ctx = new HashMap<String, Triple<DataType, Integer, List<Object>>>();
        int sqlType = DataTypeUtil.getSqlType((Object)param);
        DataType dataType = DataTypeUtil.getDataType((int)sqlType);
        ctx.put("param", new Triple((Object)dataType, (Object)sqlType, Collections.singletonList(param)));
        ConnectionWrapper cn = $src;
        String[] stringArray = sqls;
        int n = stringArray.length;
        for (int i = 0; i < n && (cn = SQLRule.execute(cn, (sql = stringArray[i]).trim(), ctx, $src, $tar)) != null; ++i) {
        }
        return SQLRule.getResult(param, ctx, ruleNumber);
    }

    private static Object getResult(Object param, Map<String, Triple<DataType, Integer, List<Object>>> ctx, String ruleNumber) {
        Triple<DataType, Integer, List<Object>> result = ctx.get("result");
        if (result == null) {
            return null;
        }
        List values = (List)result.getC();
        switch (values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return values.get(0);
            }
        }
        String message = String.format(ResManager.loadKDString((String)"\u89c4\u5219\uff08%1$s\uff09\u8fd4\u56de\u4e86\u591a\u4e2a\u7ed3\u679c\u3002\u53c2\u6570\uff1a%2$s\uff1b\u7ed3\u679c\uff1a%3$s", (String)"SQLRule_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), ruleNumber, param, values);
        throw new IscBizException(message);
    }

    private static ConnectionWrapper execute(ConnectionWrapper cn, String sql, Map<String, Triple<DataType, Integer, List<Object>>> ctx, ConnectionWrapper $src, ConnectionWrapper $tar) {
        if (sql.startsWith("declare ")) {
            return SQLRule.executeDeclare(cn, sql, ctx);
        }
        if (sql.startsWith("use ")) {
            return SQLRule.executeUse(sql, $src, $tar);
        }
        if (sql.startsWith("select ") || sql.startsWith("SELECT ")) {
            return SQLRule.executeSelect(cn, sql, ctx);
        }
        if (sql.startsWith("//")) {
            return SQLRule.executeComment(cn, sql, ctx, $src, $tar);
        }
        throw new UnsupportedOperationException(sql);
    }

    private static ConnectionWrapper executeComment(ConnectionWrapper cn, String sql, Map<String, Triple<DataType, Integer, List<Object>>> ctx, ConnectionWrapper $src, ConnectionWrapper $tar) {
        int i = sql.indexOf(10);
        if (i > 0) {
            return SQLRule.execute(cn, sql.substring(i + 1).trim(), ctx, $src, $tar);
        }
        return cn;
    }

    private static ConnectionWrapper executeSelect(ConnectionWrapper cn, String sql, Map<String, Triple<DataType, Integer, List<Object>>> ctx) {
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        sql = SQLRule.replaceVarPlaceholder(sql, ctx, values, types);
        Pair<ResultSet, Statement> p = cn.executeQuery2(sql, values, types);
        ResultSet rs = (ResultSet)p.getA();
        try {
            if (!rs.next()) {
                ConnectionWrapper connectionWrapper = null;
                return connectionWrapper;
            }
            SQLRule.getValues(sql, ctx, rs);
            ConnectionWrapper connectionWrapper = cn;
            return connectionWrapper;
        }
        catch (SQLException e) {
            throw DatabaseError.RESULT_SET_READ_FAILURE.wrap((Throwable)e);
        }
        finally {
            DbUtil.close((Statement)((Statement)p.getB()), (ResultSet)rs);
        }
    }

    private static String replaceVarPlaceholder(String sql, Map<String, Triple<DataType, Integer, List<Object>>> ctx, List<Object> values, List<Integer> types) {
        for (Map.Entry<String, Triple<DataType, Integer, List<Object>>> e : ctx.entrySet()) {
            sql = SQLRule.replaceAsParam(sql, values, types, e);
            sql = SQLRule.replaceAsLiteral(sql, e);
        }
        if (sql.contains("#{")) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"SQL\u4e2d\u5b58\u5728\u67d0\u4e9b\u53d8\u91cf\u5f15\u7528\u65e0\u6cd5\u66ff\u6362\uff0cSQL\uff1a%s", (String)"SQLRule_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), sql));
        }
        return sql;
    }

    private static String replaceAsLiteral(String sql, Map.Entry<String, Triple<DataType, Integer, List<Object>>> e) {
        Triple<DataType, Integer, List<Object>> t = e.getValue();
        StringBuilder placeHoder = new StringBuilder();
        for (Object value : (List)t.getC()) {
            if (value == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u53d8\u91cf\uff08%s\uff09\u7684\u503c\u4e2d\u5b58\u5728\u7a7a\u503c\uff0c\u4e0d\u53ef\u4f5c\u4e3a\u67e5\u8be2\u6761\u4ef6\uff01", (String)"SQLRule_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getKey()));
            }
            if (placeHoder.length() > 0) {
                placeHoder.append(", ");
            }
            placeHoder.append(value);
        }
        String key = "<%" + e.getKey() + "%>";
        int i = sql.indexOf(key);
        while (i > 0) {
            sql = sql.substring(0, i) + placeHoder + sql.substring(i + key.length());
            i = sql.indexOf(key);
        }
        return sql;
    }

    private static String replaceAsParam(String sql, List<Object> values, List<Integer> types, Map.Entry<String, Triple<DataType, Integer, List<Object>>> e) {
        String key = "#{" + e.getKey() + "}";
        int i = sql.indexOf(key);
        while (i > 0) {
            String placeHolder = SQLRule.prepareParamPlaceHolder(values, types, e);
            sql = sql.substring(0, i) + placeHolder + sql.substring(i + key.length());
            i = sql.indexOf(key);
        }
        return sql;
    }

    private static String prepareParamPlaceHolder(List<Object> values, List<Integer> types, Map.Entry<String, Triple<DataType, Integer, List<Object>>> e) {
        Triple<DataType, Integer, List<Object>> t = e.getValue();
        StringBuilder placeHolder = new StringBuilder();
        for (Object value : (List)t.getC()) {
            if (value == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u53d8\u91cf\uff08%s\uff09\u7684\u503c\u4e2d\u5b58\u5728\u7a7a\u503c\uff0c\u4e0d\u53ef\u4f5c\u4e3a\u67e5\u8be2\u6761\u4ef6\uff01", (String)"SQLRule_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getKey()));
            }
            if (placeHolder.length() > 0) {
                placeHolder.append(", ");
            }
            placeHolder.append('?');
            int type = (Integer)t.getB();
            if (type == -9) {
                type = 12;
            }
            types.add(type);
            values.add(((DataType)t.getA()).forSave(value));
        }
        return placeHolder.toString();
    }

    private static void getValues(String sql, Map<String, Triple<DataType, Integer, List<Object>>> ctx, ResultSet rs) throws SQLException {
        DataType dataType;
        String var;
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        for (i = 1; i <= meta.getColumnCount(); ++i) {
            int sqlType;
            var = meta.getColumnLabel(i);
            if (var == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"SQL\u4e2d\u7b2c %1$s \u5217\u672a\u547d\u540d\uff01SQL:%2$s", (String)"SQLRule_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), i, sql));
            }
            Triple<DataType, Integer, List<Object>> t = ctx.get(var = var.toLowerCase());
            if (t == null) {
                sqlType = meta.getColumnType(i);
                dataType = DataTypeUtil.getDataType((int)sqlType);
            } else {
                sqlType = (Integer)t.getB();
                dataType = (DataType)t.getA();
            }
            ctx.put(var, (Triple<DataType, Integer, List<Object>>)new Triple((Object)dataType, (Object)sqlType, new ArrayList()));
        }
        do {
            for (i = 1; i <= meta.getColumnCount(); ++i) {
                var = meta.getColumnLabel(i).toLowerCase();
                Triple<DataType, Integer, List<Object>> t = ctx.get(var);
                dataType = (DataType)t.getA();
                Object value = DbUtil.read((ResultSet)rs, (int)i);
                if (value == null) continue;
                ((List)t.getC()).add(dataType.narrow(value));
            }
        } while (rs.next());
    }

    private static ConnectionWrapper executeUse(String sql, ConnectionWrapper $src, ConnectionWrapper $tar) {
        if ("use $src".equals(sql)) {
            return $src;
        }
        if ("use $tar".equals(sql)) {
            return $tar;
        }
        if ("use $this".equals(sql)) {
            return new JdbcConnectionWrapper(new SelfConnection(), new SelfConnectionFactory(), null);
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5SQL\uff1a%s", (String)"SQLRule_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), sql));
    }

    private static ConnectionWrapper executeDeclare(ConnectionWrapper cn, String sql, Map<String, Triple<DataType, Integer, List<Object>>> ctx) {
        ArrayList<Object> values;
        int i = sql.indexOf(32);
        int j = sql.lastIndexOf(32);
        String var = sql.substring(i + 1, j).trim();
        String type = sql.substring(j + 1).trim();
        DataType data_type = DataTypeUtil.getDataType((String)type);
        int sql_type = DataTypeUtil.getSqlType((String)type);
        Triple<DataType, Integer, List<Object>> t = ctx.get(var);
        if (t == null) {
            values = new ArrayList<Object>(1);
        } else {
            values = new ArrayList(1);
            for (Object value : (List)t.getC()) {
                values.add(data_type.narrow(value));
            }
        }
        ctx.put(var, (Triple<DataType, Integer, List<Object>>)new Triple((Object)data_type, (Object)sql_type, values));
        return cn;
    }

    @Override
    public boolean useDbCache() {
        DynamicObject cfg = this.getRuleConfig();
        return D.x((Object)cfg.getString("iscached"));
    }

    @Override
    public boolean useRedisCache() {
        return this.useDbCache();
    }
}

