/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.vc;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.consume.IscConsumeInfo;
import kd.isc.iscb.platform.core.dc.e.v.EvaluatorFactory;
import kd.isc.iscb.platform.core.dc.e.v.PropertyAssembler;
import kd.isc.iscb.platform.core.syndata.MapDataUtil;
import kd.isc.iscb.platform.core.vc.AbstractValueConversionRule;
import kd.isc.iscb.platform.core.vc.AutoMappingRule;
import kd.isc.iscb.platform.core.vc.CompositeRule;
import kd.isc.iscb.platform.core.vc.ConstLookupTable;
import kd.isc.iscb.platform.core.vc.JavaRule;
import kd.isc.iscb.platform.core.vc.ManualMappingRule;
import kd.isc.iscb.platform.core.vc.SQLRule;
import kd.isc.iscb.platform.core.vc.ScriptRule;
import kd.isc.iscb.platform.core.vc.ValueConversionException;
import kd.isc.iscb.platform.core.vc.ValueConversionRule;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleProxy;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleProxy2;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class ValueConversionRuleFactory {
    private static final String FIELD_NUMBER = "number";

    public static Object test(long ruleId, String value) {
        return MapDataUtil.findMappingValue(ruleId, value);
    }

    public static ValueConversionRule getRule(DynamicObject cfg, ConnectionWrapper src, ConnectionWrapper tar) {
        String type = cfg.getString("rule_type");
        AbstractValueConversionRule rule = null;
        if ("mapping".equals(type)) {
            rule = new ManualMappingRule(cfg, src, tar);
        } else if ("auto".equals(type)) {
            rule = new AutoMappingRule(cfg, src, tar);
        } else if ("sql".equals(type)) {
            rule = new SQLRule(cfg, src, tar);
        } else if ("java".equals(type)) {
            rule = new JavaRule(cfg, src, tar);
        } else if ("tlb".equals(type)) {
            rule = new ConstLookupTable(cfg, src, tar);
        } else if ("composite".equals(type)) {
            rule = new CompositeRule(cfg, src, tar);
        } else if ("script".equals(type)) {
            rule = new ScriptRule(cfg, src, tar);
        } else {
            throw new UnsupportedOperationException("TODO - " + type);
        }
        long srcDblinkId = D.l((Object)src.getConfig().getPkValue());
        long tarDblinkId = D.l((Object)tar.getConfig().getPkValue());
        boolean isDisableRedirect = ValueConversionRuleFactory.isDisableRedirect(cfg, srcDblinkId, tarDblinkId);
        if (isDisableRedirect) {
            return new ValueConversionRuleProxy(rule);
        }
        return new ValueConversionRuleProxy2(rule, srcDblinkId, tarDblinkId);
    }

    private static boolean isDisableRedirect(DynamicObject cfg, long srcDblinkId, long tarDblinkId) {
        long ruleSrcDbinkId = DataSource.get(cfg.getLong("source_data_source_id")).getDbLinkId();
        long ruleTarDblinkId = DataSource.get(cfg.getLong("target_data_source_id")).getDbLinkId();
        return srcDblinkId == ruleSrcDbinkId && tarDblinkId == ruleTarDblinkId;
    }

    public static Object run(PropertyAssembler p, ValueConversionRule rule, String value) {
        Object object;
        long start = System.currentTimeMillis();
        try {
            object = ValueConversionRuleFactory.innerRun(rule, value, p);
        }
        catch (Exception e) {
            try {
                throw ValueConversionRuleFactory.castError(rule, e);
            }
            catch (Throwable throwable) {
                String title = StringUtil.trim((String)String.format(ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219\u540d\u79f0\u3010%s\u3011", (String)"ValueConversionRuleFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), rule.getRuleConfig().getString("name")), (int)400);
                IscConsumeInfo.recordOnce(start, rule.getRuleConfig(), title);
                throw throwable;
            }
        }
        String title = StringUtil.trim((String)String.format(ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219\u540d\u79f0\u3010%s\u3011", (String)"ValueConversionRuleFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), rule.getRuleConfig().getString("name")), (int)400);
        IscConsumeInfo.recordOnce(start, rule.getRuleConfig(), title);
        return object;
    }

    private static ValueConversionException castError(ValueConversionRule rule, Exception e) {
        if (e instanceof ValueConversionException) {
            return (ValueConversionException)((Object)e);
        }
        String message = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\uff08%1$s)\u6267\u884c\u5931\u8d25\u3002\u539f\u56e0\uff1a%2$s", (String)"ValueConversionRuleFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), rule.getRuleConfig().getString(FIELD_NUMBER), e.getMessage());
        return new ValueConversionException(message, e);
    }

    private static Object innerRun(ValueConversionRule rule, String value, PropertyAssembler p) {
        DynamicObject cfg;
        String default_value;
        if (value != null) {
            try {
                Object v = rule.cast(value);
                if (v != null) {
                    return v;
                }
            }
            catch (Exception e) {
                DynamicObject cfg2 = rule.getRuleConfig();
                ValueConversionException err = new ValueConversionException(String.format(ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff1a%2$s\uff09\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u201c%3$s\u201d\u4f5c\u4e3a\u53c2\u6570\u503c\u6d4b\u8bd5\u8be5\u503c\u8f6c\u6362\u89c4\u5219\u83b7\u53d6\u66f4\u591a\u4fe1\u606f\u6216\u8c03\u6574\u8be5\u89c4\u5219\u3002", (String)"ValueConversionRuleFactory_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg2.getString(FIELD_NUMBER), cfg2.getString("name"), value), e);
                throw err;
            }
        }
        if ((default_value = D.s((Object)(cfg = rule.getRuleConfig()).get("default_value"))) != null) {
            return ValueConversionRuleFactory.parseDefaultValue(value, cfg.getString(FIELD_NUMBER), cfg.getString("name"), default_value);
        }
        if (value == null) {
            return "";
        }
        if (p != null) {
            String message = String.format(ResManager.loadKDString((String)"\u6839\u636e\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff1a%2$s\uff09\u5bf9\u6e90\u7cfb\u7edf\u5b57\u6bb5\u503c\uff08%3$s\uff09\u8fdb\u884c\u8f6c\u6362\u7684\u7ed3\u679c\u4e3a\u201c\u7a7a\u201d\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u76ee\u6807\u7cfb\u7edf\u5b57\u6bb5\uff08%4$s\uff09\u7684\u8d4b\u503c\u3002", (String)"ValueConversionRuleFactory_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg.getString(FIELD_NUMBER), cfg.getString("name"), value, p.getProperty()) + "\r\n" + ValueConversionRuleFactory.getExTips();
            throw new ValueConversionException(message);
        }
        String message = String.format(ResManager.loadKDString((String)"\u6839\u636e\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff1a%2$s\uff09\u5bf9\u6e90\u7cfb\u7edf\u5b57\u6bb5\u503c\uff08%3$s\uff09\u8fdb\u884c\u8f6c\u6362\u7684\u7ed3\u679c\u4e3a\u201c\u7a7a\u201d\u3002", (String)"ValueConversionRuleFactory_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cfg.getString(FIELD_NUMBER), cfg.getString("name"), value) + "\r\n" + ValueConversionRuleFactory.getExTips();
        throw new ValueConversionException(message);
    }

    public static Object parseDefaultValue(String srcValue, String vcNumber, String vcName, String default_value) {
        if ("#{null}".equals(default_value)) {
            return "";
        }
        if ("#{param}".equals(default_value)) {
            return srcValue;
        }
        if ("#{zero_as_null}".equals(default_value)) {
            if ("0".equals(srcValue) || srcValue == null) {
                return "";
            }
            throw new ValueConversionException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff1a%2$s\uff09\u5bf9\u6e90\u7cfb\u7edf\u5b57\u6bb5\u503c\uff08%3$s\uff09\u8fdb\u884c\u8f6c\u6362\u7684\u7ed3\u679c\u4e3a\u201c\u7a7a\u201d\uff0c\u4e14\u53c2\u6570\u503c\u201c%4$s\u201d\u4e0d\u4e3a0\uff0c\u672a\u80fd\u8f6c\u4e3anull\uff0c\u8f6c\u6362\u5931\u8d25\u3002", (String)"ValueConversionRuleFactory_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), vcNumber, vcName, srcValue, srcValue) + "\r\n" + ValueConversionRuleFactory.getExTips());
        }
        try {
            return EvaluatorFactory.get(null, default_value, null).eval(null, null, null);
        }
        catch (Exception e) {
            ValueConversionException err = new ValueConversionException(String.format(ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219\uff08%1$s\uff1a%2$s\uff09\u7684\u9ed8\u8ba4\u503c\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9ed8\u8ba4\u503c\u8bbe\u7f6e\u3002", (String)"ValueConversionRuleFactory_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), vcNumber, vcName), e);
            throw err;
        }
    }

    public static final String getExTips() {
        return ResManager.loadKDString((String)"\u89e3\u51b3\u529e\u6cd5\uff1a\u8bf7\u68c0\u67e5\uff081\uff09\u4f9d\u8d56\u7684\u57fa\u7840\u8d44\u6599\u662f\u5426\u5df2\u540c\u6b65\uff1b\uff082\uff09\u4f7f\u7528\u7684\u503c\u8f6c\u6362\u89c4\u5219\u662f\u5426\u6070\u5f53\uff1b\uff083\uff09\u503c\u8f6c\u6362\u89c4\u5219\u7684\u5b9e\u73b0\u662f\u5426\u6b63\u786e\uff0c\u53c2\u8003\u8d44\u6599\uff1aclub.kdcloud.com/article/45419\u3002", (String)"ValueConversionRuleFactory_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }
}

