/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.opplugin.common;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class ResourceHistorySavePlugin
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] objects = args.getDataEntities();
        DynamicObject[] histories = new DynamicObject[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            DynamicObject obj = objects[i];
            String json = Json.toString((Object)DynamicObjectUtil.object2Map((DynamicObject)obj), (boolean)true);
            DynamicObject his = BusinessDataServiceHelper.newDynamicObject((String)"isc_res_history");
            his.set("res_type", (Object)obj.getDataEntityType().getName());
            his.set("operate_key", (Object)args.getOperationKey());
            his.set("res_number", obj.get("number"));
            String name = StringUtil.trim((String)obj.getString("name"), (int)50);
            his.set("res_name", (Object)name);
            his.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
            his.set("operator", (Object)D.l((Object)RequestContext.get().getUserId()));
            his.set("res_content", (Object)"...");
            if ("isc_database_link".equals(obj.getDataEntityType().getName())) {
                json = this.removeSecretInfo(json);
            }
            his.set("res_content_tag", (Object)json);
            his.set("resid", obj.getPkValue());
            his.set("version", this.getVersion(obj.getPkValue()));
            histories[i] = his;
        }
        SaveServiceHelper.save((DynamicObject[])histories);
    }

    private String removeSecretInfo(String json) {
        List<String> secretFields = Arrays.asList("appsecret", "appsecret_new", "password", "newpwd", "attr_e2", "attr_e1");
        Map map = (Map)Json.toObject((String)json);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("config_") && !secretFields.contains(entry.getKey())) continue;
            entry.setValue("***");
        }
        return Json.toString((Object)map, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getVersion(Object pkValue) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            String sql = "SELECT MAX(fversion) FROM t_iscb_res_history WHERE fres_id=?";
            int version = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql, Collections.singletonList(pkValue), Collections.singletonList(-5)));
            Integer n = version + 1;
            return n;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }
}

