/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.opplugin.dc;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.platform.core.util.CommonUtil;

public class DataCopySchemaSaveOp
extends AbstractOperationServicePlugIn {
    private static final String SCHEMA_CATEGORY = "schema_category";
    private static final String ISC_DATA_COPY_TRIGGER = "isc_data_copy_trigger";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if ("save".equals(e.getOperationKey())) {
            this.refeshDataCopyTrigger(e);
        }
    }

    private void refeshDataCopyTrigger(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length > 0) {
            for (DynamicObject d : dataEntities) {
                long schemaId = d.getLong("id");
                String categoryName = d.getString("schema_category.name");
                DynamicObject[] triggers = this.getDataCopyTrigger(schemaId, categoryName);
                ArrayList<Object> triggerIds = new ArrayList<Object>(triggers.length);
                for (DynamicObject trigger : triggers) {
                    Object triggerId = trigger.get("id");
                    triggerIds.add(triggerId);
                }
                this.setParam(categoryName, triggerIds);
            }
        }
    }

    private void setParam(String categoryName, List<Object> triggerIds) {
        DynamicObject[] tgs;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ISC_DATA_COPY_TRIGGER);
        for (DynamicObject tg : tgs = BusinessDataServiceHelper.load((Object[])triggerIds.toArray(), (DynamicObjectType)entityType)) {
            tg.set(SCHEMA_CATEGORY, (Object)categoryName);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)ISC_DATA_COPY_TRIGGER, (DynamicObject[])new DynamicObject[]{tg}, (OperateOption)OperateOption.create());
            CommonUtil.check((OperationResult)operationResult);
        }
    }

    private DynamicObject[] getDataCopyTrigger(long schemaId, String categoryName) {
        QFilter filter1 = new QFilter("data_copy", "=", (Object)schemaId);
        QFilter filter2 = null;
        filter2 = categoryName == null ? new QFilter(SCHEMA_CATEGORY, "is not null", (Object)categoryName) : new QFilter(SCHEMA_CATEGORY, "<>", (Object)categoryName);
        return BusinessDataServiceHelper.load((String)ISC_DATA_COPY_TRIGGER, (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
    }
}

