/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.opplugin.ext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.except.IscBizException;

public class AbstractEnableDisableOp
extends AbstractOperationServicePlugIn {
    static final Map<String, String> ENTITY_RELATIONS = new HashMap<String, String>(6);
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    public static final String SAVE = "save";
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String ISC_CONNECTION_TYPE_X = "isc_connection_type_x";
    public static final String ISC_DATA_SOURCE = "isc_data_source";

    protected void clean() {
        ENTITY_RELATIONS.clear();
    }

    public static String getEntity(String entity) {
        return ENTITY_RELATIONS.get(entity);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        try {
            this.executeOperation(e, operationKey);
        }
        catch (Exception ex) {
            e.setCancel(true);
            e.setCancelMessage(ShowStackTraceUtil.getErrorMsg((Throwable)ex));
        }
    }

    private void executeOperation(BeforeOperationArgs e, String operationKey) {
        String icEntityName = this.billEntityType.getName();
        if (ENABLE.equals(operationKey)) {
            this.enable(e.getDataEntities(), icEntityName);
        } else if (DISABLE.equals(operationKey)) {
            this.disable(e.getDataEntities(), icEntityName);
        }
    }

    public void enable(DynamicObject[] dataEntities, String icEntityName) {
        DynamicObject[] icObjs;
        String iscEntity = ENTITY_RELATIONS.get(icEntityName);
        this.checkModelType(iscEntity, icEntityName);
        Object[] pks = this.getPrimaryKeys(dataEntities);
        for (DynamicObject icObj : icObjs = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)icEntityName))) {
            this.publish(icObj, iscEntity);
        }
    }

    private void checkModelType(String iscEntity, String entity) {
        if (iscEntity == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5355\u636e[%s]\uff1a1\u3001\u662f\u5426\u7ee7\u627f\u4e86\u5355\u636e[isc_cn_config]\uff1b2\u3001\u662f\u5426\u7ee7\u627f\u521b\u5efa\u7684\u662f\u3010\u5e03\u5c40\u3011\u800c\u975e\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"AbstractEnableDisableOp_0", (String)"isc-iscb-platform-opplugin", (Object[])new Object[0]), entity));
        }
    }

    public void disable(DynamicObject[] dataEntities, String icEntityName) {
        String iscEntity = ENTITY_RELATIONS.get(icEntityName);
        this.checkModelType(iscEntity, icEntityName);
        Object[] pks = this.getPrimaryKeys(dataEntities);
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)iscEntity));
        if (objs == null || objs.length == 0) {
            return;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objs) {
            if (!obj.getBoolean(ENABLE)) continue;
            this.beforeDisable(obj);
            list.add(obj);
        }
        List responses = ExecutionData.batchExecute((String)iscEntity, list, (SaveDataType)SaveDataType.SAVE, (String)DISABLE);
        this.checkResponses(responses);
    }

    private Object[] getPrimaryKeys(DynamicObject[] dataEntities) {
        Object[] pks = new Object[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            pks[i] = dataEntities[i].getPkValue();
        }
        return pks;
    }

    private void checkResponses(List<Response> responses) {
        for (Response res : responses) {
            if (SaveDataType.FAILED != res.getType()) continue;
            String id = res.getId();
            OperateErrorInfo info = new OperateErrorInfo("", ErrorLevel.Error, (Object)id);
            info.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636eID:%1$s\u542f\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s", (String)"AbstractEnableDisableOp_2", (String)"isc-iscb-platform-opplugin", (Object[])new Object[0]), id, res.getErrorMessage()));
            this.operationResult.addErrorInfo(info);
        }
    }

    private void publish(DynamicObject icObject, String iscEntity) {
        Object id = icObject.get(ID);
        DynamicObject iscObject = QueryServiceHelper.exists((String)iscEntity, (Object)id) ? BusinessDataServiceHelper.loadSingle((Object)id, (String)iscEntity) : BusinessDataServiceHelper.newDynamicObject((String)iscEntity);
        this.beforePublish(icObject, iscObject);
        this.publish2Isc(icObject, iscObject, iscEntity);
        this.afterPublish(icObject);
    }

    public List<String> getOperationType(DynamicObject icObj, String iscEntity) {
        ArrayList<String> operationTypes = new ArrayList<String>(2);
        if (!this.isEnabled(iscEntity, icObj)) {
            operationTypes.add(SAVE);
            operationTypes.add(ENABLE);
        }
        return operationTypes;
    }

    public boolean isEnabled(String iscEntity, DynamicObject icObj) {
        Object id = icObj.get(ID);
        if (QueryServiceHelper.exists((String)iscEntity, (Object)id)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)iscEntity, (String)ENABLE);
            String enable = dynamicObject.getString(ENABLE);
            return "1".equals(enable);
        }
        return false;
    }

    protected void beforePublish(DynamicObject icObject, DynamicObject iscObject) {
    }

    protected void publish2Isc(DynamicObject icObj, DynamicObject iscObject, String iscEntity) {
    }

    protected void afterPublish(DynamicObject icObj) {
    }

    protected void beforeDisable(DynamicObject icObj) {
    }

    static {
        ENTITY_RELATIONS.put(ISC_CONNECTION_TYPE_X, "isc_connection_type");
        ENTITY_RELATIONS.put("isc_data_source_x", ISC_DATA_SOURCE);
        ENTITY_RELATIONS.put("isc_apic_script_x", "isc_apic_script");
        ENTITY_RELATIONS.put("isc_cn_config", "isc_database_link");
        ENTITY_RELATIONS.put("isc_interface_category", "isc_schema_category");
    }
}

