/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp;

import java.sql.Connection;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.connector.ierp.IerpConnectorUtil;
import kd.isc.iscb.platform.core.connector.ierp.IerpUtil;
import kd.isc.iscb.platform.core.connector.self.SelfConnection;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.Returns;
import kd.isc.iscb.util.connector.server.SerializableResultManager;
import kd.isc.iscb.util.connector.server.SerializableReturns;
import kd.isc.iscb.util.connector.server.hub.ConnectorUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Json;

public class IerpConnectorContext
implements ConnectorContext {
    private String iscHub;
    private boolean supportMultiHub;
    private static Log log = LogFactory.getLog(DataCopyTask.class);

    public IerpConnectorContext() {
    }

    public IerpConnectorContext(String iscHub) {
        this.iscHub = iscHub;
        this.supportMultiHub = ConnectorUtil.supportMultiHub((String)IerpUtil.getAccountKey());
    }

    public String getKey() {
        String sqlKey = D.s((Object)IerpConnectorUtil.getSQLKey());
        if (sqlKey == null || "#".equals(sqlKey)) {
            return Cipher.DEFAULT_KEY;
        }
        return sqlKey;
    }

    public Connection getConnection() {
        return new SelfConnection();
    }

    public void dispose(Connection cn) {
        DbUtil.close((Connection)cn, (boolean)false);
    }

    public boolean supportsTransaction() {
        return false;
    }

    public void logger(String message, Throwable error) {
        log.warn(message, error);
    }

    public void logger(String command, String sql, Map<String, Object> params) {
        StringBuilder message = new StringBuilder();
        message.append("Command:").append(command).append("\r\n");
        if (sql != null) {
            message.append("Sql:").append(command).append("\r\n");
        }
        message.append("Params:").append(Json.toString(params));
        log.info(message.toString());
    }

    public boolean isValid(String meta, ConnectorContext.Operation op) {
        PermissionMode mode;
        String dataCenter = IerpUtil.getAccountKey();
        PermissionMode permissionMode = mode = this.supportMultiHub ? ConnectorUtil.getPermissionMode((String)this.iscHub) : ConnectorCallback.getPermissionMode((String)dataCenter);
        if (PermissionMode.PUBLIC.equals((Object)mode)) {
            return true;
        }
        if (PermissionMode.DENY_ALL.equals((Object)mode)) {
            return false;
        }
        if (this.supportMultiHub) {
            return ConnectorUtil.hasPermission((String)this.iscHub, (String)meta, (ConnectorContext.Operation)op, (ConnectorContext)this);
        }
        return IscHubConfigUtil.hasPermission((String)dataCenter, (String)meta, (ConnectorContext.Operation)op, (ConnectorContext)this);
    }

    public Returns createReturns(String command) {
        return new SerializableReturns((ConnectorContext)this);
    }

    public Object getResult(String id) {
        return SerializableResultManager.getResult((ConnectorContext)this, (String)id);
    }

    public void removeResult(String id) {
        SerializableResultManager.removeChunks((ConnectorContext)this, (String)id);
    }
}

