/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.security.SecureRandom;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.connector.ierp.IerpConnectorInitEnv;
import kd.isc.iscb.connector.ierp.ResultSliceCleanTask;
import kd.isc.iscb.platform.core.connector.ierp.IerpUtil;
import kd.isc.iscb.platform.core.connector.self.IscBizListener;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.hub.ConnectorUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Pair;

public class IerpConnectorUtil {
    private static final Log logger = LogFactory.getLog(IerpConnectorUtil.class);
    private static final Map<Pair<String, String>, ResultSliceCleanTask> cleaners = new ConcurrentHashMap<Pair<String, String>, ResultSliceCleanTask>();
    private static final SecureRandom rnd = new SecureRandom();
    private static final SecureRandom random;

    private static boolean supportMultiHub(Account c) {
        String iscSupportMultiHubDcList = D.s((Object)System.getProperty(c.getTenantId() + "_isc_support_multi_hub_dc_list"));
        if (iscSupportMultiHubDcList == null) {
            iscSupportMultiHubDcList = D.s((Object)System.getProperty("isc_support_multi_hub_dc_list"));
        }
        return iscSupportMultiHubDcList != null && iscSupportMultiHubDcList.contains(c.getAccountId());
    }

    public static void initAccount() {
        try {
            IerpConnectorUtil.initIscHubTable();
            IscBizListener.init();
            IerpConnectorUtil.createCleanSliceJob();
        }
        catch (Exception e) {
            logger.warn("\u82cd\u7a79\u8fde\u63a5\u5668\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8d26\u5957ID=" + RequestContext.get().getAccountId(), (Throwable)e);
            throw e;
        }
    }

    private static void initIscHubTable() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            String accountKey = IerpUtil.getAccountKey();
            if (ConnectorUtil.supportMultiHub((String)accountKey)) {
                ConnectorUtil.removeAllCacheByDataCenter((String)accountKey);
                ConnectorUtil.clearInvalidConfigs((Connection)cn);
                ConnectorUtil.registerHubCache((String)accountKey, (Connection)cn);
            } else {
                Map loginInfo = IscHubConfigUtil.loadIscHubServerInfo((Connection)cn, (String)accountKey);
                if (loginInfo != null) {
                    IscHubConfigUtil.loadIscHubPermissions((Connection)cn, (String)accountKey);
                }
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static void createCleanSliceJob() {
        ResultSliceCleanTask task;
        String tenant;
        String account = RequestContext.get().getAccountId();
        Pair info = new Pair((Object)account, (Object)(tenant = RequestContext.get().getTenantId()));
        if (cleaners.putIfAbsent((Pair<String, String>)info, task = new ResultSliceCleanTask(account, tenant)) == null) {
            RequestContext ctx = ContextUtil.createRequestContext((String)account, (String)tenant);
            ScheduleManager.submit((Task)task, (RequestContext)ctx, (int)(random.nextInt(600) + 600));
        }
    }

    public static void checkPermission(ConnectorContext ctx, String meta, ConnectorContext.Operation op) {
        if (meta == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6821\u9a8c\u6743\u9650\u3002", (String)"IerpConnectorUtil_0", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]));
        }
        if (!ctx.isValid(meta, op)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fde\u63a5\u5668\u672a\u90e8\u7f72\u6216\u672a\u6388\u6743, \u65e0\u6743\u9650\u6267\u884c%1$s\u7684%2$s\u64cd\u4f5c\u3002", (String)"IerpConnectorUtil_1", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]), meta, op.name()));
        }
    }

    public static void checkReadOrWritePermission(ConnectorContext ctx, String meta) {
        if (meta == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6821\u9a8c\u6743\u9650\u3002", (String)"IerpConnectorUtil_0", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]));
        }
        if (!ctx.isValid(meta, ConnectorContext.Operation.WRITE) && !ctx.isValid(meta, ConnectorContext.Operation.READ)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fde\u63a5\u5668\u672a\u90e8\u7f72\u6216\u672a\u6388\u6743\uff0c\u65e0\u6cd5\u83b7\u53d6%s\u4fe1\u606f\u3002", (String)"IerpConnectorUtil_3", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]), meta));
        }
    }

    public static void checkPermission(ConnectorContext ctx, String mainTable, Map<String, Pair<Table, String>> _entryTables, ConnectorContext.Operation op) {
        if (!ctx.isValid(mainTable, op)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u6267\u884c\u6570\u636e\u8868%1$s\u7684%2$s\u64cd\u4f5c\u3002", (String)"IerpConnectorUtil_4", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]), mainTable, op.name()));
        }
        for (Pair<Table, String> value : _entryTables.values()) {
            String name = ((Table)value.getA()).getName();
            if (ctx.isValid(mainTable, op)) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u6267\u884c\u6570\u636e\u8868%1$s\u7684%2$s\u64cd\u4f5c\u3002", (String)"IerpConnectorUtil_4", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]), mainTable, op.name()));
        }
    }

    public static void broadcastPermission() {
        String account = RequestContext.get().getAccountId();
        String tenant = RequestContext.get().getTenantId();
        IerpConnectorUtil.refreshPermission(account, tenant);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)IerpConnectorUtil.class.getName(), (String)"refreshPermission", (Object[])new String[]{account, tenant});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshPermission(String account, String tenant) {
        RequestContext ctx = ContextUtil.createRequestContext((String)account, (String)tenant);
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            IscHubConfigUtil.loadIscHubPermissions((Connection)cn, (String)IerpUtil.getAccountKey());
        }
        catch (Exception e) {
            logger.warn("\u82cd\u7a79\u8fde\u63a5\u5668\u7aef\u8d44\u6e90\u6388\u6743\u7f13\u5b58\u5237\u65b0\u5931\u8d25!", (Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    public static String getDeployKey(String appId) {
        String appSecret = IerpConnectorUtil.getAppSecret(appId);
        if (appSecret.length() > 60) {
            return appSecret.substring(0, appSecret.length() - 32);
        }
        return appSecret;
    }

    public static String getAppSecret(String appId) {
        Assert.notNull((Object)appId, (String)ResManager.loadKDString((String)"appId\u4e3a\u7a7a\u3002", (String)"IerpConnectorUtil_5", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]));
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)appId)};
        Object[] objects = BusinessDataServiceHelper.load((String)"open_3rdapps", (String)"id, number, syspwd", (QFilter[])filters, null, (int)1);
        if (!CollectionUtils.isEmpty((Object[])objects)) {
            return objects[0].getString("syspwd");
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u5f00\u653e\u5e94\u7528\u3002", (String)"IerpConnectorUtil_6", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]), appId));
    }

    public static String getSQLKey() {
        String iscIerpSqlKey = ContextUtil.getTenantProperty((String)"ISC_IERP_SQL_KEY");
        logger.info("IERP\u8fdc\u7aefkey:" + iscIerpSqlKey);
        if (Encrypters.isEncrypted((String)iscIerpSqlKey)) {
            return Encrypters.decode((String)iscIerpSqlKey);
        }
        return iscIerpSqlKey;
    }

    public static JSONObject decryptData(Map<String, Object> params) {
        String encryptData = D.s((Object)params.get("encryptData"));
        String key = IerpConnectorUtil.getDeployKey(D.s((Object)params.get("appId")));
        String data = Cipher.decrypt((String)encryptData, (String)key);
        return JSON.parseObject((String)data);
    }

    static {
        logger.info("start invoke IerpConnectorInitEnv");
        try {
            int delay = 5;
            RequestContext ctx = null;
            int offset = rnd.nextInt(20);
            for (Account c : AccountUtils.getAllAccountsOfCurrentEnv()) {
                if (IerpConnectorUtil.supportMultiHub(c)) {
                    ConnectorUtil.openMultiHubSupport((String)(c.getAccountId() + "," + c.getTenantId()));
                }
                ctx = ContextUtil.createRequestContext((String)c.getAccountId(), (String)c.getTenantId());
                ScheduleManager.submit((Task)new IerpConnectorInitEnv(c.getAccountId()), (RequestContext)ctx, (int)(delay++ * 5 + offset));
                logger.info("submit IerpConnectorInitEnv task" + c.getAccountId());
            }
        }
        catch (Throwable e) {
            logger.warn("IerpConnectorUtil init failed.", e);
        }
        random = new SecureRandom();
    }
}

