/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp;

import java.sql.Connection;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.connector.server.SerializableResultManager;
import kd.isc.iscb.util.db.DbUtil;

public class ResultSliceCleanTask
implements Task {
    private static final Log logger = LogFactory.getLog(ResultSliceCleanTask.class);
    private String id;
    private String account;
    private String tenant;

    public ResultSliceCleanTask(String account, String tenant) {
        this.account = account;
        this.tenant = tenant;
        this.id = "SLICE:" + this.account + "\n" + this.tenant;
    }

    public String getId() {
        return this.id;
    }

    public void run() {
        RequestContext current = RequestContext.get();
        try {
            RequestContext ctx = ContextUtil.createRequestContext((String)this.account, (String)this.tenant);
            RequestContextCreator.restoreForMQ((RequestContext)ctx);
            this.deleteTimeoutResults(ctx);
        }
        catch (Throwable e) {
            logger.warn("failed to delete timeout results.", e);
        }
        finally {
            if (current != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
    }

    private void deleteTimeoutResults(RequestContext ctx) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            SerializableResultManager.cleanResultsOfTimeout((Connection)cn);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
            ScheduleManager.submit((Task)this, (RequestContext)ctx, (int)3600);
        }
    }
}

