/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp.svc;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.connector.ierp.IerpConnectorUtil;
import kd.isc.iscb.platform.core.connector.ierp.IerpUtil;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.hub.ConnectorUtil;
import kd.isc.iscb.util.data.Counter;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class RemoteDeployService
extends AbstractCommandExecutor {
    private static final Counter DEPLOY_COUNTER = new Counter(720000, 120);

    public String getCommand() {
        return "remote_deploy";
    }

    public Object exec(ConnectorContext ctx, Map<String, Object> params) {
        this.checkInit(ctx, params);
        this.checkSqlKey(ctx, params);
        IerpConnectorUtil.initAccount();
        this.saveIscServerInfo(params);
        IerpConnectorUtil.initAccount();
        if (ConnectorUtil.supportMultiHub((String)IerpUtil.getAccountKey())) {
            String iscHub = D.s((Object)params.get("isc_hub"));
            ConnectorUtil.testCallbackIerp((String)IerpUtil.getAccountKey(), (String)iscHub, (String)ConnectorUtil.getIerpServerURL((String)iscHub));
        } else {
            String url = D.s((Object)params.get("ierp_server_url"));
            this.testCallbackIerp(url);
        }
        Object[] p = new String[]{RequestContext.get().getAccountId(), RequestContext.get().getTenantId()};
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)RemoteDeployService.class.getName(), (String)"refreshCluster", (Object[])p);
        return "ok";
    }

    private void checkSqlKey(ConnectorContext ctx, Map<String, Object> params) {
        String sql_key_hash = D.s((Object)params.get("sql_key_hash"));
        String salt = D.s((Object)params.get("sql_key_salt"));
        if (sql_key_hash == null) {
            return;
        }
        String mcIerpKey = ctx.getKey();
        if (!sql_key_hash.equals(D.s((Object)Hash.mur64((byte[])(salt + mcIerpKey).getBytes(StandardCharsets.UTF_8))))) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5f53\u524d\u91d1\u8776\u4e91\u00b7\u82cd\u7a79\uff08\u8fdc\u7aef\uff09\u8fde\u63a5\u914d\u7f6e\u8be6\u60c5\u6240\u8bbe\u7f6e\u3010SQL\u52a0\u5bc6key\u3011\u4e0e\u6240\u8fde\u63a5\u8fdc\u7aef\u82cd\u7a79\u73af\u5883\u8bbe\u7f6e\u7684\u79df\u6237\u7ea7\u53c2\u6570\u3010ISC_IERP_SQL_KEY\u3011\u4e0d\u7b26\uff0c\u7531\u4e8e\u5b89\u5168\u56e0\u7d20\u8003\u8651\uff0c\u8bf7\u4fdd\u8bc1\u4e24\u8fb9\u6240\u8bbe\u7f6e\u5bc6\u94a5\u4e00\u81f4\uff0c\u5e76\u91cd\u65b0\u8fdb\u884c\u90e8\u7f72\u3002", (String)"RemoteDeployService_0", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]));
        }
    }

    public static void refreshCluster(String account, String tenant) {
        RequestContext ctx = ContextUtil.createRequestContext((String)account, (String)tenant);
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
        IerpConnectorUtil.initAccount();
    }

    private void testCallbackIerp(String url) {
        try {
            String accountKey = IerpUtil.getAccountKey();
            ConnectorCallback.call((String)accountKey, (String)"test", new HashMap());
        }
        catch (Throwable e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fde\u63a5\u5668\u53cd\u8c03\u82cd\u7a79\u96c6\u6210\u4e91\u65f6\u62a5\u9519\uff0curl:%1$s,\u9519\u8bef\u5185\u5bb9:", (String)"RemoteDeployService_1", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]), url), e);
        }
    }

    private void checkInit(ConnectorContext ctx, Map<String, Object> params) {
        this.checkInitFrequency();
        RemoteDeployService.checkForDeploy(ctx, params);
    }

    private void checkInitFrequency() {
        DEPLOY_COUNTER.inc(1);
        if (DEPLOY_COUNTER.get() > 120) {
            throw new IscBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6b21\u6570\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\uff08\u6bcf\u5929\u4e0d\u8d85\u8fc7120\u6b21\uff09\u3002", (String)"RemoteDeployService_3", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]));
        }
    }

    private static void checkForDeploy(ConnectorContext ctx, Map<String, Object> params) {
        String encryptContent = D.s((Object)params.get("check_content"));
        String key = IerpConnectorUtil.getDeployKey(D.s((Object)params.get("appId")));
        Map content = (Map)Json.toObject((String)Cipher.decrypt((String)encryptContent, (String)key));
        RemoteDeployService.checkTimeStamp(D.l(content.get("t")));
    }

    private static void checkTimeStamp(long timeStamp) {
        long now = System.currentTimeMillis();
        long diff = now - timeStamp;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (Math.abs(diff) > 300000L) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u670d\u52a1\u5668\u65f6\u95f4\u4e3a\uff1a%1$s\uff0c\u82cd\u7a79\u670d\u52a1\u5668\u65f6\u95f4\u4e3a\uff1a%2$s\uff0c\u4e24\u8005\u65f6\u95f4\u5dee\u4e3a\uff1a %3$s\u6beb\u79d2\uff0c\u8d85\u8fc7\u4e86\u6700\u5927\u5141\u8bb8\u8bef\u5dee\uff0c\u8bf7\u5c06\u4e24\u8005\u65f6\u95f4\u8c03\u4e3a\u4e00\u81f4\u3002", (String)"RemoteDeployService_4", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]), sdf.format(now), sdf.format(timeStamp), diff));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIscServerInfo(Map<String, Object> params) {
        String key = IerpConnectorUtil.getDeployKey(D.s((Object)params.get("appId")));
        String url = D.s((Object)params.get("ierp_server_url"));
        String accessKey = Cipher.decrypt((String)D.s((Object)params.get("access_key")), (String)key);
        PermissionMode mode = PermissionMode.valueOf((String)D.s((Object)params.get("permission_mode")));
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            if (ConnectorUtil.supportMultiHub((String)IerpUtil.getAccountKey())) {
                String iscHub = D.s((Object)params.get("isc_hub"));
                ConnectorUtil.saveIscHubServerInfo((Connection)cn, (String)url, (String)accessKey, (PermissionMode)mode, (String)iscHub);
            } else {
                IscHubConfigUtil.saveIscHubServerInfo((Connection)cn, (String)url, (String)accessKey, (PermissionMode)mode);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }
}

