/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp.svc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.isc.iscb.connector.ierp.IerpConnectorUtil;
import kd.isc.iscb.platform.core.connector.self.RetrieveData;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.connector.server.CommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.Returns;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class RetrieveDataService
implements CommandExecutor {
    public static final int BATCH_SIZE = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(ConnectorContext ctx, Map<String, Object> params, Returns returns) {
        String entity = D.s((Object)params.get("entity"));
        if (!D.x((Object)ContextUtil.getTenantProperty((String)"isc_ignore_ierp_entity_query_perm"))) {
            IerpConnectorUtil.checkPermission(ctx, entity, ConnectorContext.Operation.READ);
        }
        Map requires = (Map)params.get("requires");
        List filter = (List)params.get("filter");
        List orderBy = (List)params.get("order_by");
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        try (ObjectReader reader = RetrieveData.get((String)entity, (Map)requires, (List)filter, (List)orderBy);){
            Map row = (Map)reader.read();
            while (row != null) {
                data.add(row);
                if (data.size() >= 200) {
                    this.batchOutput(returns, data, (ObjectReader<Map<String, Object>>)reader);
                    data = new ArrayList();
                }
                row = (Map)reader.read();
            }
            this.output(returns, data, reader.getTotalCount(), false);
        }
    }

    private void batchOutput(Returns returns, List<Map<String, Object>> data, ObjectReader<Map<String, Object>> reader) {
        if ("true".equals(System.getProperty("ISC_READ_NEW_TX"))) {
            try (TXHandle tx = TX.requiresNew();){
                this.output(returns, data, reader.getTotalCount(), true);
            }
        } else {
            this.output(returns, data, reader.getTotalCount(), true);
        }
    }

    private void output(Returns returns, List<Map<String, Object>> data, int count, boolean hasMore) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("count", count);
        meta.put("data", data);
        returns.setResult(meta, hasMore);
    }

    public String getCommand() {
        return "retrieve_data";
    }

    public boolean isSync() {
        return false;
    }
}

