/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.connector.ierp.svc.attach;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.io.ObjectReader;

public class RemoteAttachmentUtil {
    private static Log logger = LogFactory.getLog(AttachmentUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createAttachment(Connection cn, String id, Map<String, Object> attachment) {
        List<Integer> types;
        List<String> values = Collections.singletonList(id);
        long count = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)"select count(*) from T_ISCB_TMP_RETURNS where fid = ? ", values, types = Collections.singletonList(12)));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)String.format(ResManager.loadKDString((String)"\u672a\u627eID\u4e3a%s\u7684\u9644\u4ef6\u5206\u7247\u6570\u636e", (String)"RemoteAttachmentUtil_0", (String)"isc-iscb-connector-ierp", (Object[])new Object[0]), id));
        ObjectReader reader = null;
        long attachId = IDService.get().genLongId();
        try {
            reader = DbUtil.executeQuery((Connection)cn, (String)"select fid,fseq,fdata as data from T_ISCB_TMP_RETURNS where fid=? order by fseq", values, types);
            try (ChunkInputStream input = new ChunkInputStream((ObjectReader<DataRow>)reader);){
                String temp = UUID.randomUUID().toString().replaceAll("-", "");
                AttachmentUtil.saveTempToFileServer((InputStream)input, (long)attachId, attachment, (String)temp, (long)D.i((Object)attachment.get("bytes")));
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(reader);
            throw throwable;
        }
        DbUtil.close((ObjectReader)reader);
        RemoteAttachmentUtil.deleteChunk(cn, id, count);
        return String.valueOf(attachId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteChunk(Connection cn, String id, long count) {
        try {
            String sql = "delete from T_ISCB_TMP_RETURNS where fid=?";
            int i = DbUtil.executeUpdate((Connection)cn, (String)sql, Collections.singletonList(id), Collections.singletonList(12));
            logger.info("\u9644\u4ef6ID\uff08" + id + "\uff09\u603b\u6587\u4ef6\u5757" + count + "\u5757, \u6210\u529f\u5220\u9664" + i + "\u5757.");
        }
        catch (Exception e) {
            logger.warn("\u9644\u4ef6ID\uff08" + id + "\uff09\u6587\u4ef6\u5757\u5220\u9664\u5931\u8d25.", (Throwable)e);
        }
        finally {
            RemoteAttachmentUtil.commit(cn);
        }
    }

    private static void commit(Connection cn) {
        try {
            if (cn != null && !cn.getAutoCommit()) {
                cn.commit();
            }
        }
        catch (SQLException e) {
            throw DatabaseError.TRANS_COMMIT_FAILURE.wrap((Throwable)e);
        }
    }

    static class ChunkInputStream
    extends InputStream {
        private ObjectReader<DataRow> reader;
        private int size = 0;
        private int p = 0;
        private DataRow row;
        private byte[] data;

        ChunkInputStream(ObjectReader<DataRow> reader) {
            this.reader = reader;
            this.row = (DataRow)reader.read();
            if (this.row != null) {
                String str = D.s((Object)this.row.getValue("data"));
                this.data = str != null ? Hex.decode((String)str) : null;
                this.p = 0;
            }
        }

        @Override
        public int read() {
            return this.innerRead();
        }

        private int innerRead() {
            if (this.data != null && this.p < this.data.length) {
                ++this.size;
                return this.data[this.p++] & 0xFF;
            }
            this.row = (DataRow)this.reader.read();
            if (this.row != null) {
                String str = D.s((Object)this.row.getValue("data"));
                this.data = str != null ? Hex.decode((String)str) : null;
                this.p = 0;
                return this.innerRead();
            }
            return -1;
        }

        @Override
        public void close() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Exception e) {
                    logger.warn("fail to close chunk reader.", (Throwable)e);
                }
            }
        }

        public int getSize() {
            return this.size;
        }
    }
}

