// 上下文环境相关的函数，变量在此登记提示信息
var H = {
	tool : [], // 脚本执行工具
	connector_type_login : [], // 连接器类型登录脚本
	connector_type_session_refresh : [], // 连接器类型会话刷新脚本
	connector_type_state_check : [], // 连接器类型状态检查脚本
	connector_type_invoke : [], // 连接器类型API调用脚本
	connector_type_reg : [], // 连接类型订阅脚本
	connector_type_unreg : [], // 连接类型取消订阅脚本
	connector_type_handle_evt : [], // 连接类型事件处理脚本
	meta_service_param : [], // 集成对象参数处理脚本
	meta_service_result : [], // 集成对象结果处理脚本
	user_defined_function : [], // 自定义函数
	data_copy_query_script : [],// 数据集成来源数据查询脚本
	data_copy_source_script : [],// 数据集成来源数据处理脚本（单行）
	iscx_script_read : [],// 数据流脚本读取（单行）
	data_copy_mapping_script : [], // 数据集成字段转换脚本
	data_copy_mapping_script_x : [], // 数据集成字段转换脚本（批量）
	data_copy_target_script : [],// 数据集成目标数据处理脚本
	value_convert_script : [],// 值转换规则脚本 MappingSchemaFormPlugin
	api_script : [],// 自定义API脚本 ScriptApiFormPlugin
	mq_format_script : [],// MQ消息发布格式化脚本 AbstractMqFormPlugin
	mq_parse_script : [], // MQ消息消费解析脚本
	sf_normal_condition : [],// 服务流程普通转移条件 NormalLinkEditorFormPlugin
	sf_error_condition : [],// 服务流程异常转移条件 ErrorLinkEditorFormPlugin
	sf_script_node : [],// 服务流程脚本节点 ScriptNodeEditorFormPlugin.java
	"" : ""
};

var f = {
	"title" : "$process; // 当前服务流程实例动态对象",
	text : "$process;"
};
H.sf_script_node += f;
H.sf_normal_condition += f;
H.sf_error_condition += f;

var f = {
	"title" : "$error; // 错误对象",
	text : "$error;"
};
H.sf_error_condition += f;

var f = {
	title : "encode(s) // 调用苍穹加密函数",
	text : "encode(s)"
};
H.tool += f;
H.data_copy_mapping_script += f;
H.value_convert_script += f;
H.data_copy_mapping_script_x +=f;

var f = {
	title : "decode(s) // 调用苍穹解密函数",
	text : "decode(s)"
};
H.tool += f;
H.data_copy_mapping_script += f;
H.value_convert_script += f;
H.data_copy_mapping_script_x += f;

var f = {
	title : "LicenseInfo; // 许可信息",
	text : "LicenseInfo;"
};
H.tool += f;

var f = {
	title : "ScheduledTasks; // 等待中的定时任务",
	text : "ScheduledTasks;"
};
H.tool += f;

var f = {
	title : "RunningTasks; // 执行中的定时任务",
	text : "RunningTasks;"
};
H.tool += f;

var f = {
	title : "$this // 当前账套连接",
	text : "$this"
};
H.tool += f;
H.data_copy_mapping_script += f;
H.value_convert_script += f;
H.data_copy_mapping_script_x += f;

var f = {
	title : "param // 输入参数",
	text : "param"
};
H.value_convert_script += f;

/*var f = {
	title : "tar // 目标数据",
	text : "tar"
};
H.data_copy_mapping_script += f;
H.data_copy_target_script += f;*/

var f = {
	title : "_tars // 批量目标数据，启动方案必须启用目标数据分批",
	text : "_tars"
};
H.data_copy_target_script += f;

var f = {
	title : "src // 来源数据",
	text : "src"
};
H.data_copy_mapping_script += f;
H.data_copy_source_script += f;
H.iscx_script_read += f;

var f = {
	title : "$src // 来源系统连接",
	text : "$src"
};
H.data_copy_mapping_script += f;
H.data_copy_query_script += f;
H.data_copy_source_script += f;
H.data_copy_mapping_script_x += f;
H.iscx_script_read += f;

var f = {
	title : "$tar // 目标系统连接",
	text : "$tar"
};
H.data_copy_mapping_script += f;
H.data_copy_target_script += f;
H.data_copy_source_script += f;
H.data_copy_mapping_script_x += f;

var f = {
	title : "params // 方案参数",
	text : "params"
};
H.data_copy_mapping_script += f;
H.data_copy_query_script += f;
H.data_copy_target_script += f;
H.data_copy_source_script += f;
H.iscx_script_read += f;

var f = {
	title : "$schema // 集成方案",
	text : "$schema"
};
H.data_copy_mapping_script += f;

var f = {
	title : "$tar_service(service, params) // 调用目标系统服务（API）",
	text : "$tar_service(service, params)"
};
H.data_copy_mapping_script += f;
H.data_copy_source_script += f;
H.data_copy_mapping_script_x += f;

var f = {
	title : "$src_service(service, params) // 调用来源系统服务（API）",
	text : "$src_service(service, params)"
};
H.data_copy_mapping_script += f;
H.data_copy_mapping_script_x += f;

var f = {
	title : "$service(service, params) // 调用来源系统服务（API）",
	text : "$service(service, params)"
};
H.data_copy_query_script += f;
H.data_copy_source_script += f;
H.iscx_script_read += f;

var f = {
	title : "$service(service, params) // 调用目标系统服务（API）",
	text : "$service(service, params)"
};
H.data_copy_target_script += f;

var f = {
	title : "$action(entity, actions, data, judgeFields) // 调用目标系统实体操作",
	text : "$action(entity, actions, data, judgeFields)"
};
H.data_copy_target_script += f;

var f = {
	title : "$batch_action(entity, dataList, pkField, judgeFields, action) // 调用目标系统批量实体操作",
	text : "$batch_action(entity, dataList, pkField, judgeFields, action)"
};
H.data_copy_target_script += f;

var f = {
	title : "execute_update(cn, sql, values, types); // 执行增删改SQL，values的格式是[v1,v2, ...]，types的格式是[t1, t2, ...]",
	text : "execute_update(cn, sql, values, types);"
};
H.tool += f;
H.data_copy_target_script += f;
H.api_script += f;

var f = {
	title : "execute_call(cn, sql, valueList); // 执行数据库存储过程，valueList的格式为[{v1},{v2}]，v1中需包含mode、type、value内容",
	text : "execute_call(cn, sql, valueList);"
};
H.tool += f;
H.data_copy_target_script += f;
H.api_script += f;

var f = {
	title : "execute_batch(cn, sql, batch, types); // 批量执行增删改SQL，batch的格式是[[v1,v2, ...], ...]，types的格式是[t1, t2, ...]",
	text : "execute_batch(cn, sql, batch, types);"
};
H.tool += f;
H.data_copy_target_script += f;

var f = {
	title : "bizQuery(cn, entity, requires, filter, orderBy); // 执行实体查询",
	text : "bizQuery(cn, entity, requires, filter, orderBy);"
};
H.tool += f;
H.data_copy_mapping_script += f;
H.data_copy_query_script += f;
H.data_copy_mapping_script_x += f;

var f = {
	title : "IERP_BOTP(src_entity, tar_entity, bill_ids, options); // 执行苍穹BOTP规则",
	text : "IERP_BOTP(src_entity, tar_entity, bill_ids, options);"
};
H.tool += f;
H.data_copy_target_script += f;

var f = {
	title : "invokeMicroService2(cloud, app, service, method, paramList, proxyUser); // 调用苍穹微服务",
	text : "invokeMicroService2(cloud, app, service, method, paramList, proxyUser);"
};
H.tool += f;
H.data_copy_mapping_script += f;
H.data_copy_target_script += f;
H.data_copy_mapping_script_x += f;

var f = {
	title : "flatObjectToMapOrList(o); // 苍穹特有对象转纯数据对象",
	text : "flatObjectToMapOrList(o);"
};
H.tool += f;
H.data_copy_mapping_script += f;
H.data_copy_query_script += f;
H.data_copy_target_script += f;
H.data_copy_source_script += f;
H.data_copy_mapping_script_x += f;
H.iscx_script_read += f;

var f = {
	title : "invoke_api(api, params, caller); // 指定调用者身份来调用API",
	text : "invoke_api(api, params, caller);"
};
H.data_copy_mapping_script += f;
H.data_copy_query_script += f;
H.data_copy_target_script += f;
H.data_copy_source_script += f;
H.api_script += f;
H.data_copy_mapping_script_x += f;
H.iscx_script_read += f;

var f = {
	title : "$website; // 网站地址，等价于 $protocal+'://'+$ip+':'+$port",
	text : "$website"
};

H.connector_type_login += f;
H.connector_type_session_refresh += f;
H.connector_type_state_check += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$protocal; // Http协议，对应“连接配置”的“http协议”字段",
	text : "$protocal"
};
H.connector_type_login += f;
H.connector_type_session_refresh += f;
H.connector_type_state_check += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$ip; // 服务器IP，对应“连接配置”的“server_ip”字段",
	text : "$ip"
};
H.connector_type_login += f;
H.connector_type_session_refresh += f;
H.connector_type_state_check += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;


var f = {
	title : "$port; // 服务器端口，对应“连接配置”的“server_port”字段",
	text : "$port"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$user; // 登录用户，对应“连接配置”的“user”字段",
	text : "$user"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$password; // 登录口令，对应“连接配置”的“newpwd”字段",
	text : "$password"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$lang; // 登录语言（有些系统不需要），对应“连接配置”的“icid”字段",
	text : "$lang"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$data_center; // 账套（非多账套系统不需要），对应“连接配置”的“data_center”字段",
	text : "$data_center"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "this; // 当前系统连接的配置信息",
	text : "this"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$web_app; // Web应用名，对应“连接配置”的“web_app”字段",
	text : "$web_app"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$tenant_id; // 租户ID，对应“连接配置”的“tenant”字段",
	text : "$tenant_id"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$account_id; // 账套ID，对应“连接配置”的“account”字段",
	text : "$account_id"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$app_id; // 开放应用编码，对应“连接配置”的“appid”字段",
	text : "$app_id"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$app_securet; // 开放应用密码，对应“连接配置”的“appsecret”字段",
	text : "$app_securet"
};
H.connector_type_login += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$data; //事件源参数",
	text : "$data"
};
H.connector_type_reg += f;
H.connector_type_unreg += f;
H.connector_type_handle_evt += f;

var f = {
	title : "$session; // 会话信息，是“会话登录脚本/会话刷新脚本”返回结果",
	text : "$session"
};
H.connector_type_session_refresh += f;
H.connector_type_state_check += f;
H.connector_type_invoke += f;

var f = {
		title : "Relogin(); // 调用登录脚本返回登录会话并刷新会话缓存",
		text : "Relogin()"
	};
H.connector_type_invoke += f;
H.connector_type_state_check += f;
H.connector_type_session_refresh += f;

var f = {
	title : "$service; // API标识，通常来自 “加载服务/查询服务” 集成对象的“全名”或“自定义API”中注册的URL或业务发起调用的API标识。",
	text : "$service"
};
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;

var f = {
	title : "$params; // API参数， 通常来自“加载服务/查询服务” 集成对象的“参数转换脚本”结果或业务发起调用的API参数。",
	text : "$params"
};
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;

var f = {
	title : "$proxy_user; // 代理用户，通常来自“数据集成方案”上配置的代理用户或业务发起调用的代理用户。",
	text : "$proxy_user"
};
H.connector_type_session_refresh += f;
H.connector_type_invoke += f;


var f = {
	title : "$data; // 消息数据",
	text : "$data"
};
H.mq_format_script += f;


var f = {
	title : "$data; // 原始参数值",
	text : "$data"
};
H.meta_service_result += f;

var f = {
	title : "$service;",
	text : "$service"
};
H.meta_service_result += f;

var f = {
	title : "$params; //转换后的参数值",
	text : "$params"
};
H.meta_service_result += f;

var f = {
	title : "$result; //原始结果",
	text : "$result"
};
H.meta_service_result += f;

var f = {
	title : "$invokeMicroService2; //调用微服务",
	text : "$invokeMicroService2"
};
H.meta_service_result += f;

// 这个放在最后面
var f = {
	title : "ORM // 苍穹ORM访问",
	text : "ORM",
	"group" : "ORM.",
	children : [ {
		title : "get(entity, id, selector) // 获取一个动态对象，返回值是：DynamicObject",
		text : "get(entity, id, selector)"
	}, {
		title : "execute(obj, operation) // 执行动态对象操作，支持批量操作",
		text : "execute(obj, operation)"
	}, {
		title : "save(obj) // 保存动态对象（不触发操作插件）",
		text : "save(obj)"
	}, {
		title : "read(entity, id, requires) // 读取动态对象的数据，返回值是：Map",
		text : "read(entity, id, requires)"
	} ]
};
H.tool += f;
// 解析时，提供环境参数 env 获取帮助信息
return H[env];
