/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscr.formplugin.app;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.AESUtils;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;

public class AppApplyFormPlugin
extends AbstractFormPlugin {
    private static final String APP_PREFIX = "KDRS";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter parameter = (BillShowParameter)e.getFormShowParameter();
        Map<String, Object> data = this.queryData();
        if (!data.isEmpty()) {
            parameter.setPkId((Object)D.l((Object)data.get("id")));
            this.setFormStatus(parameter, data);
        }
    }

    private void setFormStatus(BillShowParameter parameter, Map<String, Object> data) {
        if ("B".equals(data.get("status"))) {
            parameter.setStatus(OperationStatus.VIEW);
        } else {
            parameter.setStatus(OperationStatus.EDIT);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long id = D.l((Object)this.getModel().getValue("id"));
        if (id == 0L) {
            this.initData();
        } else {
            String tenantId = D.s((Object)this.getModel().getValue("tenantid"));
            String accountId = D.s((Object)this.getModel().getValue("accountid"));
            this.getModel().setValue("tenantname", (Object)AccountUtils.getTenantByid((String)tenantId).getName());
            this.getModel().setValue("accountname", (Object)AccountUtils.getAccountById((String)accountId).getAccountName());
            this.checkEnvironment(id, tenantId, accountId);
        }
    }

    private void checkEnvironment(long id, String tenantId, String accountId) {
        String curTenantId = RequestContext.get().getTenantId();
        String curAccountId = RequestContext.get().getAccountId();
        if (!curTenantId.equals(tenantId) || !curAccountId.equals(accountId)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"iscr_app_apply"), (Object[])new Object[]{id});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u7533\u8bf7\u8bb0\u5f55\u4e0e\u5f53\u524d\u73af\u5883\u8d26\u5957ID\u6216\u79df\u6237ID\u4e0d\u5339\u914d\uff0c\u8bf7\u5173\u95ed\u5f53\u524d\u9875\u9762\uff0c\u91cd\u65b0\u63d0\u4ea4\u4e91\u8d44\u6e90\u5e94\u7528\u7533\u8bf7\u3002", (String)"AppApplyFormPlugin_0", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> queryData() {
        try (Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);){
            String sql = "SELECT TOP 1 fid as id,fstatus as status,ftenantid as tenantid,faccountid as accountid FROM T_ISCR_APP_APPLY";
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            if (dataRows.isEmpty()) {
                Map<String, Object> map = Collections.emptyMap();
                return map;
            }
            Map map = ((DataRow)dataRows.get(0)).toMap();
            return map;
        }
        catch (Exception ex) {
            throw D.e((Throwable)ex);
        }
    }

    private void initData() {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String serverUrl = D.s((Object)System.getProperty("public.resource.server"));
        if (serverUrl != null) {
            this.getModel().setValue("server_url", (Object)serverUrl);
        } else {
            this.getModel().setValue("server_url", (Object)"https://resource.kdcloud.com/");
        }
        String serverAccountId = D.s((Object)System.getProperty("public.resource.accountid"));
        if (serverAccountId != null) {
            this.getModel().setValue("server_accountid", (Object)serverAccountId);
        } else {
            this.getModel().setValue("server_accountid", (Object)"143244152805884929");
        }
        String randString = Hash.mur2digital32((Object[])new Object[]{tenantId + ',' + accountId});
        this.getModel().setValue("number", (Object)("KDRS_" + randString));
        this.getModel().setValue("name", (Object)String.format(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90_%s", (String)"AppApplyFormPlugin_10", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]), randString));
        this.getModel().setValue("tenantid", (Object)tenantId);
        this.getModel().setValue("accountid", (Object)accountId);
        this.getModel().setValue("tenantname", (Object)AccountUtils.getTenantByid((String)tenantId).getName());
        this.getModel().setValue("accountname", (Object)AccountUtils.getAccountById((String)accountId).getAccountName());
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user", (String)"phone,email");
        String phone = D.s((Object)user.get("phone"));
        String email = D.s((Object)user.get("email"));
        if (phone != null) {
            this.getModel().setValue("phone", (Object)phone);
        }
        if (email != null) {
            this.getModel().setValue("email", (Object)email);
        }
        this.refreshDigest();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            Pattern pattern = Pattern.compile("^[1]\\d{10}$");
            boolean valid = pattern.matcher(D.s((Object)this.getModel().getValue("phone"))).matches();
            if (!valid) {
                throw new KDBizException(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u4e0d\u5408\u6cd5\u3002", (String)"AppApplyFormPlugin_2", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
            }
        } else if (source instanceof Donothing && "re_apply".equals(operateKey = ((Donothing)source).getOperateKey())) {
            this.getModel().setValue("status", (Object)"A");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if ("modify".equals(operateKey)) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("submit".equals(operateKey)) {
            this.getModel().setValue("status", (Object)"B");
            SaveServiceHelper.update((DynamicObject)this.getModel().getDataEntity());
            this.getModel().setDataChanged(false);
            this.getView().setStatus(OperationStatus.VIEW);
        } else if ("re_apply".equals(operateKey)) {
            SaveServiceHelper.update((DynamicObject)this.getModel().getDataEntity());
            this.getModel().setDataChanged(false);
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("show_log".equals(operateKey)) {
            this.showLog();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit key = (TextEdit)this.getView().getControl("publickey");
        key.addClickListener((ClickListener)this);
        TextEdit key2 = (TextEdit)this.getView().getControl("server_accountid");
        key2.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)evt.getSource();
            if ("publickey".equalsIgnoreCase(textEdit.getKey())) {
                this.refreshDigest();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u5bc6\u94a5\u6210\u529f\u3002", (String)"AppApplyFormPlugin_3", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
            } else if ("server_accountid".equals(textEdit.getKey())) {
                String server = D.s((Object)this.getModel().getValue("server_url"));
                if (server != null) {
                    this.openAccountList(server);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4e91\u7aef\u670d\u52a1\u5668\u5730\u5740\u3002", (String)"AppApplyFormPlugin_4", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void openAccountList(String serverUrl) {
        try {
            List<Map<String, Object>> dataCenters = this.queryDataCenters(serverUrl);
            ArrayList<String> dcList = new ArrayList<String>(dataCenters.size());
            for (Map<String, Object> dc : dataCenters) {
                dcList.add(dc.get("accountName") + "(" + dc.get("accountId") + ")");
            }
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            params.put("dc_list", dcList);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_datacenter_list", (String)ResManager.loadKDString((String)"\u8d26\u5957\u5217\u8868", (String)"AppApplyFormPlugin_5", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]), params, (String)"select_account");
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u8d26\u5957\u4fe1\u606f\u3002", (String)"AppApplyFormPlugin_6", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Map<String, Object>> queryDataCenters(String serverUrl) throws IOException {
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        String fullUrl = serverUrl + "/auth/getAllDatacenters.do";
        Reader reader = NetUtil.httpGet((String)fullUrl, (String)"utf-8");
        List dataCenters = (List)Json.toObject((Reader)reader);
        return dataCenters;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String info;
        super.closedCallBack(evt);
        if ("select_account".equals(evt.getActionId()) && (info = D.s((Object)evt.getReturnData())) != null) {
            String accountId = info.substring(info.indexOf(40) + 1, info.lastIndexOf(41));
            this.getModel().setValue("server_accountid", (Object)accountId);
        }
    }

    private void refreshDigest() {
        try {
            String base64EncodeKey = AESUtils.getBase64EncodeKey();
            this.getModel().setValue("publickey", (Object)base64EncodeKey);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u79f0\u52a0\u5bc6\u79d8\u94a5\u751f\u6210\u5931\u8d25!", (String)"AppApplyFormPlugin_7", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void showLog() {
        long id = D.l((Object)this.getModel().getValue("id"));
        if (id != 0L) {
            FormOpener.openBillList((AbstractFormPlugin)this, (String)"isc_operation_log", Collections.singletonList(new QFilter("schemaid", "=", (Object)id)), (String)ResManager.loadKDString((String)"\u64cd\u4f5c\u65e5\u5fd7", (String)"AppApplyFormPlugin_8", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"AppApplyFormPlugin_9", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
        }
    }
}

