/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscr.formplugin.app;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.AESUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class AppApplySubmitOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(AppApplySubmitOpPlugin.class);
    private static final String KEY;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(Arrays.asList("server_url", "server_accountid", "number", "name", "phone", "email", "creator", "publickey", "tenantid", "accountid"));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.validate(e);
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] objects = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if ("submit".equals(operationKey)) {
            this.submit(objects[0]);
        }
    }

    @Deprecated
    private void submit(DynamicObject obj) {
        String url = this.getServerUrl(obj);
        Map<String, Object> params = this.prepareParams(obj);
        params.put("action", "submit");
        params.put("timestamp", System.currentTimeMillis());
        String content = AESUtils.encrypt((String)JSON.toJSONString(params), (String)KEY);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("content", content);
        Map res = Collections.emptyMap();
        try {
            Reader reader = NetUtil.httpPost((String)url, (String)JSON.toJSONString(data));
            String text = NetUtil.readText((Reader)reader);
            res = (Map)Script.parseJson((String)text);
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bbf\u95ee\u4e91\u7aef\u5730\u5740%1$s\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002\u539f\u56e0\uff1a%2$s", (String)"AppApplySubmitOpPlugin_6", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]), url, StringUtil.getCascadeMessage((Throwable)e)));
        }
        if (res == null || !D.x(res.get("success"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bbf\u95ee\u4e91\u7aef\u5730\u5740%1$s\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002\u539f\u59cb\u7ed3\u679c\uff1a%2$s", (String)"AppApplySubmitOpPlugin_7", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]), url, res));
        }
        obj.set("fileserver", ((Map)res.get("data")).get("fileserver"));
    }

    private Map<String, Object> prepareParams(DynamicObject obj) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_number", obj.get("number"));
        params.put("app_name", obj.get("name"));
        params.put("phone", obj.get("phone"));
        params.put("email", obj.get("email"));
        params.put("applier", D.s((Object)obj.getDynamicObject("modifier").get("name")));
        params.put("public_key", obj.get("publickey"));
        params.put("tenant_id", obj.get("tenantid"));
        params.put("tenant_name", obj.get("tenantname"));
        params.put("account_id", obj.get("accountid"));
        params.put("account_name", obj.get("accountname"));
        return params;
    }

    private String getServerUrl(DynamicObject obj) {
        String domainUrl = D.s((Object)obj.get("server_url"));
        if (domainUrl == null) {
            domainUrl = System.getProperty("public.resource.server");
        }
        if (domainUrl == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u4e91\u7aef\u5730\u5740\u3002", (String)"AppApplySubmitOpPlugin_3", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
        }
        domainUrl = domainUrl.endsWith("/") ? domainUrl : domainUrl + "/";
        domainUrl = domainUrl + "kapi/app/kdec_public_resource/apply_app_secret_v1";
        String serverAccountId = D.s((Object)obj.get("server_accountid"));
        if (serverAccountId != null) {
            domainUrl = domainUrl + "?accountId=" + serverAccountId;
        }
        return domainUrl;
    }

    private void validate(BeforeOperationArgs e) {
        List dataEntities = e.getValidExtDataEntities();
        if (dataEntities == null || dataEntities.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AppApplySubmitOpPlugin_4", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
        }
        if (dataEntities.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u591a\u884c\u3002", (String)"AppApplySubmitOpPlugin_5", (String)"isc-iscr-platform-formplugin", (Object[])new Object[0]));
        }
    }

    static {
        Properties properties = new Properties();
        try (InputStream in = Object.class.getResourceAsStream("/cloud_res.properties");){
            properties.load(in);
            KEY = properties.getProperty("key");
        }
        catch (IOException e) {
            throw D.e((Throwable)e);
        }
    }
}

