/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.resource.save;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscx.platform.core.res.meta.build.util.ResEditorUtil;
import kd.isc.iscx.platform.resource.bean.IscxBean;
import kd.isc.iscx.platform.resource.save.SaveHandler;

public abstract class AbstractHandler
implements SaveHandler {
    @Override
    public Map<String, Object> save(IscxBean iscxBean) {
        this.check(iscxBean);
        if (iscxBean.isReferenced()) {
            return iscxBean.toResultMap();
        }
        this.saveReferences(iscxBean);
        this.saveMain(iscxBean);
        return iscxBean.toResultMap();
    }

    abstract void check(IscxBean var1);

    abstract void saveReferences(IscxBean var1);

    abstract Map<String, Object> findDetails(DynamicObject var1, IscxBean var2);

    protected void saveMain(IscxBean bean) {
        DynamicObject dynamicObject = this.queryDbObj(bean);
        if (dynamicObject != null) {
            bean.setId(dynamicObject.getLong("id"));
            this.update(dynamicObject, bean);
        } else {
            bean.setId(IDService.get().genLongId());
            this.create(bean);
        }
    }

    private DynamicObject queryDbObj(IscxBean bean) {
        return BusinessDataServiceHelper.loadSingle((String)"iscx_resource", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bean.getNumber()).and("catalog.id", "=", (Object)bean.getCatalog())});
    }

    private void update(DynamicObject dynamicObject, IscxBean bean) {
        Map<String, Object> details = this.findDetails(dynamicObject, bean);
        ResEditorUtil.updateResource((DynamicObject)dynamicObject, (String)bean.getNumber(), (Map)ResEditorUtil.toMap((String)bean.getName()), (String)bean.getRemark(), (DynamicObject)this.queryCatalog(bean.getCatalog()), details);
    }

    private DynamicObject queryCatalog(long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_catalog");
    }

    private Map<String, Object> getCustomParams(IscxBean bean) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("customResId", bean.getId());
        customParams.put("source_app", bean.getSourceApp());
        return customParams;
    }

    private void create(IscxBean bean) {
        Map<String, Object> customParams = this.getCustomParams(bean);
        Map<String, Object> details = this.findDetails(null, bean);
        ResEditorUtil.createResourceWithParam((String)bean.getResType(), (String)bean.getNumber(), (Map)ResEditorUtil.toMap((String)bean.getName()), (String)bean.getRemark(), (DynamicObject)this.queryCatalog(bean.getCatalog()), details, customParams);
    }
}

