/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.resource.save;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscx.platform.core.res.CatalogType;
import kd.isc.iscx.platform.core.res.CatalogUtil;
import kd.isc.iscx.platform.resource.bean.IscxBean;
import kd.isc.iscx.platform.resource.bean.XCatalogBean;
import kd.isc.iscx.platform.resource.save.AbstractHandler;

public class XCatalogSaveHandler
extends AbstractHandler {
    @Override
    public Map<String, Object> save(IscxBean iscxBean) {
        XCatalogBean bean = (XCatalogBean)iscxBean;
        if (D.l((Object)bean.getId()) != 0L) {
            DynamicObject catalog = BusinessDataServiceHelper.loadSingle((String)"iscx_catalog", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bean.getId())});
            if (catalog == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"id\u4e3a%s\u7684iscx_catalog\u8d44\u6e90\u4e0d\u5b58\u5728", (String)"XCatalogSaveHandler_0", (String)"isc-iscx-platform-resource", (Object[])new Object[0]), bean.getId()));
            }
            this.setCatalog(bean, catalog);
            ConnectorUtil.save((DynamicObject)catalog);
            return bean.toResultMap();
        }
        DynamicObject catalog = BusinessDataServiceHelper.newDynamicObject((String)"iscx_catalog");
        this.setCatalog(bean, catalog);
        String longNumber = CatalogUtil.generateLongNumber((DynamicObject)catalog);
        long id = CatalogUtil.generateCatalogId((String)longNumber);
        if (QueryServiceHelper.exists((String)"iscx_catalog", (Object)id)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u76ee\u5f55", (String)"XCatalogSaveHandler_1", (String)"isc-iscx-platform-resource", (Object[])new Object[0]));
        }
        ConnectorUtil.save((DynamicObject)catalog);
        bean.setId(id);
        return bean.toResultMap();
    }

    @Override
    void check(IscxBean iscxBean) {
    }

    @Override
    void saveReferences(IscxBean iscxBean) {
    }

    @Override
    Map<String, Object> findDetails(DynamicObject dynamicObject, IscxBean iscxBean) {
        throw new UnsupportedOperationException();
    }

    private void setCatalog(XCatalogBean bean, DynamicObject catalog) {
        catalog.set("name", (Object)bean.getName());
        String type = bean.getType().name();
        catalog.set("type", (Object)type);
        catalog.set("remark", (Object)bean.getRemark());
        catalog.set("priority", (Object)bean.getPriority());
        catalog.set("icon_url", (Object)("iscx_static/catalog/" + type + "_default.png"));
        catalog.set("creator", (Object)RequestContext.get().getCurrUserId());
        catalog.set("source_app", (Object)bean.getSourceApp());
        if (CatalogType.valueOf((String)type).parentType() != null) {
            DynamicObject parent = BusinessDataServiceHelper.loadSingle((String)"iscx_catalog", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bean.getParent())});
            if (parent == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8d44\u6e90id\u4e3a%s\u7684\u7236\u7ea7iscx_catalog\u8d44\u6e90\u4e0d\u5b58\u5728", (String)"XCatalogSaveHandler_2", (String)"isc-iscx-platform-resource", (Object[])new Object[0]), bean.getParent()));
            }
            catalog.set("parent", (Object)parent);
        }
    }
}

