/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.resource.save;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.build.XFlowNodeParam;
import kd.isc.iscx.platform.core.res.meta.build.util.DataFlowUtil;
import kd.isc.iscx.platform.resource.bean.IscxBean;
import kd.isc.iscx.platform.resource.bean.XAutoResBean;
import kd.isc.iscx.platform.resource.bean.XDataFlowBean;
import kd.isc.iscx.platform.resource.bean.XManualResBean;
import kd.isc.iscx.platform.resource.save.AbstractHandler;
import kd.isc.iscx.platform.resource.save.ResourceTypeEnum;
import kd.isc.iscx.platform.resource.save.Util;

public class XDataFlowSaveHandler
extends AbstractHandler {
    @Override
    void check(IscxBean iscxBean) {
    }

    @Override
    void saveReferences(IscxBean iscxBean) {
        XDataFlowBean bean = (XDataFlowBean)iscxBean;
        for (Map.Entry<String, IscxBean> entry : bean.getNodes().entrySet()) {
            String key = entry.getKey();
            ResourceTypeEnum.valueOf(key.replace('.', '_')).save(entry.getValue());
        }
    }

    @Override
    Map<String, Object> findDetails(DynamicObject dynamicObject, IscxBean iscxBean) {
        XDataFlowBean bean = (XDataFlowBean)iscxBean;
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(3);
        details.put("connectors", bean.getConnectorItemsList());
        details.put("input", Util.toMap(ResourceUtil.getResource((String)"EMPTY_QUERY_PARAMS").getId()));
        LinkedHashMap<String, Object> define = new LinkedHashMap<String, Object>(3);
        List<XFlowNodeParam> nodeParamList = this.getFlowNodeParams(bean);
        List<Map<String, Object>> nodes = this.getNodes(bean, nodeParamList);
        define.put("nodes", nodes);
        List<Map<String, Object>> edges = this.getEdges(nodeParamList);
        define.put("edges", edges);
        define.put("count", nodes.size() + edges.size() + 10);
        details.put("define", define);
        return details;
    }

    private List<Map<String, Object>> getEdges(List<XFlowNodeParam> nodeList) {
        ArrayList<Map<String, Object>> edges = new ArrayList<Map<String, Object>>(nodeList.size() - 1);
        int edgeID = nodeList.size() + 1;
        for (int i = 0; i < nodeList.size() - 1; ++i) {
            edges.add(this.getEdge(edgeID, nodeList.get(i), nodeList.get(i + 1)));
            ++edgeID;
        }
        return edges;
    }

    private Map<String, Object> getEdge(int id, XFlowNodeParam srcNode, XFlowNodeParam dstNode) {
        LinkedHashMap<String, Object> edgesMap = new LinkedHashMap<String, Object>();
        edgesMap.put("type", "Normal");
        edgesMap.put("id", id);
        edgesMap.put("src_node_id", srcNode.getNodeId());
        edgesMap.put("dst_node_id", dstNode.getNodeId());
        edgesMap.put("from", srcNode.getForm());
        edgesMap.put("to", dstNode.getTo());
        return edgesMap;
    }

    private List<Map<String, Object>> getNodes(XDataFlowBean bean, List<XFlowNodeParam> nodeParamList) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>(nodeParamList.size());
        for (XFlowNodeParam params : nodeParamList) {
            LinkedHashMap<String, Object> node = new LinkedHashMap<String, Object>();
            node.put("id", params.getNodeId());
            node.put("pos_x", params.getPos_X());
            node.put("pos_y", params.getPos_Y());
            node.put("name", params.getDataModel().get("name"));
            node.put("type", params.getNodeType());
            if (params.getResType() != null) {
                node.put("resourceType", params.getResType());
                LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
                details.put("resource", params.getDataModel());
                details.put("name", params.getDataModel().get("name"));
                details.put("remark", null);
                details.put("connctor_binding", this.getConnectorBinding(params, bean));
                node.put("details", details);
            }
            nodes.add(node);
        }
        return nodes;
    }

    private List<XFlowNodeParam> getFlowNodeParams(XDataFlowBean bean) {
        ArrayList<XFlowNodeParam> list = new ArrayList<XFlowNodeParam>(bean.getNodes().size());
        int i = 3;
        int nodeIndex = 1;
        for (Map.Entry<String, IscxBean> entry : bean.getNodes().entrySet()) {
            XFlowNodeParam nodeParam;
            IscxBean iscxBean = entry.getValue();
            if (XManualResBean.getResourceType().equals(entry.getKey()) || XAutoResBean.getResourceType().equals(entry.getKey())) {
                nodeParam = new XFlowNodeParam(iscxBean.toMap(), iscxBean.getResType(), iscxBean.getNodeType(), 1, nodeIndex++);
                list.add(nodeParam);
                continue;
            }
            nodeParam = new XFlowNodeParam(iscxBean.toMap(), iscxBean.getResType(), iscxBean.getNodeType(), i++, nodeIndex++);
            list.add(nodeParam);
        }
        LinkedHashMap<String, String> endMap = new LinkedHashMap<String, String>();
        endMap.put("name", ResManager.loadKDString((String)"\u7ed3\u675f", (String)"XDataFlowSaveHandler_0", (String)"isc-iscx-platform-resource", (Object[])new Object[0]));
        XFlowNodeParam XDataFlowNode = new XFlowNodeParam(endMap, null, "End", 2, nodeIndex);
        list.add(XDataFlowNode);
        return list;
    }

    private String getNumberFromConnectorItems(XFlowNodeParam params, XDataFlowBean bean, String key) {
        return bean.getConnectorSetting().get(params.getResType()).get(key);
    }

    private List<Map<String, Object>> getConnectorBinding(XFlowNodeParam params, XDataFlowBean bean) {
        List list = DataFlowUtil.getResourceSystems((long)D.l(params.getDataModel().get("id")));
        for (Map map : list) {
            if ("$src".equals(map.get("system_number"))) {
                map.put("system_connector", this.getNumberFromConnectorItems(params, bean, "$src"));
                continue;
            }
            if (!"$tar".equals(map.get("system_number"))) continue;
            map.put("system_connector", this.getNumberFromConnectorItems(params, bean, "$tar"));
        }
        return list;
    }
}

