/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.resource.save;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.meta.dw.ConnectorInfo;
import kd.isc.iscx.platform.core.res.meta.dw.DataFlow;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;
import kd.isc.iscx.platform.resource.bean.IscxBean;
import kd.isc.iscx.platform.resource.bean.XAutoResBean;
import kd.isc.iscx.platform.resource.bean.XManualResBean;
import kd.isc.iscx.platform.resource.bean.XNoticeSendBean;
import kd.isc.iscx.platform.resource.bean.XTriggerBean;
import kd.isc.iscx.platform.resource.save.AbstractHandler;
import kd.isc.iscx.platform.resource.save.ResourceTypeEnum;
import kd.isc.iscx.platform.resource.save.Util;

public class XTriggerSaveHandler
extends AbstractHandler {
    @Override
    public Map<String, Object> save(IscxBean iscxBean) {
        XTriggerBean bean = (XTriggerBean)iscxBean;
        this.check(bean);
        this.saveReferences(bean);
        this.saveMain(bean);
        return bean.toResultMap();
    }

    @Override
    void check(IscxBean iscxBean) {
        Util.checkXTriggerBeanNumber(iscxBean);
        if (iscxBean.getId() == 0L) {
            throw new IscBizException(ResManager.loadKDString((String)"\u9700\u8981\u6307\u5b9a\u542f\u52a8\u65b9\u6848\u7684id", (String)"XTriggerSaveHandler_0", (String)"isc-iscx-platform-resource", (Object[])new Object[0]));
        }
    }

    @Override
    void saveReferences(IscxBean iscxBean) {
        XTriggerBean bean = (XTriggerBean)iscxBean;
        ResourceTypeEnum.DataWeaver_DataFlow.save(bean.getDataFlow());
        if (bean.getSuccessNotice() != null && !bean.getSuccessNotice().isReferenced()) {
            this.setNoticeInput(bean, bean.getSuccessNotice());
            ResourceTypeEnum.DataLoad_NoticeSend.save(bean.getSuccessNotice());
        }
        if (bean.getErrorNotice() != null && !bean.getErrorNotice().isReferenced()) {
            this.setNoticeInput(bean, bean.getErrorNotice());
            ResourceTypeEnum.DataLoad_NoticeSend.save(bean.getErrorNotice());
        }
    }

    @Override
    protected void saveMain(IscxBean iscxBean) {
        XTriggerBean bean = (XTriggerBean)iscxBean;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"iscx_data_flow_trigger", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bean.getId())});
        if (dynamicObject != null) {
            if (D.x((Object)dynamicObject.get("enable"))) {
                throw new IscBizException(ResManager.loadKDString((String)"\u4fee\u6539\u542f\u52a8\u65b9\u6848\u4e4b\u524d\u9700\u8981\u5148\u7981\u7528\u542f\u52a8\u65b9\u6848", (String)"XTriggerSaveHandler_1", (String)"isc-iscx-platform-resource", (Object[])new Object[0]));
            }
            this.update(dynamicObject, bean);
        } else {
            this.create(bean);
        }
    }

    @Override
    Map<String, Object> findDetails(DynamicObject dynamicObject, IscxBean iscxBean) {
        throw new UnsupportedOperationException();
    }

    private void setNoticeInput(XTriggerBean bean, XNoticeSendBean notice) {
        if (bean.getDataFlow().getNodes().get(XAutoResBean.getResourceType()) != null) {
            XAutoResBean xAutoResBean = (XAutoResBean)bean.getDataFlow().getNodes().get(XAutoResBean.getResourceType());
            notice.setDataModel(xAutoResBean.getDataQueryBean().getInput());
        } else if (bean.getDataFlow().getNodes().get(XManualResBean.getResourceType()) != null) {
            XManualResBean xManualResBean = (XManualResBean)bean.getDataFlow().getNodes().get(XManualResBean.getResourceType());
            notice.setDataModel(xManualResBean.getDataQueryBean().getInput());
        }
    }

    public void create(XTriggerBean bean) {
        DynamicObject trigger = BusinessDataServiceHelper.newDynamicObject((String)"iscx_data_flow_trigger");
        trigger.set("id", (Object)bean.getId());
        this.saveTrigger(bean, trigger);
    }

    private void saveTrigger(XTriggerBean bean, DynamicObject trigger) {
        trigger.set("data_flow_id", (Object)bean.getDataFlow().getId());
        trigger.set("event_model_id", (Object)this.getEventModelID(bean));
        trigger.set("name", (Object)bean.getName());
        trigger.set("number", (Object)bean.getNumber());
        trigger.set("max_threads", (Object)bean.getMaxThreads());
        trigger.set("work_area_size", (Object)bean.getWorkAreaSize());
        trigger.set("log_level", (Object)bean.getLogLevel());
        trigger.set("checkpoint", (Object)bean.getCheckpoint());
        trigger.set("retry_interval", (Object)bean.getRetryInterval());
        trigger.set("max_retry_times", (Object)bean.getMaxRetryTimes());
        trigger.set("enable", (Object)"0");
        trigger.set("remark", (Object)StringUtil.trim((String)bean.getRemark(), (int)250));
        trigger.set("creator", (Object)RequestContext.get().getCurrUserId());
        trigger.set("event_type", (Object)bean.getEventType());
        trigger.set("start_mq_topic_id", (Object)bean.getStartMqTopic());
        trigger.set("end_mq_topic_id", (Object)bean.getEndMqTopic());
        if (bean.getErrorNotice() != null) {
            trigger.set("failed_notice_id", (Object)bean.getErrorNotice().getId());
        } else {
            trigger.set("failed_notice_id", (Object)0);
        }
        if (bean.getSuccessNotice() != null) {
            trigger.set("success_notice_id", (Object)bean.getSuccessNotice().getId());
        } else {
            trigger.set("success_notice_id", (Object)0);
        }
        DynamicObjectCollection entries = trigger.getDynamicObjectCollection("connectors");
        entries.clear();
        DataFlow resource = (DataFlow)ResourceUtil.getResource((long)bean.getDataFlow().getId());
        List connectors = resource.getConnectors();
        for (ConnectorInfo item : connectors) {
            DynamicObject row = entries.addNew();
            row.set("connector_type", (Object)item.getType());
            row.set("connector_number", (Object)item.getNumber());
            row.set("connector_name", (Object)item.getName());
            row.set("connector_ref_id", (Object)this.getNumberFromConnectorItems(bean, item.getNumber()));
        }
        DynamicObjectCollection params = trigger.getDynamicObjectCollection("params");
        params.clear();
        AbstractEventModel meta = (AbstractEventModel)ResourceUtil.getResource((long)bean.getDataFlow().getNodes().get(bean.getEventType()).getId());
        StructSchema schema = meta.getParams().getDataType();
        for (int i = 0; i < schema.fieldCount(); ++i) {
            DynamicObject row = params.addNew();
            Field field = schema.getField(i);
            row.set("param_number", (Object)field.getName());
            row.set("param_name", (Object)(field.getLabel() == null ? field.getName() : field.getLabel()));
            row.set("param_type", (Object)field.getType().toString());
            row.set("param_value", bean.getParamsRef().get(field.getName()));
            row.set("param_desc", (Object)field.getLabel());
        }
        ConnectorUtil.save((DynamicObject)trigger);
    }

    private long getNumberFromConnectorItems(XTriggerBean bean, String key) {
        Map<String, Object> map = bean.getConnectorRef();
        long id = D.l((Object)map.get(key));
        if (id == 0L) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848connectorRef\u672a\u8bbe\u7f6e%s", (String)"XTriggerSaveHandler_2", (String)"isc-iscx-platform-resource", (Object[])new Object[0]), key));
        }
        DynamicObject obj = QueryServiceHelper.queryOne((String)"iscx_connector", (String)"id", (QFilter[])new QFilter[]{new QFilter("connection.id", "=", (Object)id)});
        if (obj == null) {
            DynamicObject link = ConnectionConfig.getConfig((long)id);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8fde\u63a5\u914d\u7f6e\u672a\u521b\u5efa\u6570\u636e\u6d41\u4e2d\u7684\u8fde\u63a5\u5668\u3002", (String)"XTriggerSaveHandler_3", (String)"isc-iscx-platform-resource", (Object[])new Object[0]), link.getString("number")));
        }
        return obj.getLong("id");
    }

    private long getEventModelID(XTriggerBean bean) {
        AbstractEventModel eventModel = ((DataFlow)ResourceUtil.getResource((long)bean.getDataFlow().getId())).getEventModel();
        if (eventModel != null) {
            return eventModel.getId();
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u7684\u4e8b\u4ef6\u6a21\u578b\u4e3a\u7a7a", (String)"XTriggerSaveHandler_4", (String)"isc-iscx-platform-resource", (Object[])new Object[0]));
    }

    public void update(DynamicObject dynamicObject, XTriggerBean bean) {
        this.saveTrigger(bean, dynamicObject);
    }
}

