/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.resource.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ImportMetaToIscxResourceUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ModelUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ResEditorUtil;

public class ServiceUtil {
    protected static Map<String, Map<String, Object>> getTableInfoMap(List<String> tableNameList, long dbLink) {
        HashMap<String, Map<String, Object>> tableInfoMap = new HashMap<String, Map<String, Object>>(tableNameList.size());
        try (ConnectionWrapper cn = ConnectionManager.getConnection((long)dbLink);){
            for (String s : tableNameList) {
                Map tableInfo = ConnectionManager.getTableInfo((ConnectionWrapper)cn, (String)s);
                tableInfoMap.put(s, tableInfo);
            }
        }
        return tableInfoMap;
    }

    protected static Map<String, Object> getDbTableInfo(List<String> tableNameList, DynamicObject catalog) {
        DynamicObject catalogParent = catalog.getDynamicObject("parent");
        QFilter filter = new QFilter("number", "in", tableNameList).and("type", "=", (Object)"DataModel.Table").and("catalog.parent.id", "=", catalogParent.getPkValue());
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"iscx_resource", (String)"id,modifier,modifytime,details_tag,source_app", (QFilter[])new QFilter[]{filter});
        HashMap<String, Object> dbTableInfo = new HashMap<String, Object>(collection.length);
        if (collection.length == 0) {
            return dbTableInfo;
        }
        for (DynamicObject object : collection) {
            dbTableInfo.put(object.getString("number"), object);
        }
        return dbTableInfo;
    }

    protected static void buildDataModel(Map<String, Object> data, DynamicObject catalog, DynamicObject res, Map<String, Object> tableInfo, Map<String, Object> temp) {
        String tableName = D.s((Object)temp.get("table"));
        String source_app = D.s((Object)data.get("source_app"));
        boolean isUpdate = D.x((Object)data.get("isUpdate"));
        if (res != null) {
            if (isUpdate) {
                res.set("source_app", (Object)source_app);
                ServiceUtil.updateTableModelInfo(tableInfo, tableName, catalog, res);
                temp.put("id", res.get("id"));
                temp.put("msg", "updated");
            } else {
                temp.put("id", res.get("id"));
                temp.put("msg", "ignore");
            }
        } else {
            long resId = ServiceUtil.insertTableModelInfo(tableInfo, tableName, catalog, source_app);
            temp.put("id", resId);
            temp.put("msg", "success");
        }
    }

    private static void updateTableModelInfo(Map<String, Object> tableInfo, String tableName, DynamicObject catalog, DynamicObject res) {
        DynamicObject catalogParent = catalog.getDynamicObject("parent");
        String label = tableName + "(" + catalogParent.getString("name") + ")";
        Map<String, Object> details = ServiceUtil.getDetailsMap(tableName, tableInfo, label);
        res.set("details_tag", (Object)Json.toString(details));
        ConnectorUtil.save((DynamicObject)res);
    }

    private static long insertTableModelInfo(Map<String, Object> tableInfo, String tableName, DynamicObject catalog, String source_app) {
        DynamicObject catalogParent = catalog.getDynamicObject("parent");
        String label = tableName + "(" + catalogParent.getString("name") + ")";
        Map<String, Object> details = ServiceUtil.getDetailsMap(tableName, tableInfo, label);
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("source_app", source_app);
        return ResEditorUtil.createResourceWithParam((String)"DataModel.Table", (String)tableName, (Map)ResEditorUtil.toMap((String)label), (String)"", (DynamicObject)catalog, details, param);
    }

    private static Map<String, Object> getDetailsMap(String tableName, Map<String, Object> tableInfo, String label) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("field", tableName);
        details.put("label", label);
        details.put("data_type", "STRUCT");
        details.put("id", D.s((Object)IDService.get().genLongId()));
        List properties = (List)tableInfo.get("properties");
        if (properties == null || properties.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868%s\u7684\u5b57\u6bb5\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u3002", (String)"ServiceUtil_3", (String)"isc-iscx-platform-resource", (Object[])new Object[0]), tableName));
        }
        ArrayList fields = new ArrayList(properties.size());
        for (Map entry : properties) {
            HashMap temp = new HashMap();
            temp.put("field", entry.get("name"));
            temp.put("label", D.s(entry.get("remark")) != null ? D.s(entry.get("remark")) : entry.get("name"));
            temp.put("data_type", ImportMetaToIscxResourceUtil.getTableFieldType((String)D.s(entry.get("data_type"))));
            temp.put("id", D.s((Object)IDService.get().genLongId()));
            boolean is_primary_key = D.x(entry.get("is_primary_key"));
            temp.put("is_primary_key", is_primary_key);
            temp.put("is_required", !D.x(entry.get("is_nullable")));
            fields.add(temp);
        }
        details.put("fields", fields);
        ModelUtil.setDigestFormatForEntity(details);
        if (D.s(details.get("digest_format")) == null) {
            details.put("digest_format", ResManager.loadKDString((String)"\u65e0", (String)"ServiceUtil_2", (String)"isc-iscx-platform-resource", (Object[])new Object[0]));
        }
        return details;
    }

    public static List<Map<String, Object>> buildTableModel(Map<String, Object> data) {
        List tableNameList = (List)data.get("tableNames");
        if (tableNameList.size() > 50) {
            throw new IscBizException(ResManager.loadKDString((String)"\u4e00\u6b21\u8c03\u7528\u6570\u636e\u8868\u540d\u6700\u591a\u53ea\u80fd\u4f2050\u4e2a\u3002", (String)"IscResourceBuildServiceImpl_0", (String)"isc-iscx-platform-resource", (Object[])new Object[0]));
        }
        long dbLink = D.l((Object)data.get("dbLink"));
        long catalog_id = D.l((Object)data.get("catalog"));
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)catalog_id, (String)"iscx_catalog");
        Map<String, Object> dbTableInfo = ServiceUtil.getDbTableInfo(tableNameList, catalog);
        Map<String, Map<String, Object>> tableInfoMap = ServiceUtil.getTableInfoMap(tableNameList, dbLink);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(tableInfoMap.size());
        for (Map.Entry<String, Map<String, Object>> entry : tableInfoMap.entrySet()) {
            HashMap<String, Object> result = new HashMap<String, Object>(8);
            result.put("table", entry.getKey());
            DynamicObject res = (DynamicObject)dbTableInfo.get(entry.getKey());
            try {
                Map<String, Object> tableInfo = entry.getValue();
                ServiceUtil.buildDataModel(data, catalog, res, tableInfo, result);
            }
            catch (Exception e) {
                result.put("error", StringUtil.getCascadeMessage((Throwable)e));
            }
            list.add(result);
        }
        return list;
    }
}

