/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.DataComb;
import kd.isc.iscx.platform.core.res.meta.dm.DataEntity;
import kd.isc.iscx.platform.core.res.meta.dm.DataStruct;
import kd.isc.iscx.platform.core.res.meta.dm.DataTable;
import kd.isc.iscx.platform.core.res.meta.dm.DataView;
import kd.isc.iscx.platform.core.res.meta.dp.DataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.DataReader;
import kd.isc.iscx.platform.core.res.meta.dp.EntriesReader;
import kd.isc.iscx.platform.core.res.meta.dp.ReferReader;
import kd.isc.iscx.platform.core.res.meta.dp.ScriptQuery;
import kd.isc.iscx.platform.core.res.meta.dp.ScriptReader;
import kd.isc.iscx.platform.core.res.meta.ds.DataTableLoad;
import kd.isc.iscx.platform.core.res.meta.ds.EntityLoad;
import kd.isc.iscx.platform.core.res.meta.ds.NoticeSend;
import kd.isc.iscx.platform.core.res.meta.ds.ScriptBatchLoad;
import kd.isc.iscx.platform.core.res.meta.ds.ScriptLoad;
import kd.isc.iscx.platform.core.res.meta.ds.XTableLoad;
import kd.isc.iscx.platform.core.res.meta.ds.XWebAPI;
import kd.isc.iscx.platform.core.res.meta.dw.DataCombInit;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompare;
import kd.isc.iscx.platform.core.res.meta.dw.DataFilter;
import kd.isc.iscx.platform.core.res.meta.dw.DataFilterX;
import kd.isc.iscx.platform.core.res.meta.dw.DataFlow;
import kd.isc.iscx.platform.core.res.meta.event.ApiEvent;
import kd.isc.iscx.platform.core.res.meta.event.BizEvent;
import kd.isc.iscx.platform.core.res.meta.event.MQueueEvent;
import kd.isc.iscx.platform.core.res.meta.event.ManualEvent;
import kd.isc.iscx.platform.core.res.meta.event.TimerEvent;
import kd.isc.iscx.platform.core.res.meta.fn.ScriptFunction;
import kd.isc.iscx.platform.core.res.meta.map.FieldMapping;
import kd.isc.iscx.platform.core.res.meta.map.ScriptMapping;
import kd.isc.iscx.platform.core.res.meta.map.ScriptMappingX;
import kd.isc.iscx.platform.core.res.meta.vc.AutoMappingRule;
import kd.isc.iscx.platform.core.res.meta.vc.CompositeRule;
import kd.isc.iscx.platform.core.res.meta.vc.ConstLookupTable;
import kd.isc.iscx.platform.core.res.meta.vc.JavaRule;
import kd.isc.iscx.platform.core.res.meta.vc.SQLRuleX;
import kd.isc.iscx.platform.core.res.meta.vc.ScriptRule;

public abstract class ResourceType {
    private final String number;
    private volatile Object name;
    private final String newFormId;
    private final String editFormId;
    private static final Map<String, ResourceType> types = new LinkedHashMap<String, ResourceType>();

    protected ResourceType(String number, String formId) {
        this.number = number;
        this.newFormId = formId;
        this.editFormId = formId;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        Object name = this.name;
        if (name == null) {
            DynamicObject o = BusinessDataServiceHelper.loadSingle((Object)this.number, (String)"iscx_resource_type");
            this.name = name = o.get("name");
        }
        return name.toString();
    }

    public String getNewFormId() {
        return this.newFormId;
    }

    public String getEditFormId() {
        return this.editFormId;
    }

    public String toString() {
        return this.number;
    }

    public boolean isExtensible() {
        return false;
    }

    public abstract Resource parse(long var1, String var3, String var4, Map<String, Object> var5);

    public static ResourceType get(String number) {
        ResourceType type = types.get(number);
        if (type != null) {
            return type;
        }
        throw new UnsupportedOperationException(number);
    }

    private static void register(String number, String formId) {
        ResourceType type = new ResourceType(number, formId){

            @Override
            public Resource parse(long id, String number, String name, Map<String, Object> details) {
                throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"TODO - \u8d44\u6e90\u7c7b\u578b\u89e3\u6790\uff1a%s", (String)"ResourceType_40", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.getNumber()));
            }
        };
        types.put(type.getNumber(), type);
    }

    private void clear() {
        types.clear();
    }

    private static void register(ResourceType type) {
        types.put(type.getNumber(), type);
    }

    static {
        ResourceType.register(new DataEntity.DataEntityParser("DataModel.Entity", "iscx_res_data_entity"));
        ResourceType.register(new DataTable.DataTableParser("DataModel.Table", "iscx_res_data_table"));
        ResourceType.register(new DataView.DataViewParser("DataModel.Query", "iscx_res_data_view"));
        ResourceType.register(new DataComb.DataCombParser("DataModel.DataComb", "iscx_res_data_comb"));
        ResourceType.register(new DataStruct.DataStructParser("DataModel.Struct", "iscx_res_data_struct"));
        ResourceType.register(new ManualEvent.ManualEventParser("EventModel.Manual", "iscx_res_event_manual"));
        ResourceType.register(new TimerEvent.TimerEventParser("EventModel.Timer", "iscx_res_event_timer"));
        ResourceType.register(new BizEvent.BizEventParser("EventModel.BizEvent", "iscx_res_event_biz_op"));
        ResourceType.register(new MQueueEvent.MQueueEventParser("EventModel.MQ", "iscx_res_event_mq_consume"));
        ResourceType.register("EventModel.Poll", "iscx_res_event_poll");
        ResourceType.register(new ApiEvent.ApiEventParser("EventModel.API", "iscx_res_event_api_raiser"));
        ResourceType.register("EventModel.UserDefined", "iscx_res_event_user_def");
        ResourceType.register(new ScriptFunction.ScriptFunctionParser("Function.ScriptFunction", "iscx_res_fn_script"));
        ResourceType.register(new DataQuery.DataQueryParser("DataExtract.DataQuery", "iscx_res_dp_data_query"));
        ResourceType.register(new ScriptReader.ScriptReadParser("DataExtract.ScriptRead", "iscx_res_dp_script_read"));
        ResourceType.register(new DataReader.DataReaderParser("DataExtract.DataRead", "iscx_res_dp_data_read"));
        ResourceType.register(new ScriptQuery.ScriptQueryParser("DataExtract.ScriptQuery", "iscx_res_dp_script_query"));
        ResourceType.register(new EntriesReader.EntriesReaderParser("DataExtract.EntriesRead", "iscx_res_dp_entries_read"));
        ResourceType.register(new ReferReader.ReferReaderParser("DataExtract.ReferRead", "iscx_res_dp_refer_read"));
        ResourceType.register(new DataTableLoad.DataTableLoadParser("DataLoad.TableAction", "iscx_res_ds_table_action"));
        ResourceType.register(new EntityLoad.EntityLoadParser("DataLoad.EntityAction", "iscx_res_ds_entity_action"));
        ResourceType.register(new ScriptLoad.ScriptLoadParser("DataLoad.ScriptLoad", "iscx_res_ds_script_load"));
        ResourceType.register(new ScriptBatchLoad.ScriptBatchLoadParser("DataLoad.ScriptBatchLoad", "iscx_res_ds_script_batch"));
        ResourceType.register(new XTableLoad.XTableLoadParser("DataLoad.XTableAction", "iscx_res_ds_xtable_action"));
        ResourceType.register(new XWebAPI.XWebAPIParser("DataLoad.WebAPI", "iscx_res_ds_webapi"));
        ResourceType.register("DataLoad.MessagePublish", "iscx_res_ds_mq_publish");
        ResourceType.register(new NoticeSend.NoticeSendParser("DataLoad.NoticeSend", "iscx_res_ds_notice_send"));
        ResourceType.register("DataLoad.UserDefEventRaiser", "iscx_res_ds_ude_raiser");
        ResourceType.register(new FieldMapping.FieldMappingParser("DataMapping.FieldMapping", "iscx_res_transfer_field_m"));
        ResourceType.register(new ScriptMapping.ScriptMappingParser("DataMapping.ScriptMapping", "iscx_res_transfer_script"));
        ResourceType.register(new ScriptMappingX.ScriptMappingXParser("DataMapping.ScriptMappingX", "iscx_res_transfer_scriptx"));
        ResourceType.register(new ConstLookupTable.ConstLookupTableParser("ValueConvert.ConstLookupTable", "iscx_res_vc_lookup"));
        ResourceType.register(new SQLRuleX.SQLRuleParser("ValueConvert.SQLRule", "iscx_res_vc_sql"));
        ResourceType.register(new ScriptRule.ScriptRuleParser("ValueConvert.ScriptRule", "iscx_res_vc_script"));
        ResourceType.register("ValueConvert.ManualMappingRule", "iscx_res_vc_manual");
        ResourceType.register(new AutoMappingRule.AutoMappingRuleParser("ValueConvert.AutoMappingRule", "iscx_res_vc_candidate_key"));
        ResourceType.register(new JavaRule.JavaRuleParser("ValueConvert.JavaRule", "iscx_res_vc_java"));
        ResourceType.register(new CompositeRule.CompositeRuleParser("ValueConvert.CompositeRule", "iscx_res_vc_composit_rule"));
        ResourceType.register(new DataFlow.DataFlowResourceParser("DataWeaver.DataFlow", "iscx_res_df_flow_diagram"));
        ResourceType.register("DataWeaver.SubDataFlow", "iscx_res_df_subflow");
        ResourceType.register(new DataFilter.DataFilterParser("DataWeaver.DataFilter", "iscx_res_dw_data_filter"));
        ResourceType.register(new DataFilterX.DataFilterXParser("DataWeaver.DataFilterX", "iscx_res_dw_data_filterx"));
        ResourceType.register(new DataCompare.DataCompareParser("DataWeaver.DataCompare", "iscx_res_dw_data_compare"));
        ResourceType.register(new DataCombInit.DataCombInitParser("DataWeaver.DataCombInit", "iscx_res_dw_data_comb_ini"));
        ResourceType.register("DataWeaver.ScriptCompare", "iscx_res_dw_script_compar");
    }
}

