/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.Script;

public enum ResourceTypeGroup {
    DataModel(new MultiLangEnumBridge("\u6570\u636e\u6a21\u578b", "ResourceTypeGroup_DataModel", "isc-iscx-platform-core"), 1),
    EventModel(new MultiLangEnumBridge("\u4e8b\u4ef6\u6a21\u578b", "ResourceTypeGroup_EventModel", "isc-iscx-platform-core"), 6),
    PublicFunctions(new MultiLangEnumBridge("\u516c\u7528\u51fd\u6570", "ResourceTypeGroup_PublicFunctions", "isc-iscx-platform-core"), 8),
    DataExtraction(new MultiLangEnumBridge("\u6570\u636e\u62bd\u53d6", "ResourceTypeGroup_DataExtraction", "isc-iscx-platform-core"), 2),
    DataLoading(new MultiLangEnumBridge("\u6570\u636e\u52a0\u8f7d", "ResourceTypeGroup_DataLoading", "isc-iscx-platform-core"), 5),
    DataMapping(new MultiLangEnumBridge("\u6570\u636e\u6620\u5c04", "ResourceTypeGroup_DataMapping", "isc-iscx-platform-core"), 3),
    ValueConversion(new MultiLangEnumBridge("\u503c\u8f6c\u6362", "ResourceTypeGroup_ValueConversion", "isc-iscx-platform-core"), 4),
    DataWeaving(new MultiLangEnumBridge("\u6570\u636e\u7f16\u7ec7", "ResourceTypeGroup_DataWeaving", "isc-iscx-platform-core"), 7);

    private final MultiLangEnumBridge desc;
    private final int index;
    private static Log logger;
    private static Map<String, String> defaultGroupMap;

    private ResourceTypeGroup(MultiLangEnumBridge desc, int index) {
        this.desc = desc;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDesc() {
        return this.desc.loadKDString();
    }

    public static String loadKDString(String group) {
        String code = ResourceTypeGroup.getGroupCode(group);
        return ResourceTypeGroup.valueOf(code).getDesc();
    }

    public static String getGroupCode(String group) {
        return defaultGroupMap.get(group);
    }

    public static List<String> getResourceTypeList() {
        ArrayList<String> groupSort = new ArrayList<String>(ResourceTypeGroup.values().length);
        block0: for (int i = 1; i < ResourceTypeGroup.values().length + 1; ++i) {
            for (ResourceTypeGroup value : ResourceTypeGroup.values()) {
                if (value.getIndex() != i) continue;
                for (Map.Entry<String, String> entry : defaultGroupMap.entrySet()) {
                    if (!entry.getValue().equals(value.name())) continue;
                    groupSort.add(entry.getKey());
                    continue block0;
                }
                continue block0;
            }
        }
        return groupSort;
    }

    static {
        logger = LogFactory.getLog(ResourceTypeGroup.class);
        defaultGroupMap = new HashMap<String, String>();
        try (InputStream in = ResourceTypeGroup.class.getResourceAsStream("/res_type_group_cfg.json");){
            String jsonStr = NetUtil.readText((InputStream)in);
            defaultGroupMap = (Map)Script.parseJson((String)jsonStr);
        }
        catch (IOException e) {
            logger.warn("\u5bfc\u5165\u8d44\u6e90\u7c7b\u578b\u5206\u7ec4Json\u6570\u636e\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (Throwable)e);
        }
    }
}

