/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.ResourceFactory;

public class ResourceUtil {
    public static String genateNumber(Object name) {
        String number = Hash.mur32((Object[])new Object[]{name});
        char c = number.charAt(0);
        if (c >= '0' && c <= '9') {
            number = (char)(c + 71 - 48) + number;
        }
        return number;
    }

    public static <T extends Resource> T getResource(long id) {
        return (T)((Resource)CacheableObjectManager.get(Resource.class, (Long)id));
    }

    public static <T extends Resource> T getResource(String number) {
        return (T)((Resource)CacheableObjectManager.getByNumber(Resource.class, (String)number));
    }

    public static <T> T getValue(Map<String, Object> details, String ... path) {
        Object current = details;
        for (String key : path) {
            if (current == null) {
                return null;
            }
            if (!(current instanceof Map)) {
                String message = String.format(ResManager.loadKDString((String)"Key[%1$s]\u9700\u8981\u8bbf\u95ee\u7684\u5bf9\u8c61\u7c7b\u578b\u662f\u201c%2$s\u201d\u3002", (String)"ResourceUtil_8", (String)"isc-iscx-platform-core", (Object[])new Object[0]), key, current.getClass().getName());
                throw new IllegalArgumentException(message);
            }
            current = current.get(key);
        }
        return (T)current;
    }

    public static DynamicObject[] getDepends(Map<String, Object> details) {
        if (details == null) {
            return new DynamicObject[0];
        }
        Set<Long> ids = ResourceUtil.findResourceIds(details);
        if (ids.isEmpty()) {
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("id", "in", ids);
        return BusinessDataServiceHelper.load((String)"iscx_resource", (String)"id,type,number,name", (QFilter[])new QFilter[]{filter});
    }

    public static Set<Long> findResourceIds(Map<String, Object> details) {
        HashSet<Long> ids = new HashSet<Long>();
        ResourceUtil.findResourceIds(ids, details);
        return ids;
    }

    public static Set<Long> findAllResourcesIds(Map<String, Object> details) {
        Set<Long> resourceIds = ResourceUtil.findResourceIds(details);
        LinkedList<Long> q = new LinkedList<Long>(resourceIds);
        while (!q.isEmpty()) {
            long resource_id = (Long)q.poll();
            Map<String, Object> detailsByResourceId = ResourceUtil.getDetailsByResId(resource_id);
            Set<Long> resourceIds_q = ResourceUtil.findResourceIds(detailsByResourceId);
            for (long id : resourceIds_q) {
                if (!resourceIds.add(id)) continue;
                q.add(id);
            }
        }
        return resourceIds;
    }

    public static Set<Long> findAllResourcesIds(long res_id) {
        Map<String, Object> details = ResourceUtil.getDetailsByResId(res_id);
        return ResourceUtil.findAllResourcesIds(details);
    }

    public static Map<String, Object> getDetailsByResId(long id) {
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource_rtm");
        return ResourceUtil.getMergedDetails(res);
    }

    private static void findResourceIds(HashSet<Long> ids, Map<String, Object> details) {
        for (Object value : details.values()) {
            if (value instanceof List) {
                ResourceUtil.findResourceIds(ids, (List)value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                if (!D.x(map.get("$ref"))) {
                    ResourceUtil.findResourceIds(ids, map);
                    continue;
                }
                if ("iscx_resource".equals(map.get("type"))) {
                    ids.add(D.l(map.get("id")));
                    continue;
                }
                throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u8be6\u7ec6\u914d\u7f6e\u4e2d\u5f15\u7528\u4e86\u975e\u6cd5\u7c7b\u578b\u7684F7\u8d44\u6599\uff0c\u5176\u7c7b\u578b\u662f\uff1a%s", (String)"ResourceUtil_9", (String)"isc-iscx-platform-core", (Object[])new Object[0]), map.get("type")));
            }
            if (ResourceUtil.isValid(value)) continue;
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u8be6\u7ec6\u914d\u7f6e\u4e2d\u6709\u975e\u6cd5\u503c\uff0c\u5176\u7c7b\u578b\u662f\uff1a%s", (String)"ResourceUtil_10", (String)"isc-iscx-platform-core", (Object[])new Object[0]), value.getClass().getSimpleName()));
        }
    }

    private static void findResourceIds(HashSet<Long> ids, List<Map<String, Object>> items) {
        for (Map<String, Object> i : items) {
            ResourceUtil.findResourceIds(ids, i);
        }
    }

    private static boolean isValid(Object value) {
        return value == null || value instanceof String || value instanceof Long || value instanceof Integer || value instanceof Boolean || value instanceof BigDecimal;
    }

    public static Map<String, Object> getMergedDetails(DynamicObject res) {
        assert ("iscx_resource_rtm".equals(res.getDataEntityType().getName()));
        Map details = (Map)Json.toObject((String)D.s((Object)res.get("details_tag")));
        if (details == null) {
            return new HashMap<String, Object>();
        }
        Map ext = (Map)Json.toObject((String)D.s((Object)res.get("extensions_tag")));
        if (ext != null) {
            ResourceUtil.mergeMap(details, ext);
        }
        return details;
    }

    private static void mergeMap(Map<String, Object> details, Map<String, Object> ext) {
        for (Map.Entry<String, Object> e : ext.entrySet()) {
            String key = e.getKey();
            Object extValue = e.getValue();
            Object originalValue = details.get(key);
            if (extValue == null || originalValue == null) {
                details.put(key, extValue);
                continue;
            }
            if (extValue instanceof Map) {
                if (originalValue instanceof Map) {
                    ResourceUtil.mergeMap((Map)originalValue, (Map)extValue);
                    continue;
                }
                throw new IscBizException(ResourceUtil.generateInvalidExtensionMessage(key, originalValue, extValue));
            }
            if (extValue instanceof List) {
                if (originalValue instanceof List) {
                    ResourceUtil.mergeList((List)originalValue, (List)extValue);
                    continue;
                }
                throw new IscBizException(ResourceUtil.generateInvalidExtensionMessage(key, originalValue, extValue));
            }
            details.put(key, extValue);
        }
    }

    private static String generateInvalidExtensionMessage(String key, Object original, Object value) {
        return String.format(ResManager.loadKDString((String)"\u6269\u5c55\u4e0d\u517c\u5bb9\uff0ckey\u662f\uff1a%1$s\uff0c\u539f\u503c\u662f\uff1a%2$s\uff0c\u6269\u5c55\u503c\u662f\uff1a%3$s", (String)"ResourceUtil_11", (String)"isc-iscx-platform-core", (Object[])new Object[0]), key, Json.toString((Object)original), Json.toString((Object)value));
    }

    private static void mergeList(List<Map<String, Object>> details, List<Map<String, Object>> ext) {
        ResourceUtil.preprocessList(details);
        ResourceUtil.preprocessList(ext);
        Map<String, Map<String, Object>> extMap = ResourceUtil.list2map(ext);
        for (Map<String, Object> originalItem : details) {
            Map<String, Object> map = extMap.remove(D.s((Object)originalItem.get("id")));
            if (map == null) continue;
            ResourceUtil.mergeMap(originalItem, map);
        }
        for (Map<String, Object> extItem : extMap.values()) {
            details.add(extItem);
        }
        if (ResourceUtil.hasDeletedItems(details)) {
            ArrayList<Map<String, Object>> temp = new ArrayList<Map<String, Object>>(details);
            details.clear();
            for (Map map : temp) {
                if (D.x(map.get("#deleted"))) continue;
                details.add(map);
            }
        }
    }

    private static boolean hasDeletedItems(List<Map<String, Object>> details) {
        for (Map<String, Object> item : details) {
            if (!D.x((Object)item.get("#deleted"))) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Map<String, Object>> list2map(List<Map<String, Object>> items) {
        HashMap<String, Map<String, Object>> mapping = new HashMap<String, Map<String, Object>>(items.size());
        for (Map<String, Object> item : items) {
            String id = D.s((Object)item.get("id"));
            if (id != null) {
                Map<String, Object> prior = mapping.put(id, item);
                if (prior == null) continue;
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884cID\u91cd\u590d\uff0c\u5206\u5f55\u5185\u5bb9\u662f\uff1a%s", (String)"ResourceUtil_12", (String)"isc-iscx-platform-core", (Object[])new Object[0]), Json.toString(item)));
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u6ca1\u6709\u8bbe\u7f6eID\uff0c\u5206\u5f55\u5185\u5bb9\u662f\uff1a%s", (String)"ResourceUtil_13", (String)"isc-iscx-platform-core", (Object[])new Object[0]), Json.toString(item)));
        }
        return mapping;
    }

    private static void preprocessList(List<Map<String, Object>> items) {
        for (Map<String, Object> item : items) {
            Object key;
            if (item.containsKey("id") || (key = item.get("key")) == null) continue;
            item.put("id", key);
        }
    }

    public static Map<String, Object> calcDiff(Map<String, Object> details, Map<String, Object> originalDetails) {
        HashMap<String, Object> diff = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : details.entrySet()) {
            Object diffValue;
            String key = e.getKey();
            Object value = e.getValue();
            Object original = originalDetails.get(key);
            if (value == null) {
                if (original == null) continue;
                diff.put(key, null);
                continue;
            }
            if (original == null) {
                diff.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                diffValue = ResourceUtil.calcDiff((Map)value, (Map)original);
                if (diffValue == null) continue;
                diff.put(key, diffValue);
                continue;
            }
            if (value instanceof List) {
                diffValue = ResourceUtil.calcDiff((List)value, (List)original);
                if (diffValue == null) continue;
                diff.put(key, diffValue);
                continue;
            }
            if (Objects.equals(D.s((Object)value), D.s((Object)original))) continue;
            diff.put(key, value);
        }
        return diff.isEmpty() ? null : diff;
    }

    private static List<Map<String, Object>> calcDiff(List<Map<String, Object>> list, List<Map<String, Object>> originalItems) {
        ResourceUtil.preprocessList(list);
        ResourceUtil.preprocessList(originalItems);
        ArrayList<Map<String, Object>> diff = new ArrayList<Map<String, Object>>(list.size());
        Map<String, Map<String, Object>> originalMap = ResourceUtil.list2map(originalItems);
        for (Map<String, Object> item : list) {
            Map<String, Object> originalItem = originalMap.remove(D.s((Object)item.get("id")));
            if (originalItem == null) {
                diff.add(item);
                continue;
            }
            Map<String, Object> diffItem = ResourceUtil.calcDiff(item, originalItem);
            if (diffItem == null) continue;
            diffItem.put("id", item.get("id"));
            diff.add(diffItem);
        }
        for (Map<String, Object> item : originalMap.values()) {
            item.put("#deleted", Boolean.TRUE);
            diff.add(item);
        }
        return diff.isEmpty() ? null : diff;
    }

    public static void copy(DynamicObject src, DynamicObject tar, String ... fields) {
        for (String field : fields) {
            tar.set(field, src.get(field));
        }
    }

    public static void copy(DynamicObject src, List<Object> tar, String ... fields) {
        for (String field : fields) {
            tar.add(src.get(field));
        }
    }

    public static List<Map<String, Object>> buildMultiStringFieldMap() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> item_zh_CN = new HashMap<String, Object>();
        item_zh_CN.put("field", "zh_CN");
        item_zh_CN.put("label", ResManager.loadKDString((String)"\u7b80\u4f53\u4e2d\u6587", (String)"ResourceUtil_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        item_zh_CN.put("data_type", "string");
        item_zh_CN.put("is_primary_key", Boolean.FALSE);
        item_zh_CN.put("is_required", Boolean.FALSE);
        item_zh_CN.put("is_private", Boolean.FALSE);
        item_zh_CN.put("is_multiple", Boolean.FALSE);
        HashMap<String, Object> item_zh_TW = new HashMap<String, Object>();
        item_zh_TW.put("field", "zh_TW");
        item_zh_TW.put("label", ResManager.loadKDString((String)"\u7e41\u4f53\u4e2d\u6587", (String)"ResourceUtil_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        item_zh_TW.put("data_type", "string");
        item_zh_TW.put("is_primary_key", Boolean.FALSE);
        item_zh_TW.put("is_required", Boolean.FALSE);
        item_zh_TW.put("is_private", Boolean.FALSE);
        item_zh_TW.put("is_multiple", Boolean.FALSE);
        HashMap<String, Object> item_en_US = new HashMap<String, Object>();
        item_en_US.put("field", "en_US");
        item_en_US.put("label", ResManager.loadKDString((String)"\u82f1\u6587", (String)"ResourceUtil_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        item_en_US.put("data_type", "string");
        item_en_US.put("is_primary_key", Boolean.FALSE);
        item_en_US.put("is_required", Boolean.FALSE);
        item_en_US.put("is_private", Boolean.FALSE);
        item_en_US.put("is_multiple", Boolean.FALSE);
        result.add(item_zh_CN);
        result.add(item_zh_TW);
        result.add(item_en_US);
        return result;
    }

    static {
        CacheableObjectManager.registerFactory((CacheableObjectFactory)new ResourceFactory());
    }
}

