/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.build;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.build.bean.XActionObj;
import kd.isc.iscx.platform.core.res.meta.build.bean.XDataComb;
import kd.isc.iscx.platform.core.res.meta.build.bean.XDataCombInit;
import kd.isc.iscx.platform.core.res.meta.build.bean.load.XDataCombAction;
import kd.isc.iscx.platform.core.res.meta.build.bean.load.XEntityAction;
import kd.isc.iscx.platform.core.res.meta.build.bean.load.XScriptBatchLoad;
import kd.isc.iscx.platform.core.res.meta.build.bean.load.XScriptLoad;
import kd.isc.iscx.platform.core.res.meta.build.bean.load.XTableAction;
import kd.isc.iscx.platform.core.res.meta.build.bean.mapping.XFieldMapping;
import kd.isc.iscx.platform.core.res.meta.build.bean.mapping.XScriptMapping;
import kd.isc.iscx.platform.core.res.meta.build.bean.query.XEntriesRead;
import kd.isc.iscx.platform.core.res.meta.build.bean.query.XReferRead;
import kd.isc.iscx.platform.core.res.meta.build.bean.query.XScriptRead;
import kd.isc.iscx.platform.core.res.meta.build.util.ModelUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ResEditorUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ResNumberUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dt.Field;

public class XDataCopyBuild {
    private String pre_number;
    private DynamicObject dataCopy;
    private DynamicObject srcModule;
    private DynamicObject tarModule;
    private DynamicObject solutionCatalog;
    private DynamicObject source_schema;
    private DynamicObject target_schema;
    private String reader_script;
    private String mapping_script;
    private String target_script;
    private String handler_class;
    private String proxy_user;
    private List<XActionObj> targetAction = new ArrayList<XActionObj>();
    private DynamicObject input;
    private DynamicObject inputDataComb;
    private DynamicObject inputDataCombInit;
    private DynamicObject output;
    private DynamicObject outputDataComb;
    private DynamicObject iscxFieldMapping;
    private DynamicObject scriptMapping;
    private DynamicObject scriptRead;
    private DynamicObject scriptLoad;
    private Map<String, DynamicObject> scriptBatchLoad;
    private Map<String, List<DynamicObject>> entityActionMap;
    private Map<String, List<DynamicObject>> tableActionMap;
    private Map<String, List<DynamicObject>> dataCombActionActionMap;
    private DynamicObject scriptLoad_class;
    private DynamicObject RESPONSE_OF_DATA_LOAD;
    private Set<Integer> batchSizeList;
    private List<Map<String, Object>> result_fields;
    private List<DynamicObject> buildResList = new ArrayList<DynamicObject>(8);
    private List<Map<String, Object>> srcRefTableList = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> srcEntryTableList = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> tarEntryTableList = new ArrayList<Map<String, Object>>();

    public XDataCopyBuild(DynamicObject dataCopy, DynamicObject srcModule, DynamicObject tarModule, DynamicObject solutionCatalog, Set<Integer> batchSizeList) {
        this.dataCopy = dataCopy;
        this.srcModule = srcModule;
        this.tarModule = tarModule;
        this.solutionCatalog = solutionCatalog;
        this.batchSizeList = batchSizeList;
        this.initParams();
        this.build();
    }

    private void build() {
        DynamicObject obj;
        String name;
        this.input = ModelUtil.createModel(D.l((Object)this.source_schema.getPkValue()), D.l((Object)this.srcModule.getPkValue()));
        this.buildResList.add(this.input);
        this.output = ModelUtil.createModel(D.l((Object)this.target_schema.getPkValue()), D.l((Object)this.tarModule.getPkValue()));
        this.buildResList.add(this.output);
        this.setResultFields();
        this.importRelationModel(this.srcRefTableList, D.l((Object)this.srcModule.getPkValue()));
        this.importRelationModel(this.srcEntryTableList, D.l((Object)this.srcModule.getPkValue()));
        this.importRelationModel(this.tarEntryTableList, D.l((Object)this.tarModule.getPkValue()));
        if (!this.srcRefTableList.isEmpty() || !this.srcEntryTableList.isEmpty()) {
            ArrayList<Map<String, Object>> temp = new ArrayList<Map<String, Object>>();
            temp.addAll(this.srcRefTableList);
            temp.addAll(this.srcEntryTableList);
            StringBuilder str = new StringBuilder(D.s((Object)this.input.getPkValue()));
            for (Map map : temp) {
                DynamicObject iscx_model2 = (DynamicObject)map.get("iscx_model");
                str.append(iscx_model2.getPkValue()).append(map.get("relation_alias")).append(map.get("relation_type"));
            }
            String string = ResNumberUtil.buildNumber(this.pre_number, str.toString());
            String string2 = String.format(ResManager.loadKDString((String)"%1$s\u6570\u636e\u7ec4\u5408", (String)"XDataCopyBuild_9", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.input.getString("number"));
            this.inputDataComb = new XDataComb(string, string2, this.input, temp, this.srcModule).build();
            String initNumber = ResNumberUtil.buildNumber(this.pre_number, D.s((Object)this.inputDataComb.getPkValue()));
            String initName = String.format(ResManager.loadKDString((String)"%1$s_\u6570\u636e\u7ec4\u5408\u521d\u59cb\u5316", (String)"XDataCopyBuild_10", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.inputDataComb.getString("number"));
            this.inputDataCombInit = new XDataCombInit(initNumber, initName, this.inputDataComb, this.srcModule).build();
        }
        if (!this.tarEntryTableList.isEmpty()) {
            Iterator<Map<String, Object>> str = new StringBuilder(D.s((Object)this.input.getPkValue()));
            for (Map map : this.tarEntryTableList) {
                DynamicObject dynamicObject = (DynamicObject)map.get("iscx_model");
                ((StringBuilder)((Object)str)).append(dynamicObject.getPkValue()).append(map.get("relation_alias")).append(map.get("relation_type"));
            }
            String number3 = ResNumberUtil.buildNumber(this.pre_number, ((StringBuilder)((Object)str)).toString());
            String string = String.format(ResManager.loadKDString((String)"%1$s\u6570\u636e\u7ec4\u5408", (String)"XDataCopyBuild_9", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.output.getString("number"));
            this.outputDataComb = new XDataComb(number3, string, this.output, this.tarEntryTableList, this.tarModule).build();
        }
        if (!this.srcRefTableList.isEmpty()) {
            for (Map<String, Object> map : this.srcRefTableList) {
                DynamicObject dynamicObject = (DynamicObject)map.get("iscx_model");
                String string = ResNumberUtil.buildNumber(this.pre_number, D.s((Object)dynamicObject.getPkValue()) + "DataExtract.ReferRead");
                name = String.format(ResManager.loadKDString((String)"%1$s_\u5f15\u7528\u6570\u636e\u8bfb\u53d6%2$s", (String)"XDataCopyBuild_11", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.inputDataComb.getString("number"), map.get("relation_alias"));
                obj = new XReferRead(string, name, this.srcModule, this.inputDataComb, map).build();
                map.put("referRead", obj);
            }
        }
        if (!this.srcEntryTableList.isEmpty()) {
            for (Map<String, Object> map : this.srcEntryTableList) {
                DynamicObject dynamicObject = (DynamicObject)map.get("iscx_model");
                String string = ResNumberUtil.buildNumber(this.pre_number, D.s((Object)dynamicObject.getPkValue()) + "DataExtract.EntriesRead");
                name = String.format(ResManager.loadKDString((String)"%1$s_\u5206\u5f55\u6570\u636e\u8bfb\u53d6%2$s", (String)"XDataCopyBuild_12", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.inputDataComb.getString("number"), map.get("relation_alias"));
                obj = new XEntriesRead(string, name, this.srcModule, this.inputDataComb, map).build();
                map.put("entriesRead", obj);
            }
        }
        if (this.reader_script != null) {
            this.scriptRead = this.createScriptRead();
            this.buildResList.add(this.scriptRead);
        }
        if (this.mapping_script != null) {
            this.scriptMapping = this.createScriptMapping();
            this.buildResList.add(this.scriptMapping);
        }
        this.createFieldMapping();
        if (this.handler_class != null) {
            this.scriptLoad_class = this.createScriptLoadClass();
            this.buildResList.add(this.scriptLoad_class);
        } else if (this.target_script != null) {
            if (this.target_script.contains("_tars")) {
                this.createScriptBatchLoad();
            } else {
                this.scriptLoad = this.createScriptLoad();
                this.buildResList.add(this.scriptLoad);
            }
        } else {
            String type = D.s((Object)this.target_schema.get("type"));
            if ("ENTITY".equals(type)) {
                this.createEntityAction();
            } else if ("TABLE".equals(type)) {
                if (this.outputDataComb == null) {
                    this.createTableAction();
                } else {
                    this.createDataCombAction();
                }
            }
        }
    }

    private void createDataCombAction() {
        Map<String, Object> f7input = ResEditorUtil.toMap(this.outputDataComb);
        Map<String, Object> f7output = ResEditorUtil.toMap(this.RESPONSE_OF_DATA_LOAD);
        this.dataCombActionActionMap = new HashMap<String, List<DynamicObject>>(this.batchSizeList.size());
        for (Integer integer : this.batchSizeList) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(this.targetAction.size());
            for (XActionObj obj : this.targetAction) {
                StringBuilder str = new StringBuilder("DataLoad.XTableAction");
                StringBuilder name_str = new StringBuilder(D.s((Object)this.output.get("name")));
                if (obj == null) continue;
                str.append(obj.toString());
                str.append(integer);
                String number = ResNumberUtil.buildNumber(this.pre_number, str.toString());
                String name = name_str.append('_').append(obj.getAction()).toString();
                list.add(new XDataCombAction(number, name, f7input, f7output, integer, obj, this.tarEntryTableList, this.result_fields, this.tarModule).build());
            }
            this.dataCombActionActionMap.put(integer.toString(), list);
            this.buildResList.addAll(list);
        }
    }

    private void importRelationModel(List<Map<String, Object>> src_ref_table_list, long catalogId) {
        for (Map<String, Object> map : src_ref_table_list) {
            DynamicObject obj = ModelUtil.createModel(D.l((Object)map.get("data_table")), catalogId);
            map.put("iscx_model", obj);
        }
    }

    private List<String> getRequestField(DynamicObjectCollection objects, String column, String relation_alias) {
        ArrayList<String> fields = new ArrayList<String>();
        for (DynamicObject object : objects) {
            String field = D.s((Object)object.getString(column));
            if (field == null || !field.startsWith(relation_alias)) continue;
            fields.add(field.substring(relation_alias.length() + 1));
        }
        return fields;
    }

    private void createTableAction() {
        Map<String, Object> f7input = ResEditorUtil.toMap(this.output);
        Map<String, Object> f7output = ResEditorUtil.toMap(this.RESPONSE_OF_DATA_LOAD);
        this.tableActionMap = new HashMap<String, List<DynamicObject>>(this.batchSizeList.size());
        for (Integer integer : this.batchSizeList) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(this.targetAction.size());
            for (XActionObj obj : this.targetAction) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("number", ResNumberUtil.buildNumber(this.pre_number, obj.toString() + integer));
                map.put("proxy_user", this.proxy_user);
                map.put("batch_size", integer);
                map.put("name", String.format(ResManager.loadKDString((String)"%1$s_%2$s", (String)"XDataCopyBuild_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.output.getString("name"), obj.getAction()));
                list.add(new XTableAction(f7input, f7output, map, obj, this.result_fields, this.tarModule).build());
            }
            this.tableActionMap.put(integer.toString(), list);
            this.buildResList.addAll(list);
        }
    }

    private void createEntityAction() {
        Map<String, Object> f7input = ResEditorUtil.toMap(this.output);
        Map<String, Object> f7output = ResEditorUtil.toMap(this.RESPONSE_OF_DATA_LOAD);
        this.entityActionMap = new HashMap<String, List<DynamicObject>>(this.batchSizeList.size());
        for (Integer integer : this.batchSizeList) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(this.targetAction.size());
            for (XActionObj obj : this.targetAction) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("number", ResNumberUtil.buildNumber(this.pre_number, obj.toString() + integer));
                map.put("proxy_user", this.proxy_user);
                map.put("batch_size", integer);
                map.put("name", String.format(ResManager.loadKDString((String)"%1$s_%2$s", (String)"XDataCopyBuild_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.output.getString("name"), obj.getName()));
                list.add(new XEntityAction(map, f7input, f7output, obj, this.tarModule, this.result_fields).build());
            }
            this.entityActionMap.put(integer.toString(), list);
            this.buildResList.addAll(list);
        }
    }

    private void createFieldMapping() {
        String number = ResNumberUtil.buildNumber(this.pre_number, this.dataCopy.getLong("id"), "DataMapping.FieldMapping");
        Map<String, Object> f7input = ResEditorUtil.toMap(this.input);
        Map<String, Object> f7inputDataComb = ResEditorUtil.toMap(this.inputDataComb);
        Map<String, Object> f7output = ResEditorUtil.toMap(this.output);
        Map<String, Object> f7outputDataComb = ResEditorUtil.toMap(this.outputDataComb);
        ArrayList<Map<String, Object>> mapping_entries = new ArrayList<Map<String, Object>>();
        for (DynamicObject mappingEntry : this.dataCopy.getDynamicObjectCollection("mapping_entries")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", IDService.get().genLongId());
            map.put("tar_column", mappingEntry.get("mapping_tar_column"));
            map.put("tar_desc", mappingEntry.get("tar_desc"));
            map.put("fixed_value", mappingEntry.get("fixed_value"));
            map.put("src_column", mappingEntry.get("mapping_src_column"));
            map.put("src_desc", mappingEntry.get("src_desc"));
            map.put("aggr_fn", mappingEntry.get("aggr_fn"));
            if (mappingEntry.get("value_conver_rule") != null) {
                String srcColumn = D.s((Object)mappingEntry.get("mapping_src_column"));
                String tarColumn = D.s((Object)mappingEntry.get("mapping_tar_column"));
                if (srcColumn != null && tarColumn != null) {
                    map.put("vc_rule", D.l((Object)mappingEntry.getDynamicObject("value_conver_rule").getPkValue()));
                } else if (tarColumn != null && D.s((Object)mappingEntry.get("fixed_value")) != null) {
                    map.put("vc_rule", D.l((Object)mappingEntry.getDynamicObject("value_conver_rule").getPkValue()));
                }
            }
            mapping_entries.add(map);
        }
        HashMap<String, Object> catalog = new HashMap<String, Object>(3);
        catalog.put("srcCatalog", this.srcModule);
        catalog.put("tarCatalog", this.tarModule);
        catalog.put("solutionCatalog", this.solutionCatalog);
        this.iscxFieldMapping = new XFieldMapping(number, this.dataCopy.getString("name"), catalog, mapping_entries, f7input, f7output, f7inputDataComb, f7outputDataComb).build();
        this.buildResList.add(this.iscxFieldMapping);
    }

    public DynamicObject createScriptLoad() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("number", ResNumberUtil.buildNumber(this.pre_number, this.dataCopy.getLong("id"), "DataExtract.ScriptRead"));
        map.put("name", String.format(ResManager.loadKDString((String)"%1$s_\u811a\u672c\u52a0\u8f7d", (String)"XDataCopyBuild_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]), D.s((Object)this.dataCopy.get("name"))));
        map.put("scriptTitle", D.s((Object)this.dataCopy.get("target_script")));
        map.put("script", "var params = $stream.params;\n" + D.s((Object)this.dataCopy.get("target_script_tag")));
        Map<String, Object> f7input = ResEditorUtil.toMap(this.output);
        Map<String, Object> f7output = ResEditorUtil.toMap(this.RESPONSE_OF_DATA_LOAD);
        return new XScriptLoad(map, this.tarModule, f7input, f7output).build();
    }

    private void createScriptBatchLoad() {
        Map<String, Object> f7input = ResEditorUtil.toMap(this.output);
        Map<String, Object> f7output = ResEditorUtil.toMap(this.RESPONSE_OF_DATA_LOAD);
        String target_script = D.s((Object)this.dataCopy.get("target_script"));
        String target_script_tag = D.s((Object)this.dataCopy.get("target_script_tag"));
        this.scriptBatchLoad = new HashMap<String, DynamicObject>(this.batchSizeList.size());
        for (Integer integer : this.batchSizeList) {
            String number = ResNumberUtil.buildNumber(this.pre_number, target_script_tag + integer);
            String name = String.format(ResManager.loadKDString((String)"%1$s_\u811a\u672c\u6279\u91cf\u52a0\u8f7d", (String)"XDataCopyBuild_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), D.s((Object)this.dataCopy.get("name")));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("number", number);
            map.put("name", name);
            map.put("scriptTitle", target_script);
            map.put("script", "var params = $stream.params;\n" + target_script_tag);
            map.put("batch_size", integer);
            this.scriptBatchLoad.put(integer.toString(), new XScriptBatchLoad(map, this.tarModule, f7input, f7output).build());
        }
        this.buildResList.addAll(this.scriptBatchLoad.values());
    }

    public DynamicObject createScriptLoadClass() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("number", ResNumberUtil.buildNumber(this.pre_number, this.dataCopy.getLong("id"), "DataLoad.ScriptLoadClass"));
        map.put("name", String.format(ResManager.loadKDString((String)"%s_\u8c03\u7528\u76ee\u6807\u5904\u7406\u7c7b", (String)"XDataCopyBuild_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]), D.s((Object)this.dataCopy.get("name"))));
        map.put("scriptTitle", ResManager.loadKDString((String)"\u8c03\u7528\u76ee\u6807\u5904\u7406\u7c7b", (String)"XDataCopyBuild_4", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        Map<String, List<String>> judgeFields = this.getJudgeFields(this.dataCopy);
        map.put("script", "var judgeFields = " + Json.toString(judgeFields, (boolean)true) + ";\nInvokeHandlerClass($tar, \"" + this.handler_class + "\", tar, judgeFields, null);");
        Map<String, Object> f7input = ResEditorUtil.toMap(this.output);
        Map<String, Object> f7output = ResEditorUtil.toMap(this.RESPONSE_OF_DATA_LOAD);
        return new XScriptLoad(map, this.tarModule, f7input, f7output).build();
    }

    private Map<String, List<String>> getJudgeFields(DynamicObject dataCopy) {
        DynamicObjectCollection collection = dataCopy.getDynamicObjectCollection("mapping_entries");
        ArrayList<String> mainjudgeFields = new ArrayList<String>();
        HashMap<String, List<String>> entryJudgeFields = new HashMap<String, List<String>>();
        for (DynamicObject object : collection) {
            String field_name = D.s((Object)object.get("mapping_tar_column"));
            if (field_name == null || !D.x((Object)object.get("candidate_key"))) continue;
            int i = field_name.lastIndexOf(46);
            if (i > 0) {
                String entry = field_name.substring(0, i);
                String field = field_name.substring(i + 1);
                ArrayList<String> fields = (ArrayList<String>)entryJudgeFields.get(entry);
                if (fields == null) {
                    fields = new ArrayList<String>(2);
                    entryJudgeFields.put(entry, fields);
                }
                if (fields.contains(field)) continue;
                fields.add(field);
                continue;
            }
            if (mainjudgeFields.contains(field_name)) continue;
            mainjudgeFields.add(field_name);
        }
        entryJudgeFields.put("$", mainjudgeFields);
        return entryJudgeFields;
    }

    public DynamicObject createScriptMapping() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("number", ResNumberUtil.buildNumber(this.pre_number, this.dataCopy.getLong("id"), "DataMapping.ScriptMapping"));
        map.put("name", String.format(ResManager.loadKDString((String)"%1$s_\u8f6c\u6362\u811a\u672c", (String)"XDataCopyBuild_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]), D.s((Object)this.dataCopy.get("name"))));
        map.put("scriptTitle", D.s((Object)this.dataCopy.get("mapping_script")));
        map.put("script", "var params = $stream.params;\n" + D.s((Object)this.dataCopy.get("mapping_script_tag")));
        Map<String, Object> f7input = ResEditorUtil.toMap(this.input);
        Map<String, Object> f7output = ResEditorUtil.toMap(this.output);
        return new XScriptMapping(map, this.solutionCatalog, f7input, f7output).build();
    }

    public DynamicObject createScriptRead() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("number", ResNumberUtil.buildNumber(this.pre_number, this.dataCopy.getLong("id"), "DataExtract.ScriptRead"));
        map.put("name", String.format(ResManager.loadKDString((String)"%1$s_\u811a\u672c\u8bfb\u53d6", (String)"XDataCopyBuild_6", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.dataCopy.getString("name")));
        map.put("scriptTitle", D.s((Object)this.dataCopy.get("reader_script")));
        map.put("script", D.s((Object)this.dataCopy.get("reader_script_tag")));
        return new XScriptRead(ResEditorUtil.toMap(this.input), map, this.srcModule).build();
    }

    private void initParams() {
        this.RESPONSE_OF_DATA_LOAD = BusinessDataServiceHelper.loadSingle((String)"iscx_resource", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"RESPONSE_OF_DATA_LOAD")});
        this.source_schema = MetaDataSchema.get((long)D.l((Object)this.dataCopy.getDynamicObject("source_schema").getPkValue()));
        this.target_schema = MetaDataSchema.get((long)D.l((Object)this.dataCopy.getDynamicObject("target_schema").getPkValue()));
        this.checkMetaType(this.source_schema);
        this.checkMetaType(this.target_schema);
        this.pre_number = ResNumberUtil.generateNumber(this.dataCopy.getLong("id"));
        this.reader_script = D.s((Object)this.dataCopy.get("reader_script_tag"));
        this.mapping_script = D.s((Object)this.dataCopy.get("mapping_script_tag"));
        this.handler_class = D.s((Object)this.dataCopy.get("target_handler"));
        this.target_script = D.s((Object)this.dataCopy.get("target_script_tag"));
        this.proxy_user = D.s((Object)this.dataCopy.get("proxy_user"));
        DynamicObjectCollection collection = this.dataCopy.getDynamicObjectCollection("target_actions");
        String schemaType = D.s((Object)this.target_schema.get("type"));
        if (collection.isEmpty()) {
            XActionObj obj;
            if ("TABLE".equals(schemaType)) {
                obj = new XActionObj("_SAVE", "", "save");
                this.targetAction.add(obj);
            }
            if ("ENTITY".equals(schemaType)) {
                obj = new XActionObj("save", "", "save");
                this.targetAction.add(obj);
            }
        } else {
            for (DynamicObject object : collection) {
                XActionObj obj = new XActionObj(object.getString("tar_action_number"), object.getString("tar_action_params"), object.getString("tar_action_label"));
                this.targetAction.add(obj);
            }
        }
        this.initRelationsTableList();
    }

    private void setResultFields() {
        this.result_fields = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection collection = this.dataCopy.getDynamicObjectCollection("mapping_entries");
        int i = 1;
        Object resource = ResourceUtil.getResource(D.l((Object)this.output.get("id")));
        for (DynamicObject object : collection) {
            String field_name = D.s((Object)object.get("mapping_tar_column"));
            String fixed_value = D.s((Object)object.get("fixed_value"));
            String mapping_src_column = D.s((Object)object.get("mapping_src_column"));
            if (field_name == null || fixed_value == null && mapping_src_column == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seq", i++);
            map.put("field_name", field_name);
            map.put("field_label", D.s((Object)object.get("tar_desc")));
            Field field = ((AbstractDataModel)resource).getDataType().findField(field_name);
            if (field == null) {
                map.put("data_type", "unknown");
            } else {
                map.put("data_type", D.s((Object)field.getType()));
            }
            map.put("id", D.s((Object)IDService.get().genLongId()));
            map.put("is_candidate_key", D.x((Object)object.get("candidate_key")));
            this.result_fields.add(map);
        }
    }

    private void checkMetaType(DynamicObject metadataSchema) {
        String schemaType = D.s((Object)metadataSchema.get("type"));
        if (!("ENTITY".equals(schemaType) || "TABLE".equals(schemaType) || "VIEW".equals(schemaType))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u76ee\u524d\u4ec5\u652f\u6301\u6e90/\u76ee\u6807\u5bf9\u8c61\u4e3a\u3010\u5b9e\u4f53\u3001\u6570\u636e\u8868\u3001\u89c6\u56fe\u3011\u7684\u542f\u52a8\u65b9\u6848\u5feb\u901f\u8f6c\u6362\uff0c\u4e0d\u652f\u6301\uff1a%s", (String)"XDataCopyBuild_8", (String)"isc-iscx-platform-core", (Object[])new Object[0]), schemaType));
        }
    }

    public String getPre_number() {
        return this.pre_number;
    }

    public DynamicObject getInput() {
        return this.input;
    }

    public DynamicObject getOutput() {
        return this.output;
    }

    public DynamicObject getIscxFieldMapping() {
        return this.iscxFieldMapping;
    }

    public DynamicObject getScriptMapping() {
        return this.scriptMapping;
    }

    public DynamicObject getScriptRead() {
        return this.scriptRead;
    }

    public DynamicObject getDataCopy() {
        return this.dataCopy;
    }

    public DynamicObject getSrcModule() {
        return this.srcModule;
    }

    public DynamicObject getTarModule() {
        return this.tarModule;
    }

    public DynamicObject getSolutionCatalog() {
        return this.solutionCatalog;
    }

    public DynamicObject getTarget_schema() {
        return this.target_schema;
    }

    public String getMapping_script() {
        return this.mapping_script;
    }

    public DynamicObject getRESPONSE_OF_DATA_LOAD() {
        return this.RESPONSE_OF_DATA_LOAD;
    }

    public DynamicObject getScriptLoad_class() {
        return this.scriptLoad_class;
    }

    public DynamicObject getScriptLoad() {
        return this.scriptLoad;
    }

    public DynamicObject getScriptBatchLoad(int batch_size) {
        return this.scriptBatchLoad.get(D.s((Object)batch_size));
    }

    public List<DynamicObject> getEntityActionMap(int batch_size) {
        if (this.entityActionMap == null) {
            return Collections.emptyList();
        }
        List<DynamicObject> list = this.entityActionMap.get(String.valueOf(batch_size));
        return list != null ? list : Collections.emptyList();
    }

    public List<DynamicObject> getTableActionMap(int batch_size) {
        if (this.tableActionMap == null) {
            return Collections.emptyList();
        }
        List<DynamicObject> list = this.tableActionMap.get(String.valueOf(batch_size));
        return list != null ? list : Collections.emptyList();
    }

    public List<DynamicObject> getBuildResList() {
        return new ArrayList<DynamicObject>(this.buildResList);
    }

    private void initRelationsTableList() {
        DynamicObjectCollection relation_mapping = this.dataCopy.getDynamicObjectCollection("relation_mapping");
        DynamicObjectCollection mapping_entries = this.dataCopy.getDynamicObjectCollection("mapping_entries");
        if (!relation_mapping.isEmpty()) {
            for (DynamicObject object : relation_mapping) {
                List<String> field;
                String relation_type = object.getString("relation_type");
                DynamicObject master_table = object.getDynamicObject("master_table");
                DynamicObject data_table = object.getDynamicObject("data_table");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("relation_type", relation_type);
                map.put("data_table", data_table.getPkValue());
                map.put("master_field", D.s((Object)object.getString("master_field")));
                map.put("master_ref_field", D.s((Object)object.getString("master_ref_field")));
                String relation_alias = D.s((Object)object.getString("relation_alias"));
                map.put("relation_alias", relation_alias);
                map.put("entry_order_by", object.getString("entry_order_by"));
                if (D.l((Object)this.source_schema.getPkValue()) == D.l((Object)master_table.getPkValue())) {
                    field = this.getRequestField(mapping_entries, "mapping_src_column", relation_alias);
                    map.put("select_field", field);
                    if ("entry_table".equals(relation_type)) {
                        this.srcEntryTableList.add(map);
                        continue;
                    }
                    if (!"ref_table".equals(relation_type)) continue;
                    this.srcRefTableList.add(map);
                    continue;
                }
                if (D.l((Object)this.target_schema.getPkValue()) != D.l((Object)master_table.getPkValue())) continue;
                field = this.getRequestField(mapping_entries, "mapping_tar_column", relation_alias);
                map.put("select_field", field);
                if (!"entry_table".equals(relation_type)) continue;
                this.tarEntryTableList.add(map);
            }
        }
    }

    public DynamicObject getInputDataCombInit() {
        return this.inputDataCombInit;
    }

    public List<Map<String, Object>> getSrcRefTableList() {
        return this.srcRefTableList;
    }

    public List<Map<String, Object>> getSrcEntryTableList() {
        return this.srcEntryTableList;
    }

    public List<DynamicObject> getDataCombActionActionMap(int batch_size) {
        if (this.dataCombActionActionMap == null) {
            return Collections.emptyList();
        }
        List<DynamicObject> list = this.dataCombActionActionMap.get(String.valueOf(batch_size));
        return list != null ? list : Collections.emptyList();
    }
}

