/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.build.XDataCopyBuild;
import kd.isc.iscx.platform.core.res.meta.build.XFlowNodeParam;
import kd.isc.iscx.platform.core.res.meta.build.bean.XAutoRes;
import kd.isc.iscx.platform.core.res.meta.build.bean.XEventRes;
import kd.isc.iscx.platform.core.res.meta.build.bean.XManualRes;
import kd.isc.iscx.platform.core.res.meta.build.bean.query.XDataFilter;
import kd.isc.iscx.platform.core.res.meta.build.bean.query.XDataQuery;
import kd.isc.iscx.platform.core.res.meta.build.bean.query.XFilterParams;
import kd.isc.iscx.platform.core.res.meta.build.util.CommonUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.DataFlowUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.DbLink2IscxConnectorUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ResEditorUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ResNumberUtil;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.meta.dw.ConnectorInfo;
import kd.isc.iscx.platform.core.res.meta.dw.DataFlow;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;

public class XDataTriggerBuild {
    private DynamicObject dataCopyTrigger;
    private DynamicObject dataCopy;
    private String trigger_type;
    private String events;
    private String schedule;
    private int batch_size;
    private String target_script;
    private String target_handler_class;
    private DynamicObject srcCnType;
    private DynamicObject tarCnType;
    private DynamicObject srcModule;
    private DynamicObject solutionCatalog;
    private DynamicObject input;
    private DynamicObject queryFilterParams;
    private DynamicObject eventModel;
    private List<XFlowNodeParam> buildResList = new ArrayList<XFlowNodeParam>(16);
    private int nodeId = 3;
    private DynamicObject dataFlow;
    private Map<String, DynamicObject> connectorMap = new HashMap<String, DynamicObject>(2);
    private Map<String, DynamicObject> cnTypeMap = new HashMap<String, DynamicObject>(2);
    private String pre_number;
    private XDataCopyBuild xDataCopyBuild;
    private int nodeIndex = 1;
    private List<DynamicObject> rollBackRes = new ArrayList<DynamicObject>(3);

    public XDataTriggerBuild(DynamicObject trigger, XDataCopyBuild xDataCopyBuild) {
        this.dataCopyTrigger = trigger;
        this.srcModule = xDataCopyBuild.getSrcModule();
        this.solutionCatalog = xDataCopyBuild.getSolutionCatalog();
        this.xDataCopyBuild = xDataCopyBuild;
        this.initParams();
    }

    private void addResList(DynamicObject object, String resType, String nodeType, int nodeID) {
        if (object == null) {
            return;
        }
        XFlowNodeParam param = new XFlowNodeParam(object, resType, nodeType, nodeID, this.nodeIndex++);
        this.buildResList.add(param);
    }

    private void addResList(DynamicObject object, String resType) {
        if (object == null) {
            return;
        }
        XFlowNodeParam param = new XFlowNodeParam(object, resType, null, -1, -1);
        this.buildResList.add(param);
    }

    public void build() {
        this.buildQueryRes();
        this.buildMappingRes();
        this.buildTargetRes();
        this.buildConnector();
        this.buildDataFlow();
        this.buildTrigger();
    }

    public DynamicObject getDataFlow() {
        return this.dataFlow;
    }

    public List<XFlowNodeParam> getBuildResList() {
        return new ArrayList<XFlowNodeParam>(this.buildResList);
    }

    private void buildConnector() {
        DataSource tarDataSource = this.getRealDataSource(this.dataCopyTrigger, this.dataCopy, "new_target_system", "data_target");
        DataSource srcDataSource = this.getRealDataSource(this.dataCopyTrigger, this.dataCopy, "new_source_system", "data_source");
        DynamicObject tar = ConnectionConfig.getConfig((long)tarDataSource.getDbLink());
        DynamicObject src = ConnectionConfig.getConfig((long)srcDataSource.getDbLink());
        this.srcCnType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", src.getDynamicObject("dum_link").getPkValue())});
        this.tarCnType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", tar.getDynamicObject("dum_link").getPkValue())});
        String srcKey = "src_" + this.srcCnType.getString("number");
        String tarKey = "tar_" + this.tarCnType.getString("number");
        this.cnTypeMap.put(srcKey, this.srcCnType);
        this.cnTypeMap.put(tarKey, this.tarCnType);
        DynamicObject srcConnector = DbLink2IscxConnectorUtil.getIscxConnector(srcDataSource);
        DynamicObject tarConnector = DbLink2IscxConnectorUtil.getIscxConnector(tarDataSource);
        this.connectorMap.put(srcKey, srcConnector);
        this.connectorMap.put(tarKey, tarConnector);
    }

    private List<Map<String, Object>> buildConnectorTypeList() {
        ArrayList<Map<String, Object>> connectors = new ArrayList<Map<String, Object>>(this.cnTypeMap.size());
        for (Map.Entry<String, DynamicObject> entry : this.cnTypeMap.entrySet()) {
            DynamicObject cnType = entry.getValue();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("connector_remark", "-");
            map.put("connector_number", entry.getKey());
            map.put("connector_type", cnType.getString("name"));
            map.put("connector_name", cnType.getString("name"));
            map.put("id", D.s((Object)IDService.get().genLongId()));
            connectors.add(map);
        }
        return connectors;
    }

    private void buildTrigger() {
        DynamicObject trigger = BusinessDataServiceHelper.newDynamicObject((String)"iscx_data_flow_trigger");
        trigger.set("id", (Object)IDService.get().genLongId());
        trigger.set("data_flow", (Object)this.dataFlow);
        trigger.set("event_model", (Object)this.eventModel);
        String event_type = this.getEventType();
        trigger.set("event_type", (Object)event_type);
        trigger.set("name", (Object)this.dataCopyTrigger.getString("name"));
        trigger.set("number", (Object)ResNumberUtil.buildNumber(this.pre_number));
        trigger.set("max_threads", (Object)1);
        trigger.set("work_area_size", (Object)300);
        if ("EventModel.Manual".equals(event_type) || "EventModel.Timer".equals(event_type)) {
            trigger.set("max_threads", (Object)6);
            trigger.set("work_area_size", (Object)10000);
        } else {
            trigger.set("max_threads", (Object)1);
            trigger.set("work_area_size", (Object)100);
        }
        trigger.set("log_level", (Object)"ERROR");
        trigger.set("checkpoint", (Object)30);
        trigger.set("enable", (Object)"0");
        String remark = String.format(ResManager.loadKDString((String)"\u7531\u96c6\u6210\u7ba1\u7406\u3010\u542f\u52a8\u65b9\u6848\u3011\u8f6c\u6362\u800c\u6765\u3002%1$s", (String)"XDataTriggerBuild_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.dataCopyTrigger.getString("remark"));
        trigger.set("remark", (Object)StringUtil.trim((String)remark, (int)250));
        trigger.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection params = trigger.getDynamicObjectCollection("params");
        params.clear();
        DynamicObjectCollection params_entryentity = this.dataCopyTrigger.getDynamicObjectCollection("params_entryentity");
        AbstractEventModel meta = (AbstractEventModel)ResourceUtil.getResource(this.eventModel.getLong("id"));
        StructSchema schema = meta.getParams().getDataType();
        Map<String, Object> filterParamDesc = this.getFilterParamDesc();
        block0: for (int i = 0; i < schema.fieldCount(); ++i) {
            DynamicObject row = params.addNew();
            Field field = schema.getField(i);
            row.set("param_number", (Object)field.getName());
            row.set("param_name", (Object)(field.getLabel() == null ? field.getName() : field.getLabel()));
            row.set("param_type", (Object)field.getType().toString());
            row.set("param_value", (Object)"***");
            row.set("param_desc", filterParamDesc.get(field.getName()));
            for (DynamicObject object : params_entryentity) {
                if (!field.getName().equals(object.getString("params_name"))) continue;
                row.set("param_value", (Object)CommonUtil.setDateFormat(object.getString("params_value")));
                continue block0;
            }
        }
        DynamicObjectCollection entries = trigger.getDynamicObjectCollection("connectors");
        entries.clear();
        DataFlow resource = (DataFlow)ResourceUtil.getResource(this.dataFlow.getLong("id"));
        List<ConnectorInfo> connectors = resource.getConnectors();
        for (ConnectorInfo item : connectors) {
            DynamicObject row = entries.addNew();
            row.set("connector_type", (Object)item.getType());
            row.set("connector_number", (Object)item.getNumber());
            row.set("connector_name", (Object)item.getName());
            row.set("connector_ref", (Object)this.connectorMap.get(item.getNumber()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trigger});
    }

    private String getEventType() {
        if ("event".equals(this.trigger_type)) {
            return "EventModel.BizEvent";
        }
        if ("auto".equals(this.trigger_type)) {
            return "EventModel.Timer";
        }
        if ("manual".equals(this.trigger_type)) {
            return "EventModel.Manual";
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u542f\u52a8\u65b9\u6848\u7c7b\u578b%s", (String)"XDataTriggerBuild_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.trigger_type));
    }

    private void buildDataFlow() {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(3);
        details.put("connectors", this.buildConnectorTypeList());
        Object input = this.getDataFlowParamInput();
        details.put("input", input);
        LinkedHashMap<String, Object> define = new LinkedHashMap<String, Object>(3);
        List<Map<String, Object>> nodes = this.getNodes();
        define.put("nodes", nodes);
        List<Map<String, Object>> edges = this.getEdges();
        define.put("edges", edges);
        define.put("count", nodes.size() + edges.size() + 10);
        details.put("define", define);
        String remark = String.format(ResManager.loadKDString((String)"\u7531\u6570\u636e\u96c6\u6210\u65b9\u6848\u8f6c\u6362\u751f\u6210\u3002%1$s", (String)"XDataTriggerBuild_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.dataCopy.getString("remark"));
        this.dataFlow = ResEditorUtil.createResourceDynamic("DataWeaver.DataFlow", ResNumberUtil.buildNumber(this.pre_number, this.dataCopyTrigger.getLong("id"), "DataWeaver.DataFlow"), this.dataCopyTrigger.getString("name"), StringUtil.trim((String)remark, (int)300), this.solutionCatalog, details);
    }

    private List<Map<String, Object>> getNodes() {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>(this.buildResList.size());
        for (XFlowNodeParam params : this.buildResList) {
            if (!params.isDataFlowNode()) continue;
            nodes.add(this.buildNode(params));
        }
        return nodes;
    }

    private List<Map<String, Object>> getEdges() {
        ArrayList<XFlowNodeParam> nodeList = new ArrayList<XFlowNodeParam>(this.buildResList.size());
        for (XFlowNodeParam param : this.buildResList) {
            if (!param.isDataFlowNode()) continue;
            nodeList.add(param);
        }
        ArrayList<Map<String, Object>> edges = new ArrayList<Map<String, Object>>(nodeList.size() - 1);
        int edgeID = nodeList.size() + 1;
        for (int i = 0; i < nodeList.size() - 1; ++i) {
            edges.add(this.getEdge(edgeID, (XFlowNodeParam)nodeList.get(i), (XFlowNodeParam)nodeList.get(i + 1)));
            ++edgeID;
        }
        return edges;
    }

    private Map<String, Object> getEdge(int id, XFlowNodeParam srcNode, XFlowNodeParam dstNode) {
        LinkedHashMap<String, Object> edgesMap = new LinkedHashMap<String, Object>();
        edgesMap.put("type", "Normal");
        edgesMap.put("id", id);
        edgesMap.put("src_node_id", srcNode.getNodeId());
        edgesMap.put("dst_node_id", dstNode.getNodeId());
        edgesMap.put("from", srcNode.getForm());
        edgesMap.put("to", dstNode.getTo());
        return edgesMap;
    }

    private Map<String, Object> buildNode(XFlowNodeParam params) {
        LinkedHashMap<String, Object> node = new LinkedHashMap<String, Object>();
        node.put("id", params.getNodeId());
        node.put("pos_x", params.getPos_X());
        node.put("pos_y", params.getPos_Y());
        node.put("name", params.getDataModel().get("name"));
        node.put("type", params.getNodeType());
        if (params.getResType() != null) {
            node.put("resourceType", params.getResType());
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
            details.put("resource", params.getDataModel());
            details.put("name", params.getDataModel().get("name"));
            details.put("remark", null);
            details.put("connctor_binding", this.getConnectorBinding(params));
            node.put("details", details);
        }
        return node;
    }

    private List<Map<String, Object>> getConnectorBinding(XFlowNodeParam params) {
        List<Map<String, Object>> list = DataFlowUtil.getResourceSystems(D.l((Object)params.getDataModel().get("id")));
        for (Map<String, Object> map : list) {
            if ("$src".equals(map.get("system_number"))) {
                map.put("system_connector", "src_" + this.srcCnType.getString("number"));
                continue;
            }
            if (!"$tar".equals(map.get("system_number"))) continue;
            map.put("system_connector", "tar_" + this.tarCnType.getString("number"));
        }
        return list;
    }

    private Object getDataFlowParamInput() {
        Map<String, Object> map = "event".equals(this.trigger_type) ? ResEditorUtil.toMap(this.input) : ResEditorUtil.toMap(this.queryFilterParams);
        map.put("id", D.s((Object)map.get("id")));
        return map;
    }

    private void buildQueryRes() {
        DynamicObject obj;
        DynamicObject dataQuery;
        List<Map<String, Object>> filterParamList = this.getFilterParamList();
        this.queryFilterParams = new XFilterParams(ResNumberUtil.buildNumber(this.pre_number), String.format(ResManager.loadKDString((String)"%s_\u67e5\u8be2\u6761\u4ef6\u53c2\u6570", (String)"XDataTriggerBuild_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.dataCopy.getString("name")), this.srcModule, filterParamList).build();
        this.addResList(this.queryFilterParams, "DataModel.Struct");
        if (this.queryFilterParams.getString("number").startsWith(this.pre_number)) {
            this.rollBackRes.add(this.queryFilterParams);
        }
        if ("auto".equals(this.trigger_type)) {
            dataQuery = this.createDataQuery();
            this.addResList(dataQuery, "DataExtract.DataQuery");
            this.rollBackRes.add(dataQuery);
            DynamicObject autoRes = this.createAutoRes(dataQuery);
            this.addResList(autoRes, "EventModel.Timer", "Starter", 1);
            this.rollBackRes.add(autoRes);
            this.eventModel = autoRes;
        } else if ("manual".equals(this.trigger_type)) {
            dataQuery = this.createDataQuery();
            this.addResList(dataQuery, "DataExtract.DataQuery");
            this.rollBackRes.add(dataQuery);
            DynamicObject manualRes = this.createManualRes(dataQuery);
            this.addResList(manualRes, "EventModel.Manual", "Starter", 1);
            this.rollBackRes.add(manualRes);
            this.eventModel = manualRes;
        } else if ("event".equals(this.trigger_type)) {
            DynamicObject eventRes = this.createEventRes();
            this.addResList(eventRes, "EventModel.BizEvent", "Starter", 1);
            this.eventModel = eventRes;
            if (!this.dataCopy.getDynamicObjectCollection("filter_entries").isEmpty() || !this.dataCopyTrigger.getDynamicObjectCollection("filter_entries").isEmpty()) {
                DynamicObject dynamicObject = this.createDataFilter2();
                this.addResList(dynamicObject, "DataWeaver.DataFilter", "Handler", this.nodeId++);
                this.rollBackRes.add(dynamicObject);
            }
        }
        if (this.xDataCopyBuild.getInputDataCombInit() != null) {
            DynamicObject inputDataCombInit = this.xDataCopyBuild.getInputDataCombInit();
            this.addResList(inputDataCombInit, "DataWeaver.DataCombInit", "Handler", this.nodeId++);
        }
        if (!this.xDataCopyBuild.getSrcEntryTableList().isEmpty()) {
            for (Map map : this.xDataCopyBuild.getSrcEntryTableList()) {
                obj = (DynamicObject)map.get("entriesRead");
                this.addResList(obj, "DataExtract.EntriesRead", "Handler", this.nodeId++);
            }
        }
        if (!this.xDataCopyBuild.getSrcRefTableList().isEmpty()) {
            for (Map map : this.xDataCopyBuild.getSrcRefTableList()) {
                obj = (DynamicObject)map.get("referRead");
                this.addResList(obj, "DataExtract.ReferRead", "Handler", this.nodeId++);
            }
        }
        if (this.xDataCopyBuild.getScriptRead() != null) {
            DynamicObject scriptRead = this.xDataCopyBuild.getScriptRead();
            this.addResList(scriptRead, "DataExtract.ScriptRead", "Handler", this.nodeId++);
        }
    }

    private DynamicObject createDataFilter2() {
        Map<String, Object> f7input = ResEditorUtil.toMap(this.input);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("number", ResNumberUtil.buildNumber(this.pre_number));
        map.put("name", String.format(ResManager.loadKDString((String)"%1$s_\u811a\u672c\u8fc7\u6ee4", (String)"XDataTriggerBuild_4", (String)"isc-iscx-platform-core", (Object[])new Object[0]), D.s((Object)this.dataCopy.get("name"))));
        map.put("scriptTitle", "//");
        map.put("script", ResManager.loadKDString((String)"throw \"\u8be5\u65b9\u6848\u4e8b\u4ef6\u89e6\u53d1\u5b58\u5728\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u5728\u6570\u636e\u8fc7\u6ee4\u8282\u70b9\u5199\u811a\u672c\u5b9e\u73b0\u8fc7\u6ee4\u6761\u4ef6\";", (String)"XDataTriggerBuild_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        return new XDataFilter(f7input, map, this.srcModule).build();
    }

    private DynamicObject createEventRes() {
        String number = ResNumberUtil.buildNumber(this.pre_number, this.events);
        Map<String, Object> f7input = ResEditorUtil.toMap(this.input);
        return new XEventRes(number, this.events, this.srcModule, this.dataCopy, f7input).build();
    }

    private DynamicObject createManualRes(DynamicObject dataQuery) {
        String number = ResNumberUtil.buildNumber(this.pre_number);
        String name = String.format(ResManager.loadKDString((String)"%s_\u4eba\u5de5\u542f\u52a8", (String)"XDataTriggerBuild_6", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.dataCopy.get("name"));
        return new XManualRes(number, name, this.srcModule, dataQuery).build();
    }

    private DynamicObject createAutoRes(DynamicObject dataQuery) {
        String number = ResNumberUtil.buildNumber(this.pre_number);
        String name = String.format(ResManager.loadKDString((String)"%s_\u5b9a\u65f6\u542f\u52a8", (String)"XDataTriggerBuild_7", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.dataCopy.get("name"));
        return new XAutoRes(number, name, this.schedule == null ? "0 30 2 * * ?" : this.schedule, this.srcModule, dataQuery).build();
    }

    private DynamicObject createDataQuery() {
        Map<String, Object> f7input = ResEditorUtil.toMap(this.queryFilterParams);
        Map<String, Object> f7output = ResEditorUtil.toMap(this.input);
        String number = ResNumberUtil.buildNumber(this.pre_number);
        String name = String.format(ResManager.loadKDString((String)"%s_\u6570\u636e\u67e5\u8be2", (String)"XDataTriggerBuild_8", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.dataCopy.getString("name"));
        return new XDataQuery(f7input, f7output, number, name, this.srcModule, this.dataCopy, this.dataCopyTrigger).build();
    }

    private List<Map<String, Object>> getFilterParamList() {
        DynamicObjectCollection param_entries = this.dataCopy.getDynamicObjectCollection("param_entries");
        DynamicObjectCollection params_entryentity = this.dataCopyTrigger.getDynamicObjectCollection("params_entryentity");
        param_entries.addAll((Collection)params_entryentity);
        if (param_entries.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        HashMap map = new HashMap();
        for (DynamicObject s : param_entries) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            String field = D.s((Object)s.get("params_name"));
            temp.put("field", field);
            temp.put("data_type", s.get("params_data_type"));
            temp.put("label", D.s((Object)s.get("params_label")) == null ? field : s.get("params_label"));
            temp.put("id", IDService.get().genLongId());
            map.put(field, temp);
        }
        return new ArrayList<Map<String, Object>>(map.values());
    }

    private void buildMappingRes() {
        DynamicObject iscxFieldMapping = this.xDataCopyBuild.getIscxFieldMapping();
        this.addResList(iscxFieldMapping, "DataMapping.FieldMapping", "Handler", this.nodeId++);
        if (this.xDataCopyBuild.getMapping_script() != null) {
            DynamicObject ScriptMapping2 = this.xDataCopyBuild.getScriptMapping();
            this.addResList(ScriptMapping2, "DataMapping.ScriptMapping", "Handler", this.nodeId++);
        }
    }

    private void buildTargetRes() {
        if (this.target_handler_class != null) {
            DynamicObject createScriptLoad = this.xDataCopyBuild.getScriptLoad_class();
            this.addResList(createScriptLoad, "DataLoad.ScriptLoad", "Handler", this.nodeId++);
        } else if (this.target_script != null) {
            if (this.target_script.contains("_tars")) {
                DynamicObject createScriptBatchLoad = this.xDataCopyBuild.getScriptBatchLoad(this.batch_size);
                this.addResList(createScriptBatchLoad, "DataLoad.ScriptBatchLoad", "Handler", this.nodeId++);
            } else {
                DynamicObject createScriptLoad = this.xDataCopyBuild.getScriptLoad();
                this.addResList(createScriptLoad, "DataLoad.ScriptLoad", "Handler", this.nodeId++);
            }
        } else {
            String schemaType = D.s((Object)this.xDataCopyBuild.getTarget_schema().get("type"));
            if ("ENTITY".equals(schemaType)) {
                for (DynamicObject object : this.xDataCopyBuild.getEntityActionMap(this.batch_size)) {
                    this.addResList(object, "DataLoad.EntityAction", "Handler", this.nodeId++);
                }
            } else if ("TABLE".equals(schemaType)) {
                if (this.xDataCopyBuild.getDataCombActionActionMap(this.batch_size).isEmpty()) {
                    for (DynamicObject object : this.xDataCopyBuild.getTableActionMap(this.batch_size)) {
                        this.addResList(object, "DataLoad.TableAction", "Handler", this.nodeId++);
                    }
                } else {
                    for (DynamicObject object : this.xDataCopyBuild.getDataCombActionActionMap(this.batch_size)) {
                        this.addResList(object, "DataLoad.XTableAction", "Handler", this.nodeId++);
                    }
                }
            }
        }
        this.addEndNode();
    }

    private void addEndNode() {
        LinkedHashMap<String, Object> endMap = new LinkedHashMap<String, Object>();
        endMap.put("name", ResManager.loadKDString((String)"\u7ed3\u675f", (String)"XDataTriggerBuild_9", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        XFlowNodeParam XDataFlowNode = new XFlowNodeParam(endMap, null, "End", 2, this.nodeIndex++);
        this.buildResList.add(XDataFlowNode);
    }

    private void initParams() {
        this.dataCopy = this.xDataCopyBuild.getDataCopy();
        this.pre_number = this.xDataCopyBuild.getPre_number();
        this.checkDataFlowIsExists();
        this.input = this.xDataCopyBuild.getInput();
        this.trigger_type = D.s((Object)this.dataCopyTrigger.get("trigger_type"));
        this.getEventType();
        this.events = D.s((Object)this.dataCopyTrigger.get("events"));
        this.schedule = D.s((Object)this.dataCopyTrigger.get("schedule"));
        this.target_script = D.s((Object)this.dataCopy.get("target_script_tag"));
        this.target_handler_class = D.s((Object)this.dataCopy.get("target_handler"));
        this.batch_size = D.i((Object)this.dataCopyTrigger.get("batch_size"));
        this.addResList(this.xDataCopyBuild.getInput(), this.xDataCopyBuild.getInput().getDynamicObject("type").getString("number"));
        this.addResList(this.xDataCopyBuild.getOutput(), this.xDataCopyBuild.getOutput().getDynamicObject("type").getString("number"));
    }

    private void checkDataFlowIsExists() {
        String number = ResNumberUtil.buildNumber(this.pre_number, this.dataCopyTrigger.getLong("id"), "DataWeaver.DataFlow");
        if (QueryServiceHelper.exists((String)"iscx_resource", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"DataWeaver.DataFlow").and("number", "=", (Object)number).and("catalog.id", "=", this.solutionCatalog.getPkValue())})) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u89e3\u51b3\u65b9\u6848\u76ee\u5f55\u4e0b\u5df2\u5b58\u5728\u7f16\u7801\u3010%1$s\u3011\u7684\u6570\u636e\u6d41\uff0c\u53ef\u80fd\u662f\u7531\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u542f\u52a8\u65b9\u6848\u5bfc\u5165\u800c\u6765\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"XDataTriggerBuild_10", (String)"isc-iscx-platform-core", (Object[])new Object[0]), number, this.dataCopyTrigger.getString("number")));
        }
    }

    private DataSource getRealDataSource(DynamicObject trigger, DynamicObject dataCopy, String newSystem, String dataSourceProp) {
        DynamicObject srcDataSource = trigger.getDynamicObject(newSystem);
        if (srcDataSource == null) {
            srcDataSource = dataCopy.getDynamicObject(dataSourceProp);
        }
        return DataSource.get((long)D.l((Object)srcDataSource.getPkValue()));
    }

    public List<DynamicObject> getRollBackRes() {
        return new ArrayList<DynamicObject>(this.rollBackRes);
    }

    private Map<String, Object> getFilterParamDesc() {
        DynamicObjectCollection param_entries = this.dataCopy.getDynamicObjectCollection("param_entries");
        DynamicObjectCollection params_entryentity = this.dataCopyTrigger.getDynamicObjectCollection("params_entryentity");
        param_entries.addAll((Collection)params_entryentity);
        if (param_entries.isEmpty()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>(param_entries.size());
        for (DynamicObject s : param_entries) {
            String field = D.s((Object)s.get("params_name"));
            map.put(field, StringUtil.trim((Object)s.get("params_remark"), (int)200));
        }
        return map;
    }
}

