/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.build.bean.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleConfig;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.build.util.ModelUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ResEditorUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;

public class XAutoMappingRule {
    private String number;
    private String name;
    private String srcColumn;
    private String tarColumn;
    private String default_value;
    private DynamicObject solutionCatalog;
    private DynamicObject srcCatalog;
    private DynamicObject tarCatalog;
    private DynamicObject rule;
    private Map<String, Object> input;
    private Map<String, Object> output;
    private List<Map<String, Object>> fields_mapping;

    public XAutoMappingRule(Map<String, Object> catalogMap, DynamicObject rule) {
        this.number = D.s((Object)rule.get("number"));
        this.name = D.s((Object)rule.get("name"));
        this.default_value = D.s((Object)rule.get("default_value"));
        this.srcCatalog = (DynamicObject)catalogMap.get("srcCatalog");
        this.tarCatalog = (DynamicObject)catalogMap.get("tarCatalog");
        this.solutionCatalog = (DynamicObject)catalogMap.get("solutionCatalog");
        this.rule = rule;
        this.fields_mapping = this.getFieldsMappings(rule);
        this.preBuild();
    }

    private void preBuild() {
        this.rule = ValueConversionRuleConfig.getById((Long)D.l((Object)this.rule.get("id")));
        DynamicObject dataCopySchema = DataCopySchema.get((long)this.rule.getLong("data_copy_schema_id"));
        DynamicObject schemaSrcObj = dataCopySchema.getDynamicObject("source_schema");
        DynamicObject srcObj = this.rule.getDynamicObject("source_data_schema");
        if (schemaSrcObj.getLong("id") != srcObj.getLong("id")) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728\u96c6\u6210\u7ba1\u7406\u4e2d\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u5019\u9009\u952e\u7c7b\u578b\u7684\u503c\u8f6c\u6362\u89c4\u5219\u91cc\uff0c\u6e90\u5bf9\u8c61\u548c\u6570\u636e\u96c6\u6210\u65b9\u6848\u7684\u6e90\u5bf9\u8c61\u4e0d\u4e00\u81f4\u3002", (String)"XAutoMappingRule_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.rule.getString("number")));
        }
        DynamicObject schemaTarObj = dataCopySchema.getDynamicObject("target_schema");
        DynamicObject tarObj = this.rule.getDynamicObject("target_data_schema");
        if (schemaTarObj.getLong("id") != tarObj.getLong("id")) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728\u96c6\u6210\u7ba1\u7406\u4e2d\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u5019\u9009\u952e\u7c7b\u578b\u7684\u503c\u8f6c\u6362\u89c4\u5219\u91cc\uff0c\u76ee\u6807\u5bf9\u8c61\u548c\u6570\u636e\u96c6\u6210\u65b9\u6848\u7684\u76ee\u6807\u5bf9\u8c61\u4e0d\u4e00\u81f4\u3002", (String)"XAutoMappingRule_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.rule.getString("number")));
        }
        this.input = ResEditorUtil.toMap(ModelUtil.createModel(D.l((Object)srcObj.getPkValue()), D.l((Object)this.srcCatalog.getPkValue())));
        this.output = ResEditorUtil.toMap(ModelUtil.createModel(D.l((Object)tarObj.getPkValue()), D.l((Object)this.tarCatalog.getPkValue())));
        this.srcColumn = this.getRuleStructSchema(this.input).getPrimaryKey().getName();
        String value = D.s((Object)this.rule.getString("value_attribute"));
        if (value == null) {
            value = this.getRuleStructSchema(this.output).getPrimaryKey().getName();
        }
        this.tarColumn = value;
    }

    private StructSchema getRuleStructSchema(Map<String, Object> map) {
        Object resource = ResourceUtil.getResource(D.l((Object)map.get("id")));
        return ((AbstractDataModel)resource).getDataType();
    }

    public DynamicObject build() {
        String type = "ValueConvert.AutoMappingRule";
        QFilter filter = new QFilter("number", "=", (Object)this.number).and("type", "=", (Object)type).and("catalog.id", "=", this.solutionCatalog.getPkValue());
        DynamicObject object = QueryServiceHelper.queryOne((String)"iscx_resource", (String)"id", (QFilter[])new QFilter[]{filter});
        if (object != null) {
            return BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"iscx_resource");
        }
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("input", this.input);
        details.put("output", this.output);
        details.put("src_system", ((Resource)ResourceUtil.getResource(D.l((Object)this.input.get("id")))).getScopeName());
        details.put("tar_system", ((Resource)ResourceUtil.getResource(D.l((Object)this.output.get("id")))).getScopeName());
        details.put("src_field", this.srcColumn);
        details.put("tar_field", this.tarColumn);
        details.put("default_value", this.default_value);
        details.put("fields_mapping", this.fields_mapping);
        return ResEditorUtil.createResourceDynamic("ValueConvert.AutoMappingRule", this.number, this.name, "", this.solutionCatalog, details);
    }

    private List<Map<String, Object>> getFieldsMappings(DynamicObject rule) {
        DynamicObject dataCopySchema = DataCopySchema.get((long)rule.getLong("data_copy_schema_id"));
        DynamicObjectCollection childMappingEntries = dataCopySchema.getDynamicObjectCollection("mapping_entries");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject childMappingEntry : childMappingEntries) {
            if (!childMappingEntry.getBoolean("candidate_key")) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", IDService.get().genLongId());
            map.put("tar_column", childMappingEntry.getString("mapping_tar_column"));
            map.put("tar_desc", childMappingEntry.getString("tar_desc"));
            map.put("fixed_value", childMappingEntry.getString("fixed_value"));
            map.put("src_column", childMappingEntry.getString("mapping_src_column"));
            map.put("src_desc", childMappingEntry.getString("src_desc"));
            list.add(map);
        }
        return list;
    }
}

