/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.build.bean.mapping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleConfig;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.build.bean.mapping.XAutoMappingRule;
import kd.isc.iscx.platform.core.res.meta.build.bean.mapping.XConstLookupTable;
import kd.isc.iscx.platform.core.res.meta.build.bean.mapping.XJavaRule;
import kd.isc.iscx.platform.core.res.meta.build.bean.mapping.XScriptRule;
import kd.isc.iscx.platform.core.res.meta.build.bean.mapping.XSqlRule;
import kd.isc.iscx.platform.core.res.meta.build.util.ResEditorUtil;

public class XFieldMapping {
    private String number;
    private String name;
    private String remark;
    private DynamicObject solutionCatalog;
    private Map<String, Object> catalogMap;
    private List<Map<String, Object>> mapping_entries;
    private Map<String, Object> inputMap;
    private Map<String, Object> inputDataCombMap;
    private Map<String, Object> outputMap;
    private Map<String, Object> outputDataCombMap;
    private static final String type = "DataMapping.FieldMapping";

    public XFieldMapping(String number, String name, Map<String, Object> catalog, List<Map<String, Object>> mapping_entries, Map<String, Object> inputMap, Map<String, Object> outputMap, Map<String, Object> inputDataCombMap, Map<String, Object> outputDataCombMap) {
        this.number = number;
        this.name = name;
        this.catalogMap = catalog;
        this.solutionCatalog = (DynamicObject)catalog.get("solutionCatalog");
        this.mapping_entries = mapping_entries;
        this.inputMap = inputMap;
        this.inputDataCombMap = inputDataCombMap;
        this.outputMap = outputMap;
        this.outputDataCombMap = outputDataCombMap;
        this.remark = "";
    }

    public DynamicObject build() {
        QFilter filter = new QFilter("number", "=", (Object)this.number).and("type", "=", (Object)type).and("catalog.id", "=", this.solutionCatalog.getPkValue());
        DynamicObject object = QueryServiceHelper.queryOne((String)"iscx_resource", (String)"id", (QFilter[])new QFilter[]{filter});
        if (object != null) {
            return BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"iscx_resource");
        }
        HashMap<String, Object> details = new HashMap<String, Object>();
        Map<String, Object> src_map = this.inputDataCombMap == null ? this.inputMap : this.inputDataCombMap;
        Map<String, Object> tar_map = this.outputDataCombMap == null ? this.outputMap : this.outputDataCombMap;
        details.put("input", src_map);
        details.put("src_system", ((Resource)ResourceUtil.getResource(D.l((Object)src_map.get("id")))).getScopeName());
        details.put("output", tar_map);
        details.put("tar_system", ((Resource)ResourceUtil.getResource(D.l((Object)tar_map.get("id")))).getScopeName());
        for (Map<String, Object> map : this.mapping_entries) {
            DynamicObject iscx_rule;
            DynamicObject rule;
            Object id = map.get("vc_rule");
            if (!(id instanceof Long)) continue;
            String srcColumn = D.s((Object)map.get("src_column"));
            String tarColumn = D.s((Object)map.get("tar_column"));
            if (srcColumn != null && tarColumn != null) {
                rule = ValueConversionRuleConfig.getById((Long)D.l((Object)map.get("vc_rule")));
                iscx_rule = this.createRuleType(rule, srcColumn, tarColumn);
                map.put("vc_rule", ResEditorUtil.toMap(iscx_rule));
                continue;
            }
            if (tarColumn == null || D.s((Object)map.get("fixed_value")) == null) continue;
            rule = ValueConversionRuleConfig.getById((Long)D.l((Object)map.get("vc_rule")));
            iscx_rule = this.createRuleType(rule, D.s((Object)map.get("fixed_value")), tarColumn);
            map.put("vc_rule", ResEditorUtil.toMap(iscx_rule));
        }
        details.put("mapping_entries", this.mapping_entries);
        return ResEditorUtil.createResourceDynamic(type, this.number, this.name, this.remark, this.solutionCatalog, details);
    }

    public DynamicObject createRuleType(DynamicObject rule, String srcColumn, String tarColumn) {
        String ruleType = D.s((Object)rule.get("rule_type"));
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("number", rule.getString("number"));
        map.put("name", rule.getString("name"));
        map.put("srcColumn", srcColumn);
        map.put("tarColumn", tarColumn);
        map.put("default_value", rule.getString("default_value"));
        switch (ruleType) {
            case "tlb": {
                map.put("tlb", rule.getString("tlb"));
                map.put("tlb_tag", rule.getString("tlb_tag"));
                return new XConstLookupTable(map, this.solutionCatalog, this.inputMap, this.outputMap).build();
            }
            case "auto": {
                return new XAutoMappingRule(this.catalogMap, rule).build();
            }
            case "composite": {
                map.put("script", ResManager.loadKDString((String)"//\u5f53\u524d\u672a\u652f\u6301\u7ec4\u5408\u89c4\u5219\u5feb\u901f\u8f6c\u6362", (String)"XFieldMapping_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
                map.put("script_tag", String.format(ResManager.loadKDString((String)"throw '\u8bf7\u53c2\u8003\u6570\u636e\u96c6\u6210\u7684\u7ec4\u5408\u89c4\u5219\u3010%s\u3011\uff0c\u4f7f\u7528\u811a\u672c\u5b9e\u73b0\u672c\u89c4\u5219\u6216\u624b\u5de5\u521b\u5efa\u6570\u636e\u6d41\u7684\u7ec4\u5408\u89c4\u5219\u3002';", (String)"XFieldMapping_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]), D.s((Object)rule.get("number"))));
                return new XScriptRule(map, this.solutionCatalog, this.inputMap, this.outputMap).build();
            }
            case "sql": {
                map.put("sql", rule.get("sql"));
                map.put("sql_tag", rule.get("sql_tag"));
                return new XSqlRule(map, this.solutionCatalog, this.inputMap, this.outputMap).build();
            }
            case "script": {
                map.put("script", rule.get("isc_script"));
                map.put("script_tag", rule.get("isc_script_tag"));
                return new XScriptRule(map, this.solutionCatalog, this.inputMap, this.outputMap).build();
            }
            case "java": {
                map.put("class_name", rule.get("class_name"));
                return new XJavaRule(map, this.solutionCatalog, this.inputMap, this.outputMap).build();
            }
            case "mapping": {
                map.put("script", ResManager.loadKDString((String)"//\u5f53\u524d\u672a\u652f\u6301\u4eba\u5de5\u6620\u5c04\u5feb\u901f\u8f6c\u6362", (String)"XFieldMapping_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
                map.put("script_tag", ResManager.loadKDString((String)"throw '\u4e0d\u652f\u6301\u4eba\u5de5\u6620\u5c04\uff0c\u8bf7\u6839\u636e\u5177\u4f53\u60c5\u51b5\u91cd\u65b0\u5b9e\u73b0';", (String)"XFieldMapping_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
                return new XScriptRule(map, this.solutionCatalog, this.inputMap, this.outputMap).build();
            }
        }
        map.put("script", ResManager.loadKDString((String)"//\u5f53\u524d\u7c7b\u578b\u672a\u652f\u6301\u5feb\u901f\u8f6c\u6362", (String)"XFieldMapping_4", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        map.put("script_tag", String.format(ResManager.loadKDString((String)"throw '\u4e0d\u652f\u6301\u7c7b\u578b\u4e3a%s\u7684\u8f6c\u6362\uff0c\u8bf7\u6839\u636e\u5177\u4f53\u60c5\u51b5\u91cd\u65b0\u5b9e\u73b0';", (String)"XFieldMapping_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ruleType));
        return new XScriptRule(map, this.solutionCatalog, this.inputMap, this.outputMap).build();
    }
}

