/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.build.bean.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.IDService;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.CommonUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ResEditorUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dt.Field;

public class XDataQuery {
    private Map<String, Object> inputMap;
    private Map<String, Object> outputMap;
    private String number;
    private String name;
    private DynamicObject catalog;
    private DynamicObject dataCopy;
    private DynamicObject trigger;

    public XDataQuery(Map<String, Object> inputMap, Map<String, Object> outputMap, String number, String name, DynamicObject catalog, DynamicObject dataCopy, DynamicObject trigger) {
        this.inputMap = inputMap;
        this.outputMap = outputMap;
        this.number = number;
        this.name = name;
        this.catalog = catalog;
        this.dataCopy = dataCopy;
        this.trigger = trigger;
    }

    public DynamicObject build() {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("ts_field", "id");
        details.put("input", this.inputMap);
        details.put("output", this.outputMap);
        details.put("filters", this.getDataQueryFilter(this.dataCopy, this.trigger));
        List<Map<String, Object>> result_fields = XDataQuery.getResultFields(this.outputMap, this.dataCopy);
        details.put("result_fields", result_fields);
        details.put("order_by_fields", XDataQuery.getDataQuerySort(this.dataCopy));
        if (!result_fields.isEmpty()) {
            details.put("ts_field", XDataQuery.getTsField(result_fields));
        }
        return ResEditorUtil.createResourceDynamic("DataExtract.DataQuery", this.number, this.name, "", this.catalog, details);
    }

    private static String getTsField(List<Map<String, Object>> result_fields) {
        for (Map<String, Object> map : result_fields) {
            String str = D.s((Object)map.get("field_name"));
            if (str.contains(".")) continue;
            return str;
        }
        return null;
    }

    private static List<Map<String, Object>> getDataQuerySort(DynamicObject dataCopy) {
        ArrayList<Map<String, Object>> sort = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection filter_dataCopy = dataCopy.getDynamicObjectCollection("sort_entries");
        int i = 1;
        for (DynamicObject s : filter_dataCopy) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("$seq", i++);
            temp.put("id", IDService.get().genLongId());
            temp.put("sort_field", s.get("sort_field"));
            temp.put("sort_field_label", s.get("sort_field_label"));
            temp.put("sort_mode", s.get("sort_mode"));
            sort.add(temp);
        }
        return sort;
    }

    private static List<Map<String, Object>> getResultFields(Map<String, Object> output, DynamicObject dataCopy) {
        DynamicObject srcObj = dataCopy.getDynamicObject("source_schema");
        ArrayList<String> aliasList = new ArrayList<String>();
        for (DynamicObject object : dataCopy.getDynamicObjectCollection("relation_mapping")) {
            if (D.l((Object)object.getDynamicObject("master_table").getPkValue()) != D.l((Object)srcObj.getPkValue())) continue;
            aliasList.add(D.s((Object)(object.getString("relation_alias") + ".")));
        }
        ArrayList<Map<String, Object>> result_fields = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection collection = dataCopy.getDynamicObjectCollection("mapping_entries");
        ArrayList<String> fieldList = new ArrayList<String>(collection.size());
        for (DynamicObject object : collection) {
            String field_name = D.s((Object)object.get("mapping_src_column"));
            if (field_name == null || XDataQuery.isAliasField(aliasList, field_name) || fieldList.contains(field_name)) continue;
            fieldList.add(field_name);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", IDService.get().genLongId());
            map.put("field_name", field_name);
            map.put("field_label", D.s((Object)object.get("src_desc")));
            Object resource = ResourceUtil.getResource(D.l((Object)output.get("id")));
            Field field = ((AbstractDataModel)resource).getDataType().findField(field_name);
            if (field == null) {
                map.put("data_type", "unknown");
            } else {
                map.put("data_type", D.s((Object)field.getType()));
            }
            result_fields.add(map);
        }
        return result_fields;
    }

    private static boolean isAliasField(List<String> aliasList, String field_name) {
        boolean isalias = false;
        for (String s : aliasList) {
            if (!field_name.startsWith(s)) continue;
            isalias = true;
            break;
        }
        return isalias;
    }

    private List<Map<String, Object>> getDataQueryFilter(DynamicObject dataCopy, DynamicObject trigger) {
        DynamicObjectCollection filter_dataCopy = dataCopy.getDynamicObjectCollection("filter_entries");
        List<Map<String, Object>> filter_dataCopy_entries = this.getFilterItemsFromCollection(1, filter_dataCopy);
        DynamicObjectCollection filter_trigger = trigger.getDynamicObjectCollection("filter_entries");
        List<Map<String, Object>> filter_trigger_entries = this.getFilterItemsFromCollection(filter_dataCopy_entries.size() + 1, filter_trigger);
        return this.merge(filter_dataCopy_entries, filter_trigger_entries);
    }

    private List<Map<String, Object>> merge(List<Map<String, Object>> filter1, List<Map<String, Object>> filter2) {
        if (filter1.isEmpty()) {
            return filter2;
        }
        if (filter2.isEmpty()) {
            return filter1;
        }
        this.addLeftBracket(filter1);
        this.addLeftBracket(filter2);
        this.addRightBracket(filter1);
        this.addRightBracket(filter2);
        this.setFilterLink(filter1);
        filter1.addAll(filter2);
        return filter1;
    }

    private void setFilterLink(List<Map<String, Object>> filter1) {
        Map<String, Object> item = filter1.get(filter1.size() - 1);
        item.put("filter_link", "AND");
    }

    private void addLeftBracket(List<Map<String, Object>> filter) {
        Map<String, Object> item = filter.get(0);
        String s = D.s((Object)item.get("filter_left_bracket"));
        s = s == null ? "(" : "(" + s;
        item.put("filter_left_bracket", s);
    }

    private void addRightBracket(List<Map<String, Object>> filter) {
        Map<String, Object> item = filter.get(filter.size() - 1);
        String s = D.s((Object)item.get("filter_right_bracket"));
        s = s == null ? ")" : s + ")";
        item.put("filter_right_bracket", s);
    }

    private List<Map<String, Object>> getFilterItemsFromCollection(int seq, DynamicObjectCollection filter_dataCopy) {
        ArrayList<Map<String, Object>> filter_entries = new ArrayList<Map<String, Object>>(filter_dataCopy.size());
        for (DynamicObject s : filter_dataCopy) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("$seq", seq++);
            temp.put("id", IDService.get().genLongId());
            temp.put("filter_link", s.getString("filter_link"));
            temp.put("filter_left_bracket", s.getString("filter_left_bracket"));
            temp.put("filter_right_bracket", s.getString("filter_right_bracket"));
            temp.put("filter_label", s.get("filter_label"));
            temp.put("filter_compare", s.get("filter_compare"));
            temp.put("filter_column", s.get("filter_column"));
            String var = D.s((Object)s.get("filter_value_var"));
            String tempValue = D.s((Object)s.get("filter_value_fixed"));
            tempValue = CommonUtil.setDateFormat(tempValue);
            temp.put("filter_value_fixed", var == null ? tempValue : "<%" + var + "%>");
            filter_entries.add(temp);
        }
        return filter_entries;
    }
}

