/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.build.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.k3cloud.K3CloudProxyConnectFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscx.platform.core.res.meta.build.util.CommonUtil;

public class ImportMetaToIscxResourceUtil {
    private static Map<String, Object> defaultRef = new HashMap<String, Object>();
    private static Log logger = LogFactory.getLog(ImportMetaToIscxResourceUtil.class);

    public static Map<String, Object> createViewDetailsInfo(DynamicObject meta, String full_name, String name) {
        Map<String, Object> details = ImportMetaToIscxResourceUtil.createTableDetailsInfo(meta, full_name, name);
        details.put("sql_tag", meta.getString("view_sql_tag"));
        details.put("sql", meta.getString("view_sql"));
        return details;
    }

    private static void createFields(Object group, Map<String, Object> details, DynamicObjectCollection propEntryentity, Map<String, Object> rootInfo, long parentId) {
        ArrayList<HashMap<String, Object>> fields = new ArrayList<HashMap<String, Object>>();
        HashSet<String> fields_set = new HashSet<String>();
        for (DynamicObject pItem : propEntryentity) {
            DynamicObjectCollection entries_props;
            DynamicObject entries_meta;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String data_schema = pItem.getString("data_schema");
            String data_type = pItem.getString("data_type");
            String prop_name = pItem.getString("prop_name");
            if (fields_set.contains(prop_name)) continue;
            fields_set.add(prop_name);
            if ("$FILE_LIST".equalsIgnoreCase(prop_name) || "bd_attachment".equals(data_schema) || "bos_attachment".equals(data_schema)) continue;
            ImportMetaToIscxResourceUtil.setBasic(pItem, map, parentId);
            map.put("data_type", ImportMetaToIscxResourceUtil.getEntityFieldType(data_type));
            if ("REF".equals(data_type) || "UNIT".equals(data_type) || "BILLTYPE".equals(data_type) || "LOT".equals(data_type)) {
                ImportMetaToIscxResourceUtil.setRef(group, map, data_schema, rootInfo, D.l((Object)pItem.getPkValue()));
            } else if ("ENTRIES".equals(data_type)) {
                map.put("is_multiple", Boolean.TRUE);
                entries_meta = ImportMetaToIscxResourceUtil.getMetaBySchema(data_schema, group);
                if (entries_meta == null) {
                    ImportMetaToIscxResourceUtil.showRefErrorMsg(group, data_schema);
                }
                entries_props = entries_meta.getDynamicObjectCollection("prop_entryentity");
                ImportMetaToIscxResourceUtil.createFields(group, map, entries_props, rootInfo, D.l((Object)pItem.getPkValue()));
            } else if ("ENUM".equals(data_type)) {
                ImportMetaToIscxResourceUtil.setEnum(group, map, data_schema);
            } else if (data_type.startsWith("REF?(") && data_type.endsWith(")")) {
                ArrayList<Map<String, Object>> ref_fields = new ArrayList<Map<String, Object>>();
                map.put("data_model", "basedatareftype(" + pItem.getString("prop_label") + ")");
                ImportMetaToIscxResourceUtil.createRefByVirtualInfo(rootInfo, ref_fields);
                map.put("fields", ref_fields);
            } else if ("SubHeadEntity".equals(data_type) || data_type.startsWith("unknown(") && data_type.endsWith(")")) {
                map.put("is_multiple", Boolean.FALSE);
                entries_meta = ImportMetaToIscxResourceUtil.getMetaBySchema(data_schema, group);
                if (entries_meta == null) {
                    map.put("data_type", "unknown");
                } else {
                    entries_props = entries_meta.getDynamicObjectCollection("prop_entryentity");
                    ImportMetaToIscxResourceUtil.createFields(group, map, entries_props, rootInfo, D.l((Object)pItem.getPkValue()));
                }
            }
            fields.add(map);
        }
        details.put("fields", fields);
    }

    private static void setBasic(DynamicObject pItem, Map<String, Object> map, long parentId) {
        if (0L == parentId) {
            map.put("id", pItem.getPkValue());
        } else {
            map.put("id", Math.abs(Hash.mur64((byte[])(D.s((Object)parentId) + D.s((Object)pItem.getPkValue())).getBytes(StandardCharsets.UTF_8))));
        }
        map.put("field", pItem.getString("prop_name"));
        map.put("label", pItem.getString("prop_label"));
        CommonUtil.putIfValueIsTrue(pItem.getBoolean("required"), map, "is_required");
        CommonUtil.putIfValueIsTrue(pItem.getBoolean("is_primary_key"), map, "is_primary_key");
        CommonUtil.putIfValueIsTrue(pItem.getBoolean("is_encrypt"), map, "is_private");
    }

    private static void setRef(Object group, Map<String, Object> map, String data_schema, Map<String, Object> rootInfo, long parentId) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)group).getPkValue(), (String)"isc_data_source");
        ConnectionManager.checkConnection((DynamicObject)dataSource);
        DynamicObject ref_meta = ImportMetaToIscxResourceUtil.getMetaBySchema(data_schema, group);
        ArrayList<Map<String, Object>> ref_fields = new ArrayList<Map<String, Object>>();
        if (ref_meta != null) {
            map.put("data_model", ref_meta.getString("full_name") + "(" + ref_meta.getString("name") + ")");
            DynamicObjectCollection ref_props = ref_meta.getDynamicObjectCollection("prop_entryentity");
            if (ref_props != null && ref_props.size() > 0) {
                ImportMetaToIscxResourceUtil.createRefByRealInfo(ref_props, ref_fields, parentId);
            } else {
                ImportMetaToIscxResourceUtil.createRefByVirtualInfo(rootInfo, ref_fields);
            }
        } else {
            ImportMetaToIscxResourceUtil.resetVirtualInfoForK3Cloud(data_schema, rootInfo, dataSource);
            map.put("data_model", String.format(ResManager.loadKDString((String)"%s(\u672a\u540c\u6b65)", (String)"ImportMetaToIscxResourceUtil_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]), data_schema));
            ImportMetaToIscxResourceUtil.createRefByVirtualInfo(rootInfo, ref_fields);
        }
        map.put("fields", ref_fields);
    }

    private static void resetVirtualInfoForK3Cloud(String data_schema, Map<String, Object> rootInfo, DynamicObject dataSource) {
        if (ImportMetaToIscxResourceUtil.isK3CloudConnectDblink(dataSource)) {
            rootInfo.clear();
            Object defauleProps = defaultRef.get(data_schema);
            if (defauleProps == null) {
                defauleProps = defaultRef.get("defaultRef");
            }
            if (defauleProps instanceof List) {
                List props = (List)defauleProps;
                for (Map prop : props) {
                    rootInfo.put((String)prop.get("field"), prop);
                }
            }
        }
    }

    private static void showRefErrorMsg(Object group, String data_schema) {
        StringBuilder sb = new StringBuilder();
        String s = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u96c6\u6210\u5bf9\u8c61\u7684\u5206\u5f55\u6570\u636e\u6a21\u578b\u3010%s\u3011", (String)"ImportMetaToIscxResourceUtil_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]), data_schema);
        sb.append(s);
        if (group != null) {
            String mes = String.format(ResManager.loadKDString((String)"\u5728\u6570\u636e\u6e90\u3010%s\u3011\u4e0b", (String)"ImportMetaToIscxResourceUtil_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), ((DynamicObject)group).getString("name"));
            sb.append(mes);
        }
        sb.append(ResManager.loadKDString((String)"\u672a\u540c\u6b65\uff0c\u8bf7\u91cd\u65b0\u540c\u6b65\u540e\u518d\u8fdb\u884c\u5bfc\u5165\u3002", (String)"ImportMetaToIscxResourceUtil_4", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        throw new IscBizException(sb.toString());
    }

    public static Map<String, Object> getImportUpdateParams(Object importMetadataPK, Long catalog_id) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)importMetadataPK, (String)"isc_metadata_schema");
        Object group = meta.get("group");
        String full_name = meta.getString("full_name");
        String name = meta.getString("name");
        String metaType = meta.getString("type");
        String type = "";
        Map<Object, Object> details = new HashMap();
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)catalog_id, (String)"iscx_catalog");
        if ("ENTITY".equals(metaType)) {
            type = "DataModel.Entity";
            details = ImportMetaToIscxResourceUtil.createEntityDetailsInfo(meta, group, full_name, name);
        } else if ("TABLE".equals(metaType)) {
            type = "DataModel.Table";
            full_name = meta.getString("table_name");
            details = ImportMetaToIscxResourceUtil.createTableDetailsInfo(meta, full_name, name);
        } else if ("VIEW".equals(metaType)) {
            type = "DataModel.Query";
            details = ImportMetaToIscxResourceUtil.createViewDetailsInfo(meta, full_name, name);
        }
        DynamicObject catalogParent = catalog.getDynamicObject("parent");
        QFilter filter = new QFilter("number", "=", (Object)full_name).and("type", "=", (Object)type).and("catalog.parent.id", "=", catalogParent.getPkValue());
        DynamicObject object = QueryServiceHelper.queryOne((String)"iscx_resource", (String)"id", (QFilter[])new QFilter[]{filter});
        DynamicObject iscx_resource = BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"iscx_resource");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("IsByImport_update", Boolean.TRUE);
        params.put("importMeta_details", details);
        params.put("iscx_resource_ID", iscx_resource.getLong("id"));
        return params;
    }

    private static void createRefByVirtualInfo(Map<String, Object> rootInfo, List<Map<String, Object>> ref_fields) {
        for (Map.Entry<String, Object> root : rootInfo.entrySet()) {
            HashMap<String, Long> ref_map = new HashMap<String, Long>();
            String key = root.getKey();
            Map value = (Map)root.getValue();
            ref_map.put("id", IDService.get().genLongId());
            ref_map.put("field", (Long)value.get("field"));
            ref_map.put("label", (Long)value.get("label"));
            ref_map.put("data_type", (Long)value.get("data_type"));
            ref_map.put("is_primary_key", (Long)value.get("is_primary_key"));
            ref_fields.add(ref_map);
        }
    }

    private static void createRefByRealInfo(DynamicObjectCollection ref_props, List<Map<String, Object>> ref_fields, long parentId) {
        HashSet<String> ref_fields_set = new HashSet<String>();
        for (DynamicObject ref_prop : ref_props) {
            HashMap<String, Object> ref_map = new HashMap<String, Object>();
            String prop_name = ref_prop.getString("prop_name");
            if (ref_fields_set.contains(prop_name)) continue;
            ref_fields_set.add(prop_name);
            boolean isPrimaryKey = ref_prop.getBoolean("is_primary_key");
            if (!isPrimaryKey && !"id".equals(prop_name) && !"number".equals(prop_name) && !"name".equals(prop_name) && !"FNumber".equals(prop_name) && !"FName".equals(prop_name)) continue;
            ref_map.put("id", Math.abs(Hash.mur64((byte[])(D.s((Object)parentId) + D.s((Object)ref_prop.getPkValue())).getBytes(StandardCharsets.UTF_8))));
            ref_map.put("field", prop_name);
            ref_map.put("label", ref_prop.getString("prop_label"));
            ref_map.put("data_type", ImportMetaToIscxResourceUtil.getEntityFieldType(ref_prop.getString("data_type")));
            CommonUtil.putIfValueIsTrue(isPrimaryKey, ref_map, "is_primary_key");
            ref_fields.add(ref_map);
        }
    }

    private static void setEnum(Object group, Map<String, Object> map, String data_schema) {
        DynamicObject enum_meta = ImportMetaToIscxResourceUtil.getMetaBySchema(data_schema, group);
        if (enum_meta != null) {
            DynamicObjectCollection consts_entryentity = enum_meta.getDynamicObjectCollection("consts_entryentity");
            HashMap<String, String> enumMap = new HashMap<String, String>(consts_entryentity.size());
            for (DynamicObject constEntry : consts_entryentity) {
                enumMap.put(constEntry.getString("const_value"), constEntry.getString("const_label"));
            }
            map.put("enum_values", enumMap);
        }
    }

    public static Map<String, Object> getImportModal(Object importMetadataPK, long catalog_id) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)importMetadataPK, (String)"isc_metadata_schema");
        String full_name = meta.getString("full_name");
        String metaType = meta.getString("type");
        String type = "";
        if ("ENTITY".equals(metaType)) {
            type = "DataModel.Entity";
        } else if ("TABLE".equals(metaType)) {
            full_name = meta.getString("table_name");
            type = "DataModel.Table";
        } else if ("VIEW".equals(metaType)) {
            type = "DataModel.Query";
        }
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)catalog_id, (String)"iscx_catalog");
        DynamicObject catalogParent = catalog.getDynamicObject("parent");
        QFilter filter = new QFilter("number", "=", (Object)full_name).and("type", "=", (Object)type).and("catalog.parent.id", "=", catalogParent.getPkValue());
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"iscx_resource", (String)"id", (QFilter[])new QFilter[]{filter});
        HashMap<String, Object> res = new HashMap<String, Object>(2);
        res.put("obj", object);
        if (object != null) {
            res.put("tips", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u5f53\u524d\u76ee\u5f55\u7684\u4e0a\u7ea7\u7cfb\u7edf\u201c%1$s\u201d\u4e0b\uff0c\u5df2\u5b58\u5728\u7f16\u7801\u4e3a\uff1a%2$s \u7684\u3010%3$s\u3011\u6570\u636e\u6a21\u578b\uff0c\u6b64\u64cd\u4f5c\u4f1a\u5c06\u6240\u9009\u96c6\u6210\u5bf9\u8c61\u7ed3\u6784\u8986\u76d6\u5230\u5f53\u524d\u6570\u636e\u6a21\u578b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u66f4\u65b0\u8986\u76d6\u8be5\u6761\u6570\u636e\uff1f", (String)"ImportMetaToIscxResourceUtil_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]), catalogParent.getString("name"), full_name, type));
        }
        return res;
    }

    private static DynamicObject getMetaBySchema(String dataSchema, Object group) {
        QFilter filter = new QFilter("number", "=", (Object)dataSchema).and("group_id", "=", ((DynamicObject)group).getPkValue());
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"isc_metadata_schema", (String)"id", (QFilter[])new QFilter[]{filter});
        if (object == null) {
            return null;
        }
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)"isc_metadata_schema");
        if (meta != null) {
            return meta;
        }
        return null;
    }

    public static Map<String, Object> createEntityDetailsInfo(DynamicObject meta, Object group, String full_name, String name) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("field", full_name);
        details.put("label", name);
        details.put("data_type", "REF");
        ImportMetaToIscxResourceUtil.createDetails(meta, group, details);
        return details;
    }

    public static void createDetails(DynamicObject meta, Object group, Map<String, Object> details) {
        ImportMetaToIscxResourceUtil.createFiledsDetails(meta, group, details);
        ImportMetaToIscxResourceUtil.createOpsDetails(meta, details);
        ImportMetaToIscxResourceUtil.createEventsDetails(meta, details);
    }

    public static void createEventsDetails(DynamicObject meta, Map<String, Object> details) {
        DynamicObjectCollection events_entryentity = meta.getDynamicObjectCollection("event_entryentity");
        ArrayList events = new ArrayList(events_entryentity.size());
        for (DynamicObject row : events_entryentity) {
            String event_number = D.s((Object)row.get("event_number"));
            if (event_number == null) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", row.getPkValue());
            data.put("event_number", event_number);
            data.put("event_label", D.s((Object)row.get("event_label")));
            events.add(data);
        }
        details.put("events", events);
    }

    public static void createOpsDetails(DynamicObject meta, Map<String, Object> details) {
        DynamicObjectCollection op_entryentity = meta.getDynamicObjectCollection("op_entryentity");
        ArrayList ops = new ArrayList(op_entryentity.size());
        for (DynamicObject row : op_entryentity) {
            String op_number = D.s((Object)row.get("op_number"));
            if (op_number == null) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", row.getPkValue());
            data.put("operation_number", op_number);
            data.put("operation_label", D.s((Object)row.get("op_label")));
            ops.add(data);
        }
        details.put("operations", ops);
    }

    public static void createFiledsDetails(DynamicObject meta, Object group, Map<String, Object> details) {
        DynamicObjectCollection propEntryentity = meta.getDynamicObjectCollection("prop_entryentity");
        if (propEntryentity != null && propEntryentity.size() > 0) {
            HashMap<String, Object> rootInfo = new HashMap<String, Object>();
            HashSet<String> ref_fields_set = new HashSet<String>();
            for (DynamicObject item : propEntryentity) {
                String prop_name = item.getString("prop_name");
                if (ref_fields_set.contains(prop_name)) continue;
                ref_fields_set.add(prop_name);
                boolean isPrimaryKey = item.getBoolean("is_primary_key");
                if (!"id".equalsIgnoreCase(prop_name) && !isPrimaryKey && !"number".equalsIgnoreCase(prop_name) && !"name".equalsIgnoreCase(prop_name)) continue;
                HashMap<String, Object> info = new HashMap<String, Object>(3);
                info.put("field", prop_name);
                info.put("label", item.getString("prop_label"));
                info.put("data_type", ImportMetaToIscxResourceUtil.getEntityFieldType(item.getString("data_type")));
                info.put("is_primary_key", isPrimaryKey);
                rootInfo.put(prop_name, info);
            }
            ImportMetaToIscxResourceUtil.createFields(group, details, propEntryentity, rootInfo, 0L);
        }
    }

    public static boolean isK3CloudConnectDblink(DynamicObject dataSource) {
        try (ConnectionWrapper connectionWrapper = ConnectionManager.getConnection((long)D.l((Object)dataSource.get("dblink_id")));){
            ConnectionFactory factory = connectionWrapper.getFactory();
            boolean bl = factory instanceof K3CloudProxyConnectFactory;
            return bl;
        }
    }

    public static Map<String, Object> getAddNewParams(Object importMetadataPK, Long catalog_id) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)importMetadataPK, (String)"isc_metadata_schema");
        Object group = meta.get("group");
        String full_name = meta.getString("full_name");
        String name = meta.getString("name");
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)catalog_id, (String)"iscx_catalog");
        String metaType = meta.getString("type");
        Map<Object, Object> params = new HashMap();
        if ("ENTITY".equals(metaType)) {
            Map<String, Object> details = ImportMetaToIscxResourceUtil.createEntityDetailsInfo(meta, group, full_name, name);
            ImportMetaToIscxResourceUtil.setDigestFormatForEntity(details);
            params = ImportMetaToIscxResourceUtil.getAddNewParams(meta, full_name, name, catalog, details, metaType);
        } else if ("TABLE".equals(metaType)) {
            full_name = meta.getString("table_name");
            Map<String, Object> details = ImportMetaToIscxResourceUtil.createTableDetailsInfo(meta, full_name, name);
            params = ImportMetaToIscxResourceUtil.getAddNewParams(meta, full_name, name, catalog, details, metaType);
        } else if ("VIEW".equals(metaType)) {
            Map<String, Object> details = ImportMetaToIscxResourceUtil.createViewDetailsInfo(meta, full_name, name);
            params = ImportMetaToIscxResourceUtil.getAddNewParams(meta, full_name, name, catalog, details, metaType);
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u7684\u96c6\u6210\u5bf9\u8c61\u7c7b\u578b\u5bfc\u5165,\u7c7b\u578b\uff1a\u3010%s\u3011", (String)"ImportMetaToIscxResourceUtil_6", (String)"isc-iscx-platform-core", (Object[])new Object[0]), metaType));
        }
        return params;
    }

    private static void setDigestFormatForEntity(Map<String, Object> details) {
        Object f = details.get("fields");
        if (f instanceof List) {
            List fields = (List)f;
            HashSet<String> df = new HashSet<String>();
            for (Map field : fields) {
                String prop_name = D.s(field.get("field"));
                if (!"number".equalsIgnoreCase(prop_name) && !"name".equalsIgnoreCase(prop_name) && !"billno".equalsIgnoreCase(prop_name) && !"FNumber".equalsIgnoreCase(prop_name) && !"FName".equalsIgnoreCase(prop_name) && !"FBillNo".equalsIgnoreCase(prop_name)) continue;
                df.add(prop_name);
            }
            ImportMetaToIscxResourceUtil.innerSetDigestFormat(details, df);
        }
    }

    private static void innerSetDigestFormat(Map<String, Object> details, Set<String> df) {
        if (!df.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String[] array = df.toArray(new String[0]);
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append('(');
                }
                sb.append("#{");
                sb.append(array[i]);
                sb.append('}');
                if (i <= 0) continue;
                sb.append(')');
            }
            details.put("digest_format", sb.toString());
        }
    }

    public static Map<String, Object> getAddNewParams(DynamicObject meta, String number, String name, DynamicObject catalog, Map<String, Object> details, String metaType) {
        String remark = D.s((Object)meta.get("remark"));
        if (remark == null && "ENTITY".equals(meta.getString("type"))) {
            String tableName = D.s((Object)meta.get("table_name"));
            remark = String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\uff1a%s", (String)"ImportMetaToIscxResourceUtil_7", (String)"isc-iscx-platform-core", (Object[])new Object[0]), tableName != null ? tableName : ResManager.loadKDString((String)"\u672a\u540c\u6b65", (String)"ImportMetaToIscxResourceUtil_8", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> info = new HashMap<String, String>(4);
        info.put("number", number);
        info.put("name", name + "\uff08" + catalog.getString("parent.name") + "\uff09");
        info.put("remark", remark);
        params.put("IsByImport_addNew", Boolean.TRUE);
        params.put("Model_Type", metaType);
        params.put("catalog", catalog.getPkValue());
        params.put("meta_Info", info);
        params.put("importMeta_details", details);
        return params;
    }

    public static Map<String, Object> createTableDetailsInfo(DynamicObject meta, String full_name, String name) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("field", full_name);
        details.put("label", name);
        details.put("data_type", "STRUCT");
        HashSet<String> fields_set = new HashSet<String>();
        DynamicObjectCollection propEntryentity = meta.getDynamicObjectCollection("prop_entryentity");
        ArrayList<HashMap<String, Object>> fields = new ArrayList<HashMap<String, Object>>();
        for (DynamicObject pItem : propEntryentity) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", pItem.getPkValue());
            String prop_name = pItem.getString("prop_name");
            if (fields_set.contains(prop_name)) continue;
            fields_set.add(prop_name);
            map.put("field", prop_name);
            map.put("label", pItem.getString("prop_label"));
            map.put("data_type", ImportMetaToIscxResourceUtil.getTableFieldType(pItem.getString("data_type")));
            CommonUtil.putIfValueIsTrue(pItem.getBoolean("required"), map, "is_required");
            CommonUtil.putIfValueIsTrue(pItem.getBoolean("is_primary_key"), map, "is_primary_key");
            CommonUtil.putIfValueIsTrue(pItem.getBoolean("is_encrypt"), map, "is_private");
            fields.add(map);
        }
        details.put("fields", fields);
        return details;
    }

    public static String getEntityFieldType(String m_type) {
        if (m_type.startsWith("REF?(") && m_type.endsWith(")") || "MultiREF".equals(m_type)) {
            return "REF(?)";
        }
        if ("SubHeadEntity".equals(m_type) || m_type.startsWith("unknown(") && m_type.endsWith(")")) {
            return "STRUCT";
        }
        if (m_type.startsWith("varchar")) {
            return "string";
        }
        if (m_type.startsWith("decimal")) {
            return "decimal";
        }
        switch (m_type) {
            case "string": 
            case "boid": {
                return "string";
            }
            case "int": 
            case "integer": {
                return "integer";
            }
            case "datetime": 
            case "timestamp": 
            case "date": {
                return "datetime";
            }
            case "boolean": {
                return "boolean";
            }
            case "BigDecimal": {
                return "decimal";
            }
            case "long": 
            case "bigint": {
                return "long";
            }
            case "ml_string": 
            case "ml_string_k3c": {
                return "ml_string";
            }
            case "double": 
            case "float": {
                return "double";
            }
            case "ENUM": {
                return "ENUM";
            }
            case "REF": 
            case "UNIT": 
            case "BILLTYPE": 
            case "LOT": {
                return "REF";
            }
            case "ENTRIES": {
                return "ENTRIES";
            }
            case "STRUCT": {
                return "STRUCT";
            }
        }
        return "unknown";
    }

    public static String getTableFieldType(String m_type) {
        String s = D.s((Object)m_type);
        if (s == null) {
            return "";
        }
        String lc_Type = s.toLowerCase(Locale.ENGLISH);
        if (lc_Type.startsWith("varchar") || lc_Type.startsWith("nvarchar") || lc_Type.equals("nclob") || lc_Type.equals("clob")) {
            return "varchar";
        }
        if (lc_Type.equals("int")) {
            return "int";
        }
        if (lc_Type.equals("bigint")) {
            return "bigint";
        }
        if (lc_Type.equals("datetime")) {
            return "datetime";
        }
        if (lc_Type.startsWith("decimal")) {
            return "decimal";
        }
        if (lc_Type.equals("date")) {
            return "date";
        }
        if (lc_Type.equals("time")) {
            return "time";
        }
        if (lc_Type.equals("bit")) {
            return "bit";
        }
        if (lc_Type.startsWith("varbinary")) {
            return "varbinary";
        }
        if (lc_Type.startsWith("float")) {
            return "float";
        }
        return "";
    }

    static {
        try (InputStream in = ImportMetaToIscxResourceUtil.class.getResourceAsStream("/importMeta/defaultRef.json");){
            String jsonStr = NetUtil.readText((InputStream)in);
            defaultRef = (Map)Script.parseJson((String)jsonStr);
        }
        catch (IOException e) {
            logger.warn("\u9ed8\u8ba4\u5bfc\u5165\u5c5e\u6027Json\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (Throwable)e);
        }
    }
}

