/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.build.util;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscx.platform.core.res.ResourceUtil;

public class ResEditorUtil {
    public static long createResource(String type, String number, String name, String remark, DynamicObject catalog, Map<String, Object> details) {
        DynamicObject res = ResEditorUtil.createResourceDynamic(type, number, ResEditorUtil.toMap(name), remark, catalog, details);
        return res.getLong("id");
    }

    public static Map<String, String> toMap(String name) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("GLang", name);
        map.put(Lang.get().name(), name);
        return map;
    }

    public static long createResource(String type, String number, Map<String, String> name, String remark, DynamicObject catalog, Map<String, Object> details) {
        DynamicObject res = ResEditorUtil.createResourceDynamic(type, number, name, remark, catalog, details);
        return res.getLong("id");
    }

    public static long createResourceWithParam(String type, String number, Map<String, String> name, String remark, DynamicObject catalog, Map<String, Object> details, Map<String, Object> params) {
        DynamicObject res = ResEditorUtil.createRes(type, number, name, remark, catalog, details, params);
        return res.getLong("id");
    }

    public static DynamicObject createResourceDynamic(String type, String number, String name, String remark, DynamicObject catalog, Map<String, Object> details) {
        return ResEditorUtil.createRes(type, number, ResEditorUtil.toMap(name), remark, catalog, details, Collections.emptyMap());
    }

    public static DynamicObject createResourceDynamic(String type, String number, Map<String, String> name, String remark, DynamicObject catalog, Map<String, Object> details) {
        return ResEditorUtil.createRes(type, number, name, remark, catalog, details, Collections.emptyMap());
    }

    private static DynamicObject createRes(String type, String number, Map<String, String> name, String remark, DynamicObject catalog, Map<String, Object> details, Map<String, Object> params) {
        DynamicObject scope = ResEditorUtil.getScope(catalog);
        ResEditorUtil.uniqueCheck(type, number, scope);
        DynamicObject res = BusinessDataServiceHelper.newDynamicObject((String)"iscx_resource");
        res.set("id", (Object)IDService.get().genLongId());
        res.set("type", (Object)BusinessDataServiceHelper.loadSingle((Object)type, (String)"iscx_resource_type"));
        res.set("number", (Object)number);
        res.set("name", name);
        res.set("remark", (Object)remark);
        res.set("catalog", (Object)catalog);
        res.set("scope", (Object)scope);
        res.set("input_data_model", ResEditorUtil.getInputModel(details));
        res.set("output_data_model", ResEditorUtil.getOutputModel(details));
        res.set("details_tag", (Object)Json.toString(details));
        res.set("version", (Object)1);
        res.set("is_extended", (Object)Boolean.FALSE);
        res.set("is_valid", (Object)ResEditorUtil.isValid(details));
        RequestContext ctx = RequestContext.get();
        res.set("dev_tenant", (Object)ctx.getTenantId());
        res.set("creator_id", (Object)ctx.getCurrUserId());
        ResEditorUtil.setResourceDepends(res, details);
        ResEditorUtil.setResByParams(params, res);
        ConnectorUtil.save((DynamicObject)res);
        return res;
    }

    private static void setResByParams(Map<String, Object> params, DynamicObject res) {
        if (D.l((Object)params.get("customResId")) != 0L) {
            res.set("id", (Object)D.l((Object)params.get("customResId")));
        }
        if (D.s((Object)params.get("source_app")) != null) {
            res.set("source_app", (Object)D.s((Object)params.get("source_app")));
        }
    }

    private static void setResourceDepends(DynamicObject res, Map<String, Object> details) {
        DynamicObjectCollection c = res.getDynamicObjectCollection("res_depends");
        c.clear();
        for (DynamicObject d : ResourceUtil.getDepends(details)) {
            DynamicObject obj = new DynamicObject(c.getDynamicObjectType());
            obj.set("fbasedataid", (Object)d);
            c.add((Object)obj);
        }
    }

    private static boolean isValid(Map<String, Object> details) {
        return details != null && !details.isEmpty();
    }

    public static void setInputAndOutputFromDataProvider(Map<String, Object> details, DynamicObject data_provider) {
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)data_provider.get("id"), (String)"iscx_resource", (String)"input_data_model,output_data_model");
        details.put("input_data_model", res.get("input_data_model"));
        details.put("output_data_model", res.get("output_data_model"));
    }

    public static void setInputAndOutputFromDataProvider(Map<String, Object> details, long data_provider) {
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)data_provider, (String)"iscx_resource", (String)"input_data_model,output_data_model");
        details.put("input_data_model", res.get("input_data_model"));
        details.put("output_data_model", res.get("output_data_model"));
    }

    private static DynamicObject getScope(DynamicObject catalog) {
        String catalogType = D.s((Object)catalog.get("type"));
        if ("Module".equals(catalogType)) {
            return catalog.getDynamicObject("parent");
        }
        if ("Solution".equals(catalogType)) {
            return catalog;
        }
        if ("Common".equals(catalogType)) {
            return catalog;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u76ee\u5f55\uff08%1$s\uff09\u7684\u7c7b\u522b\u662f\u201c%2$s\u201d\uff0c\u5176\u4e0b\u4e0d\u53ef\u6dfb\u52a0\u8d44\u6e90\u3002", (String)"ResEditorUtil_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]), catalog.get("name"), catalogType));
    }

    private static Object getOutputModel(Map<String, Object> details) {
        Object id = details.get("output_data_model");
        if (id != null) {
            return D.l((Object)id);
        }
        id = ResourceUtil.getValue(details, "output", "id");
        if (id != null) {
            return D.l((Object)id);
        }
        id = ResourceUtil.getValue(details, "data_model", "id");
        if (id != null) {
            return D.l((Object)id);
        }
        return 0L;
    }

    private static Object getInputModel(Map<String, Object> details) {
        Object id = details.get("input_data_model");
        if (id != null) {
            return D.l((Object)id);
        }
        id = ResourceUtil.getValue(details, "input", "id");
        if (id != null) {
            return D.l((Object)id);
        }
        id = ResourceUtil.getValue(details, "data_model", "id");
        if (id != null) {
            return D.l((Object)id);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uniqueCheck(String type, String number, DynamicObject scope) {
        if (scope == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u201c%s\u201d\u6240\u5c5e\u7684\u4e0a\u7ea7\u5206\u7c7b\u88ab\u610f\u5916\u5220\u9664\u4e86\u3002", (String)"ResEditorUtil_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]), number));
        }
        String sql = "SELECT 1 FROM t_iscx_res_main WHERE fscope=? AND fnumber=? AND ftype=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List params = D.asList((Object[])new Object[]{scope.getLong("id"), number, type});
            List types = D.asList((Object[])new Integer[]{-5, 12, 12});
            if (D.x((Object)DbUtil.executeScalar((Connection)cn, (String)sql, (List)params, (List)types))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5728\u201c%1$s\u201d\u5185\u5df2\u5b58\u5728\u7f16\u7801\u4e3a\uff08%2$s\uff09\u7684\u540c\u7c7b\u8d44\u6e90\u3002", (String)"ResEditorUtil_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), scope.get("name"), number));
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uniqueCheck(String type, String number, long excludeId, DynamicObject scope) {
        if (scope == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u201c%s\u201d\u6240\u5c5e\u7684\u4e0a\u7ea7\u5206\u7c7b\u88ab\u610f\u5916\u5220\u9664\u4e86\u3002", (String)"ResEditorUtil_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]), number));
        }
        String sql = "SELECT 1 FROM t_iscx_res_main WHERE fscope=? AND fnumber=? AND ftype=? AND fid != ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List params = D.asList((Object[])new Object[]{scope.getLong("id"), number, type, excludeId});
            List types = D.asList((Object[])new Integer[]{-5, 12, 12, -5});
            if (D.x((Object)DbUtil.executeScalar((Connection)cn, (String)sql, (List)params, (List)types))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5728\u201c%1$s\u201d\u5185\u5df2\u5b58\u5728\u7f16\u7801\u4e3a\uff08%2$s\uff09\u7684\u540c\u7c7b\u8d44\u6e90\u3002", (String)"ResEditorUtil_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]), scope.get("name"), number));
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    public static Map<String, Object> toMap(DynamicObject f7) {
        if (f7 == null) {
            return null;
        }
        String entity = f7.getDataEntityType().getName();
        if ("iscx_resource".equals(entity)) {
            HashMap<String, Object> ref = new HashMap<String, Object>(8);
            ref.put("$ref", Boolean.TRUE);
            ref.put("type", entity);
            ref.put("id", f7.get("id"));
            ref.put("number", f7.get("number"));
            ref.put("name", f7.getString("name"));
            return ref;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5f15\u7528\u57fa\u7840\u8d44\u6599\u7c7b\u578b\uff08%s\uff09\u3002", (String)"ResEditorUtil_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]), entity));
    }

    public static void updateResource(DynamicObject res, String number, Map<String, String> name, String remark, DynamicObject catalog, Map<String, Object> details) {
        DynamicObject scope = ResEditorUtil.getScope(catalog);
        ResEditorUtil.uniqueCheck(res.getString("type.number"), number, D.l((Object)res.getPkValue()), scope);
        res.set("number", (Object)number);
        res.set("name", name);
        res.set("remark", (Object)remark);
        res.set("catalog", (Object)catalog);
        res.set("scope", (Object)scope);
        res.set("details_tag", (Object)Json.toString(details));
        res.set("is_valid", (Object)ResEditorUtil.isValid(details));
        res.set("version", (Object)(D.i((Object)res.get("version")) + 1));
        res.set("input_data_model", ResEditorUtil.getInputModel(details));
        res.set("output_data_model", ResEditorUtil.getOutputModel(details));
        ResEditorUtil.setResourceDepends(res, details);
        ConnectorUtil.save((DynamicObject)res);
    }

    public static void extendsResource(DynamicObject ext, Map<String, Object> details, Map<String, Object> originalDetails) {
        Map<String, Object> extDetails = ResourceUtil.calcDiff(details, originalDetails);
        ext.set("extensions_tag", (Object)Json.toString(extDetails));
        RequestContext ctx = RequestContext.get();
        ext.set("ext_tenant", (Object)ctx.getTenantId());
        ext.set("is_extended", (Object)Boolean.TRUE);
        ResEditorUtil.setResourceDepends(ext, details);
        ConnectorUtil.save((DynamicObject)ext);
    }
}

