/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dm;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.encoding.Encoding;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.SystemInfo;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;

public abstract class AbstractDataModel
extends Resource {
    private StructSchema dataType;
    private String varName;
    private Format digest_format;

    protected AbstractDataModel(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        this.dataType = new StructSchema(details);
        this.varName = Encoding.pesudoBase64((long)id);
        this.digest_format = this.getDigestFormat(details);
    }

    protected AbstractDataModel(long id, String number, String name, ResourceType resourceType, Map<String, Object> details, StructSchema dataType) {
        super(id, number, name, resourceType, details);
        this.dataType = dataType;
        this.varName = Encoding.pesudoBase64((long)id);
        this.digest_format = this.getDigestFormat(details);
    }

    private Format getDigestFormat(Map<String, Object> details) {
        String digest_format = D.s((Object)details.get("digest_format"));
        if (digest_format == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.dataType.fieldCount(); ++i) {
                Field f = this.dataType.getField(i);
                if (!f.isPrimaryKey()) continue;
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append("#{").append(f.getName()).append('}');
            }
            digest_format = sb.length() == 0 ? ResManager.loadKDString((String)"\u65e0", (String)"AbstractDataModel_0", (String)"isc-iscx-platform-core", (Object[])new Object[0]) : sb.toString();
        }
        return Format.parse((String)digest_format, new HashMap());
    }

    public final String digest(Map<String, Object> data) {
        try {
            String s = D.s((Object)this.digest_format.translate(data));
            return s == null ? ResManager.loadKDString((String)"{\u65e0}", (String)"AbstractDataModel_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]) : s;
        }
        catch (Throwable e) {
            return StringUtil.getCascadeMessage((Throwable)e);
        }
    }

    public final String getDigestFormat() {
        return this.digest_format.getFormat();
    }

    public final String getVariableName() {
        return this.varName;
    }

    public final StructSchema getDataType() {
        return this.dataType;
    }

    public final SystemInfo getSystemInfo() {
        return new SystemInfo("$src", this.getScopeName(), ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf", (String)"AbstractDataModel_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
    }
}

