/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;

public class DataComb
extends AbstractDataModel {
    private AbstractDataModel mainModel;
    private Map<String, AbstractDataModel> entryModels;
    private Map<String, AbstractDataModel> refModels;

    private DataComb(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details, DataComb.buildSchema(details));
        this.mainModel = DataComb.getMainModel(details);
        this.initRelationModels(details);
    }

    private void initRelationModels(Map<String, Object> details) {
        LinkedHashMap<String, AbstractDataModel> entryModels = new LinkedHashMap<String, AbstractDataModel>(4);
        LinkedHashMap<String, AbstractDataModel> refModels = new LinkedHashMap<String, AbstractDataModel>(4);
        for (Map item : (List)details.get("relations")) {
            Long entry_model_id = D.l(ResourceUtil.getValue(item, "relation_model", "id"));
            AbstractDataModel r = (AbstractDataModel)ResourceUtil.getResource(entry_model_id);
            String name = D.s(item.get("field_alias"));
            boolean isArray = D.x(item.get("is_array"));
            if (isArray) {
                entryModels.put(name, r);
                continue;
            }
            refModels.put(name, r);
        }
        this.entryModels = entryModels.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(entryModels);
        this.refModels = refModels.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(refModels);
    }

    private static StructSchema buildSchema(Map<String, Object> details) {
        AbstractDataModel main = DataComb.getMainModel(details);
        ArrayList<Field> fields = new ArrayList<Field>(main.getDataType().getFields());
        for (Map item : (List)details.get("relations")) {
            Long entry_model_id = D.l(ResourceUtil.getValue(item, "relation_model", "id"));
            AbstractDataModel r = (AbstractDataModel)ResourceUtil.getResource(entry_model_id);
            String name = D.s(item.get("field_alias"));
            boolean isArray = D.x(item.get("is_array"));
            StructSchema type = isArray ? DataTypes.listType((DataType)r.getDataType()) : r.getDataType();
            fields.add(new Field(name, r.getName(), type));
        }
        return new StructSchema(fields);
    }

    private static AbstractDataModel getMainModel(Map<String, Object> details) {
        Long data_model_id = D.l(ResourceUtil.getValue(details, "data_model", "id"));
        AbstractDataModel main = (AbstractDataModel)ResourceUtil.getResource(data_model_id);
        return main;
    }

    public AbstractDataModel getMainModel() {
        return this.mainModel;
    }

    public Map<String, AbstractDataModel> getRefModels() {
        return this.refModels;
    }

    public Map<String, AbstractDataModel> getEntryModels() {
        return this.entryModels;
    }

    public static class DataCombParser
    extends ResourceType {
        public DataCombParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new DataComb(id, number, name, (ResourceType)this, (Map)details);
        }

        @Override
        public boolean isExtensible() {
            return true;
        }
    }
}

