/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.db.GeneralSchema;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dm.DataEntity;
import kd.isc.iscx.platform.core.res.meta.dm.DataTable;
import kd.isc.iscx.platform.core.res.meta.dm.DataView;
import kd.isc.iscx.platform.core.res.meta.dp.AbstractDataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.DatabaseQuery;
import kd.isc.iscx.platform.core.res.meta.dp.EntityQuery;
import kd.isc.iscx.platform.core.res.meta.dp.QueryUtil;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;

public class DataQuery
extends AbstractDataQuery {
    private Map<String, Object> requires;
    private List<Pair<String, String>> orderBy;
    private List<Map<String, Object>> filters;
    private Map<Long, Schema> jdbcSchemaCache = new HashMap<Long, Schema>();

    private DataQuery(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        this.requires = QueryUtil.createRequiredFieldsMap(this.getOutput(), (List)details.get("result_fields"));
        this.createOrderBy((List)details.get("order_by_fields"));
        this.filters = QueryUtil.createFilters((List)details.get("filters"));
    }

    public DataQuery(long id, String number, String name, AbstractDataModel input, AbstractDataModel output, Map<String, Object> requires, List<Map<String, Object>> filters) {
        super(id, number, name, ResourceType.get("DataExtract.DataQuery"), input, output);
        this.requires = requires;
        this.filters = filters;
        this.orderBy = Collections.emptyList();
    }

    private void createOrderBy(List<Map<String, Object>> list) {
        if (list == null || list.isEmpty()) {
            this.orderBy = Collections.emptyList();
        } else {
            this.orderBy = new ArrayList<Pair<String, String>>(list.size());
            ArrayList<Pair<String, String>> orderBy = this.orderBy;
            for (Map<String, Object> i : list) {
                orderBy.add((Pair<String, String>)new Pair((Object)D.s((Object)i.get("sort_field")), (Object)D.s((Object)i.get("sort_mode"))));
            }
        }
    }

    List<Map<String, Object>> getFilters() {
        return this.filters;
    }

    List<Pair<String, String>> getOrderBy() {
        return this.orderBy;
    }

    Map<String, Object> getRequired() {
        return this.requires;
    }

    @Override
    public ObjectReader<? extends Map<String, Object>> invoke(DataStream stream, ConnectionWrapper src, Map<String, Object> params, int bufferSize) {
        return this.invoke(src, params, bufferSize);
    }

    public ObjectReader<? extends Map<String, Object>> invoke(ConnectionWrapper src, Map<String, Object> params, int bufferSize) {
        AbstractDataModel model = this.getOutput();
        if (model instanceof DataTable) {
            return DatabaseQuery.invoke(src, this, this.getSchema(src, (DataTable)model), params, bufferSize);
        }
        if (model instanceof DataEntity) {
            return EntityQuery.invoke(src, this, model.getNumber(), params);
        }
        if (model instanceof DataView) {
            return DatabaseQuery.invoke(src, this, this.getSchema(src, (DataView)model), params, bufferSize);
        }
        throw new UnsupportedOperationException("TODO - " + model);
    }

    private synchronized Schema getSchema(ConnectionWrapper src, DataTable model) {
        Long id = src.getConfig().getLong("id");
        Schema schema = this.jdbcSchemaCache.get(id);
        if (schema == null) {
            schema = src.getTable(model.getTableName());
            this.jdbcSchemaCache.put(id, schema);
        }
        return schema;
    }

    private synchronized Schema getSchema(ConnectionWrapper src, DataView model) {
        Long id = src.getConfig().getLong("id");
        Schema schema = this.jdbcSchemaCache.get(id);
        if (schema == null) {
            schema = DataQuery.newViewSchema(src, model);
            this.jdbcSchemaCache.put(id, schema);
        }
        return schema;
    }

    private static Schema newViewSchema(ConnectionWrapper src, DataView model) {
        StructSchema ss = model.getDataType();
        ArrayList<Column> fields = new ArrayList<Column>();
        String pk = null;
        for (int i = 0; i < ss.fieldCount(); ++i) {
            Field f = ss.getField(i);
            String name = f.getName();
            if (f.isPrimaryKey()) {
                pk = pk == null ? name : "";
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("COLUMN_NAME", name);
            data.put("IS_NULLABLE", !f.isRequired());
            String data_type = f.getTypeDef();
            int index = data_type.indexOf(40);
            if (index > 0) {
                data_type = data_type.substring(0, index);
            }
            data.put("DATA_TYPE", DataTypeUtil.getSqlType((String)data_type));
            data.put("COLUMN_SIZE", -1);
            data.put("DECIMAL_DIGITS", -1);
            data.put("TYPE_NAME", data_type);
            fields.add(new Column(data, fields.size(), src.getQuot()));
        }
        return new GeneralSchema(fields, pk, model.getViewName());
    }

    public static class DataQueryParser
    extends ResourceType {
        public DataQueryParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new DataQuery(id, number, name, (ResourceType)this, details);
        }

        @Override
        public boolean isExtensible() {
            return true;
        }
    }
}

