/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dp.AbstractDataReader;
import kd.isc.iscx.platform.core.res.meta.dp.DataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.QueryUtil;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompareUtil;
import kd.isc.iscx.platform.core.res.runtime.BatchSupportable;

public class DataReader
extends AbstractDataReader
implements BatchSupportable {
    private Map<String, Object> requires;
    private List<Map<String, Object>> filters;
    private List<String> judgeFields;
    private int batch_size;

    private DataReader(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        this.requires = QueryUtil.createRequiredFieldsMap(this.getOutput(), (List)details.get("result_fields"));
        this.filters = QueryUtil.createFilters((List)details.get("filters"));
        this.filters.get(this.filters.size() - 1).put("filter_link", "OR");
        this.judgeFields = this.createJudgeFields(this.filters);
        this.batch_size = D.i((Object)details.get("batch_size"));
    }

    private List<String> createJudgeFields(List<Map<String, Object>> filters) {
        ArrayList<String> judgeFields = new ArrayList<String>(filters.size());
        for (Map<String, Object> filter : filters) {
            judgeFields.add((String)filter.get("filter_column"));
        }
        return judgeFields;
    }

    List<Map<String, Object>> getFilters() {
        return this.filters;
    }

    Map<String, Object> getRequired() {
        return this.requires;
    }

    public List<String> getJudgeFields() {
        return this.judgeFields;
    }

    @Override
    public void doRead(Execution e, ConnectionWrapper $src, Map<String, Object> params, Map<String, Object> data) {
        String filterKey;
        List<Map<String, Object>> filters = DataCompareUtil.prepareFilters(this.getOutput(), this.filters, params);
        DataQuery query = new DataQuery(this.getId(), this.getNumber(), this.getName(), this.getInput(), this.getOutput(), this.requires, filters);
        List<Map<String, Object>> list = DataCompareUtil.queryList($src, query, 1, this.judgeFields);
        if (list.isEmpty()) {
            DataReader.setIgnoredAsNotExists(data);
            return;
        }
        Map<String, Object> output = list.get(0);
        String outputKey = DataCompareUtil.getKey(output, this.judgeFields);
        if (outputKey.equals(filterKey = DataCompareUtil.getKey(filters))) {
            data.putAll(output);
        } else {
            data.put("#_IGNORE_TAG", Boolean.TRUE);
            data.put("#_IGNORE_REASON", "JUDGE_FIELDS_NOT_MATCHED");
            data.put("#FILTER_KEY", filterKey);
            data.put("#REAL_KEY", outputKey);
        }
    }

    static void setIgnoredAsNotExists(Map<String, Object> data) {
        data.put("#_IGNORE_TAG", Boolean.TRUE);
        data.put("#_IGNORE_REASON", "NOT_EXISTS");
    }

    public int getBatchSize() {
        return this.batch_size;
    }

    @Override
    public boolean isBatchMode() {
        return this.batch_size > 1;
    }

    public static class DataReaderParser
    extends ResourceType {
        public DataReaderParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new DataReader(id, number, name, this, details);
        }

        @Override
        public boolean isExtensible() {
            return true;
        }
    }
}

