/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dp;

import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.debugger.DebuggerAction;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.ProcessElement;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscx.platform.core.res.meta.dp.AbstractDataReader;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataFlowException;
import kd.isc.iscx.platform.core.res.runtime.job.Util;

public final class DataReaderApplication
implements Application,
DebuggerAction {
    private final Connector connector;
    private final AbstractDataReader reader;

    public DataReaderApplication(Connector connector, AbstractDataReader reader) {
        this.connector = connector;
        this.reader = reader;
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        Map<String, Object> params = Util.getInputData(e, this.reader);
        Map<String, Object> output = Util.getOutputData(e, this.reader);
        try (ConnectionWrapper $src = this.connector.getConnection();){
            this.reader.doRead(e, $src, params, output);
        }
        catch (Exception err) {
            if (err instanceof DataFlowException) {
                throw err;
            }
            ProcessElement node = e.getDefine();
            throw new DataFlowException(node.getId(), node.getTitle(), this.reader.getInput(), params, (Throwable)err);
        }
    }

    public void onAttachBreakpoint() {
        if (this.reader instanceof DebuggerAction) {
            ((DebuggerAction)this.reader).onAttachBreakpoint();
        }
    }

    public void onDetachBreakpoint() {
        if (this.reader instanceof DebuggerAction) {
            ((DebuggerAction)this.reader).onDetachBreakpoint();
        }
    }
}

