/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscx.platform.core.res.meta.dp.DataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.DataReader;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompareUtil;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;

public class DataReaderXApplication
extends AbstractBatchApplication {
    private DataReader reader;
    private Connector $src;

    protected DataReaderXApplication(DataReader res, Connector $src) {
        super(res, res.getBatchSize());
        this.reader = res;
        this.$src = $src;
    }

    @Override
    public void doBatch(DataStream stream, List<AbstractBatchApplication.Data> batch) {
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>(this.reader.getFilters().size() * batch.size());
        ArrayList<String> filterKeys = new ArrayList<String>(batch.size());
        this.prepareFilters(batch, filters, filterKeys);
        List<Map<String, Object>> list = this.doQuery(batch, filters);
        Map<String, Map<String, Object>> outputMap = DataCompareUtil.groupBy(list, this.reader.getJudgeFields());
        this.writeOutput(batch, filterKeys, outputMap);
    }

    private void writeOutput(List<AbstractBatchApplication.Data> batch, List<String> filterKeys, Map<String, Map<String, Object>> outputMap) {
        for (int i = 0; i < batch.size(); ++i) {
            Map<String, Object> output = outputMap.get(filterKeys.get(i));
            if (output == null) {
                DataReader.setIgnoredAsNotExists(batch.get(i).getOutput());
                continue;
            }
            batch.get(i).getOutput().putAll(output);
        }
    }

    private List<Map<String, Object>> doQuery(List<AbstractBatchApplication.Data> batch, List<Map<String, Object>> filters) {
        DataQuery query = new DataQuery(this.reader.getId(), this.reader.getNumber(), this.reader.getName(), this.reader.getOutput(), this.reader.getOutput(), this.reader.getRequired(), filters);
        try (ConnectionWrapper tar = this.$src.getConnection();){
            List<Map<String, Object>> list = DataCompareUtil.queryList(tar, query, batch.size(), this.reader.getJudgeFields());
            return list;
        }
    }

    private void prepareFilters(List<AbstractBatchApplication.Data> batch, List<Map<String, Object>> filters, List<String> filterKeys) {
        for (AbstractBatchApplication.Data row : batch) {
            List<Map<String, Object>> list = DataCompareUtil.prepareFilters(this.reader.getOutput(), this.reader.getFilters(), row.getInput());
            filters.addAll(list);
            String key = DataCompareUtil.getKey(list);
            filterKeys.add(key);
        }
    }
}

