/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dp;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.Filter;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscx.platform.core.res.meta.dp.DataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.ObjectReaderWrapper;
import kd.isc.iscx.platform.core.res.meta.dp.QueryUtil;

public class DatabaseQuery {
    private static final String COMPARE_NOT_ENDS_WITH = "NOT_ENDS_WITH";
    private static final String COMPARE_NOT_CONTAINS = "NOT_CONTAINS";
    private static final String COMPARE_NOT_STARTS_WITH = "NOT_STARTS_WITH";
    private static final String COMPARE_ENDS_WITH = "ENDS_WITH";
    private static final String COMPARE_CONTAINS = "CONTAINS";
    private static final String COMPARE_STARTS_WITH = "STARTS_WITH";
    private static final String COMPARE_IS_NOT_NULL = "IS_NOT_NULL";
    private static final String COMPARE_IS_NULL = "IS_NULL";
    private static final String COMPARE_IN = "in";
    private static final String COMPARE_NOT_IN = "not in";

    public static ObjectReader<? extends Map<String, Object>> invoke(ConnectionWrapper src, DataQuery query, Schema table, Map<String, Object> params, int bufferSize) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = DatabaseQuery.prepareQuerySQL(src, query, table, params, types, values);
        JdbcConnectionWrapper cn = (JdbcConnectionWrapper)src;
        int total = DatabaseQuery.executeTotalCount(cn, sql, values, types);
        ObjectReader reader = cn.executeQuery(sql, values, types);
        return new ObjectReaderWrapper(total, (ObjectReader<? extends Map<String, Object>>)reader, query.getOutput().getDataType(), sql);
    }

    private static int executeTotalCount(JdbcConnectionWrapper cn, String sql, List<Object> values, List<Integer> types) {
        if (cn.supportsExecuteCount()) {
            return (int)DbUtil.executeCount((Connection)cn, (String)sql, values, types);
        }
        return -1;
    }

    private static String prepareQuerySQL(ConnectionWrapper src, DataQuery query, Schema table, Map<String, Object> params, List<Integer> types, List<Object> values) {
        StringBuilder sql = new StringBuilder(1024);
        sql.append("SELECT ");
        DatabaseQuery.appendSelect(sql, query, table, src);
        sql.append(" FROM ").append(table.getQuotedName());
        if (!query.getFilters().isEmpty()) {
            sql.append(" WHERE ");
            DatabaseQuery.appendWhere(sql, query, table, src, values, types, params);
        }
        if (!query.getOrderBy().isEmpty()) {
            sql.append(" ORDER BY ");
            DatabaseQuery.appendOrderBy(sql, query, table, src);
        }
        return sql.toString();
    }

    private static void appendOrderBy(StringBuilder sql, DataQuery query, Schema table, ConnectionWrapper src) {
        boolean first = true;
        for (Pair<String, String> p : query.getOrderBy()) {
            first = DatabaseQuery.appendFieldSeperator(sql, first);
            Column f = table.getField((String)p.getKey());
            sql.append(f.getBinding());
            if (!"DESC".equalsIgnoreCase((String)p.getValue())) continue;
            sql.append(" DESC");
        }
    }

    private static void appendWhere(StringBuilder sql, DataQuery query, Schema table, ConnectionWrapper src, List<Object> values, List<Integer> types, Map<String, Object> params) {
        List<Map<String, Object>> filters = query.getFilters();
        int j = filters.size();
        int k = j - 1;
        for (int i = 0; i < j; ++i) {
            Map<String, Object> m = filters.get(i);
            sql.append(DatabaseQuery.trim(m.get("filter_left_bracket")));
            Object value = m.get("filter_value_fixed");
            if (Filter.isIgnoredFilterItem((Object)value)) {
                sql.append(" 1=1 ");
            } else {
                Column f = table.getField(D.s((Object)m.get("filter_column")));
                value = QueryUtil.cast(f, value, params);
                DatabaseQuery.appendCompare(sql, f, value, D.s((Object)m.get("filter_compare")), values, types);
            }
            sql.append(DatabaseQuery.trim(m.get("filter_right_bracket")));
            if (i >= k) continue;
            sql.append("OR".equals(m.get("filter_link")) ? " OR " : " AND ");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void appendCompare(StringBuilder sql, Column c, Object value, String filter_compare, List<Object> values, List<Integer> types) {
        sql.append(c.getBinding()).append(' ');
        switch (filter_compare) {
            case "STARTS_WITH": {
                sql.append("like ?");
                values.add(value + "%");
                types.add(12);
                return;
            }
            case "CONTAINS": {
                sql.append("like ?");
                values.add("%" + value + "%");
                types.add(12);
                return;
            }
            case "ENDS_WITH": {
                sql.append("like ?");
                values.add("%" + value);
                types.add(12);
                return;
            }
            case "NOT_STARTS_WITH": {
                sql.append("not like ?");
                values.add(value + "%");
                types.add(12);
                return;
            }
            case "NOT_CONTAINS": {
                sql.append("not like ?");
                values.add("%" + value + "%");
                types.add(12);
                return;
            }
            case "NOT_ENDS_WITH": {
                sql.append("not like ?");
                values.add("%" + value);
                types.add(12);
                return;
            }
            case "IS_NULL": {
                sql.append("is null");
                return;
            }
            case "IS_NOT_NULL": {
                sql.append("is not null");
                return;
            }
            case "in": 
            case "not in": {
                if (!(value instanceof List)) throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%s\uff09\u7684\u6bd4\u8f83\u503c\u683c\u5f0f\u4e0d\u662f\u5217\u8868\u3002", (String)"DatabaseQuery_5", (String)"isc-iscx-platform-core", (Object[])new Object[0]), c.getName()));
                List list = (List)value;
                if (list.isEmpty()) throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%s\uff09\u7684\u6bd4\u8f83\u503c\u5217\u8868\u4e3a\u7a7a\u3002", (String)"DatabaseQuery_4", (String)"isc-iscx-platform-core", (Object[])new Object[0]), c.getName()));
                sql.append(filter_compare).append('(');
                boolean first = true;
                for (Object v : list) {
                    first = DatabaseQuery.appendFieldSeperator(sql, first);
                    sql.append('?');
                    values.add(v);
                    types.add(DatabaseQuery.getSqlType(v));
                }
                sql.append(')');
                return;
            }
            default: {
                if (value == null) {
                    if ("=".equals(filter_compare)) {
                        sql.append(" IS NULL");
                        return;
                    }
                    if (!"<>".equals(filter_compare)) throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%1$s\uff09\u7684\u6bd4\u8f83\u503c\u4e3aNULL\uff0c\u4e0d\u652f\u6301\u6bd4\u8f83\u8fd0\u7b97\u201c%2$s\u201d\u3002", (String)"DatabaseQuery_6", (String)"isc-iscx-platform-core", (Object[])new Object[0]), c.getName(), filter_compare));
                    sql.append(" IS NOT NULL");
                    return;
                }
                sql.append(filter_compare).append(" ? ");
                values.add(value);
                types.add(DatabaseQuery.getSqlType(value));
            }
        }
    }

    private static String trim(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private static void appendSelect(StringBuilder sql, DataQuery query, Schema table, ConnectionWrapper src) {
        boolean first = true;
        for (String key : query.getRequired().keySet()) {
            first = DatabaseQuery.appendFieldSeperator(sql, first);
            Column f = table.getField(key);
            sql.append(f.getBinding());
        }
    }

    private static boolean appendFieldSeperator(StringBuilder sql, boolean first) {
        if (first) {
            first = false;
        } else {
            sql.append(", ");
        }
        return first;
    }

    public static int getSqlType(Object value) {
        if (value instanceof Integer) {
            return 4;
        }
        if (value instanceof String) {
            return 12;
        }
        if (value instanceof Long) {
            return -5;
        }
        if (value instanceof BigDecimal) {
            return 3;
        }
        if (value instanceof Date) {
            return 91;
        }
        if (value instanceof Time) {
            return 92;
        }
        if (value instanceof java.util.Date) {
            return 93;
        }
        if (value instanceof byte[]) {
            return -3;
        }
        if (value instanceof Double) {
            return 8;
        }
        if (value instanceof Float) {
            return 6;
        }
        throw new IllegalArgumentException(value == null ? "null" : value + ":" + value.getClass().getName());
    }
}

