/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.data.ValueRange;
import kd.isc.iscx.platform.core.res.meta.dp.DataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.ObjectReaderWrapper;
import kd.isc.iscx.platform.core.res.meta.dp.QueryUtil;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;

public class EntityQuery {
    public static ObjectReader<? extends Map<String, Object>> invoke(ConnectionWrapper src, DataQuery query, String entity, Map<String, Object> params) {
        List<Map<String, Object>> filters = EntityQuery.prepareFilters(query, params, entity);
        Map<String, Object> required = query.getRequired();
        List<Map<String, String>> orderBy = EntityQuery.prepareOrderBy(query.getOrderBy());
        ObjectReader reader = src.getFactory().query(src, entity, required, filters, orderBy);
        return new ObjectReaderWrapper(reader.getTotalCount(), (ObjectReader<? extends Map<String, Object>>)reader, query.getOutput().getDataType(), entity + "-ENTITY-QUERY");
    }

    private static List<Map<String, Object>> prepareFilters(DataQuery query, Map<String, Object> params, String entity) {
        StructSchema schema = query.getOutput().getDataType();
        ArrayList<Map<String, Object>> filter = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : query.getFilters()) {
            Object filterColumn = map.get("filter_column");
            if (filterColumn == null) continue;
            Object compare = map.get("filter_compare");
            Field f = QueryUtil.getField(schema, D.s((Object)map.get("filter_column")), entity);
            Object value = QueryUtil.cast(f, map.get("filter_value_fixed"), params);
            if (value instanceof ValueRange) {
                EntityQuery.handleValueRange(filter, map, filterColumn, (ValueRange)value);
                continue;
            }
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("filter_left_bracket", map.get("filter_left_bracket"));
            item.put("filter_column", filterColumn);
            item.put("filter_compare", compare);
            item.put("filter_value", value);
            item.put("filter_right_bracket", map.get("filter_right_bracket"));
            item.put("filter_link", map.get("filter_link"));
            filter.add(item);
        }
        return filter;
    }

    private static void handleValueRange(List<Map<String, Object>> filter, Map<String, Object> map, Object filterColumn, ValueRange<?> range) {
        HashMap<String, Object> item = new HashMap<String, Object>(5);
        String leftBracket = D.s((Object)map.get("filter_left_bracket"));
        String rightBracket = D.s((Object)map.get("filter_right_bracket"));
        item.put("filter_left_bracket", leftBracket == null ? "(" : "(" + leftBracket);
        item.put("filter_column", filterColumn);
        item.put("filter_compare", ">=");
        item.put("filter_value", range.getLBound());
        item.put("filter_link", "AND");
        filter.add(item);
        item = new HashMap(5);
        item.put("filter_column", filterColumn);
        item.put("filter_compare", "<=");
        item.put("filter_value", range.getUBound());
        item.put("filter_right_bracket", rightBracket == null ? ")" : rightBracket + ")");
        item.put("filter_link", map.get("filter_link"));
        filter.add(item);
    }

    private static List<Map<String, String>> prepareOrderBy(List<Pair<String, String>> orderBy) {
        ArrayList<Map<String, String>> orderByList = new ArrayList<Map<String, String>>(orderBy.size());
        for (Pair<String, String> pair : orderBy) {
            HashMap<String, Object> or = new HashMap<String, Object>();
            or.put("sort_field", pair.getA());
            or.put("sort_mode", pair.getB());
            orderByList.add(or);
        }
        return orderByList;
    }
}

