/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dp.DataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.EntriesReader;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompareUtil;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.Util;

public class EntriesReaderApplication
implements Application {
    private EntriesReader reader;
    private Connector connector;

    public EntriesReaderApplication(EntriesReader reader, Connector connector) {
        this.reader = reader;
        this.connector = connector;
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        Map<String, Object> data = Util.getInputData(e, this.reader);
        Object masterId = EntriesReaderApplication.getMasterId(this.reader, data);
        List<Map<String, Object>> list = this.queryEntries(masterId);
        List<Map<String, Object>> entries = this.filterEntries(masterId, list);
        data.put(this.reader.getEntryAlias(), entries);
    }

    private List<Map<String, Object>> filterEntries(Object masterId, List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>(list.size());
        String foreignKey = this.reader.getEntryForeignKeyField();
        for (Map<String, Object> item : list) {
            Object foreignId = item.get(foreignKey);
            if (!Objects.equals(masterId, foreignId)) continue;
            entries.add(item);
        }
        return entries;
    }

    private List<Map<String, Object>> queryEntries(Object masterId) {
        List<Map<String, Object>> list;
        List<Map<String, Object>> filters = this.generateFilters(masterId);
        AbstractDataModel entryModel = this.reader.getEntryModel();
        try (ConnectionWrapper $src = this.connector.getConnection();){
            DataQuery query = new DataQuery(this.reader.getId(), this.reader.getNumber(), this.reader.getName(), entryModel, entryModel, this.reader.getRequired(), filters);
            list = DataCompareUtil.queryList($src, query, 0, null);
        }
        return list;
    }

    static Object getMasterId(EntriesReader reader, Map<String, Object> data) {
        String masterPK;
        DataType foreignType = reader.getEntryForeignKeyType();
        Object masterId = foreignType.narrow(data.get(masterPK = reader.getMasterPrimaryKeyField()));
        if (masterId == null) {
            throw new NullPointerException(masterPK + " is null.");
        }
        return masterId;
    }

    private List<Map<String, Object>> generateFilters(Object masterId) {
        HashMap<String, Object> item = new HashMap<String, Object>(4);
        item.put("filter_column", this.reader.getEntryForeignKeyField());
        item.put("filter_compare", "=");
        item.put("filter_value_fixed", masterId);
        return Collections.singletonList(item);
    }
}

