/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dp.DataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.EntriesReader;
import kd.isc.iscx.platform.core.res.meta.dp.EntriesReaderApplication;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompareUtil;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;

public class EntriesReaderXApplication
extends AbstractBatchApplication {
    private EntriesReader reader;
    private Connector connector;

    protected EntriesReaderXApplication(EntriesReader reader, Connector connector, int batchSize) {
        super(reader, batchSize);
        this.reader = reader;
        this.connector = connector;
    }

    @Override
    public void doBatch(DataStream stream, List<AbstractBatchApplication.Data> batch) {
        Map<Object, AbstractBatchApplication.Data> masterMap = this.buildMasterMap(batch);
        List<Map<String, Object>> filters = this.generateFilters(masterMap.keySet());
        List<Map<String, Object>> list = this.queryEntries(filters);
        Map<Object, List<Map<String, Object>>> entriesMap = this.buildEntriesMap(list);
        this.outputEntries(masterMap, entriesMap);
    }

    private void outputEntries(Map<Object, AbstractBatchApplication.Data> masterMap, Map<Object, List<Map<String, Object>>> entriesMap) {
        String entryAlias = this.reader.getEntryAlias();
        for (Map.Entry<Object, List<Map<String, Object>>> e : entriesMap.entrySet()) {
            AbstractBatchApplication.Data row = masterMap.remove(e.getKey());
            if (row == null) continue;
            row.getInput().put(entryAlias, e.getValue());
        }
        for (AbstractBatchApplication.Data row : masterMap.values()) {
            row.getInput().put(entryAlias, Collections.emptyList());
        }
    }

    private Map<Object, List<Map<String, Object>>> buildEntriesMap(List<Map<String, Object>> list) {
        HashMap<Object, List<Map<String, Object>>> entriesMap = new HashMap<Object, List<Map<String, Object>>>();
        String foreignKey = this.reader.getEntryForeignKeyField();
        for (Map<String, Object> item : list) {
            Object foreignValue = item.get(foreignKey);
            ArrayList<Map<String, Object>> entries = (ArrayList<Map<String, Object>>)entriesMap.get(foreignValue);
            if (entries == null) {
                entries = new ArrayList<Map<String, Object>>();
                entriesMap.put(foreignValue, entries);
            }
            entries.add(item);
        }
        return entriesMap;
    }

    private List<Map<String, Object>> queryEntries(List<Map<String, Object>> filters) {
        List<Map<String, Object>> list;
        AbstractDataModel entryModel = this.reader.getEntryModel();
        try (ConnectionWrapper $src = this.connector.getConnection();){
            DataQuery query = new DataQuery(this.reader.getId(), this.reader.getNumber(), this.reader.getName(), entryModel, entryModel, this.reader.getRequired(), filters);
            list = DataCompareUtil.queryList($src, query, 0, null);
        }
        return list;
    }

    private Map<Object, AbstractBatchApplication.Data> buildMasterMap(List<AbstractBatchApplication.Data> batch) {
        HashMap<Object, AbstractBatchApplication.Data> masterMap = new HashMap<Object, AbstractBatchApplication.Data>(batch.size());
        for (AbstractBatchApplication.Data row : batch) {
            Object masterId = EntriesReaderApplication.getMasterId(this.reader, row.getInput());
            masterMap.put(masterId, row);
        }
        if (masterMap.size() != batch.size()) {
            throw new IllegalArgumentException("MasterId is duplicated");
        }
        return masterMap;
    }

    private List<Map<String, Object>> generateFilters(Collection<Object> masterIds) {
        HashMap<String, Object> item = new HashMap<String, Object>(4);
        item.put("filter_column", this.reader.getEntryForeignKeyField());
        item.put("filter_compare", "in");
        item.put("filter_value_fixed", new ArrayList<Object>(masterIds));
        return Collections.singletonList(item);
    }
}

