/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dp;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dp.DataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.ReferReader;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompareUtil;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.Util;

public class ReferReaderApplication
implements Application {
    private ReferReader reader;
    private Connector connector;

    public ReferReaderApplication(ReferReader reader, Connector connector) {
        this.reader = reader;
        this.connector = connector;
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        Map<String, Object> data = Util.getInputData(e, this.reader);
        Object masterFkId = ReferReaderApplication.getMasterFkId(this.reader, data);
        Map<String, Object> ref = this.queryRefer(masterFkId);
        data.put(this.reader.getRefAlias(), ref);
    }

    private Map<String, Object> queryRefer(Object masterFkId) {
        List<Map<String, Object>> list;
        if (masterFkId == null) {
            return null;
        }
        List<Map<String, Object>> filters = this.generateFilters(masterFkId);
        AbstractDataModel referModel = this.reader.getRefModel();
        try (ConnectionWrapper $src = this.connector.getConnection();){
            DataQuery query = new DataQuery(this.reader.getId(), this.reader.getNumber(), this.reader.getName(), referModel, referModel, this.reader.getRequired(), filters);
            list = DataCompareUtil.queryList($src, query, 0, null);
        }
        for (Map<String, Object> ref : list) {
            if (!Objects.equals(masterFkId, ref.get(this.reader.getRefPrimaryKeyField()))) continue;
            return ref;
        }
        return null;
    }

    static Object getMasterFkId(ReferReader reader, Map<String, Object> data) {
        String masterFkField;
        DataType pkType = reader.getRefPrimaryKeyType();
        Object masterFkId = pkType.narrow(data.get(masterFkField = reader.getMasterForeignKeyField()));
        if (masterFkId == null) {
            throw new NullPointerException(masterFkId + " is null.");
        }
        return masterFkId;
    }

    private List<Map<String, Object>> generateFilters(Object masterFkId) {
        HashMap<String, Object> item = new HashMap<String, Object>(4);
        item.put("filter_column", this.reader.getRefPrimaryKeyField());
        item.put("filter_compare", "=");
        item.put("filter_value_fixed", masterFkId);
        return Collections.singletonList(item);
    }
}

