/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.dp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dp.DataQuery;
import kd.isc.iscx.platform.core.res.meta.dp.ReferReader;
import kd.isc.iscx.platform.core.res.meta.dp.ReferReaderApplication;
import kd.isc.iscx.platform.core.res.meta.dw.DataCompareUtil;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;

public class ReferReaderXApplication
extends AbstractBatchApplication {
    private ReferReader reader;
    private Connector connector;

    protected ReferReaderXApplication(ReferReader reader, Connector connector, int batchSize) {
        super(reader, batchSize);
        this.reader = reader;
        this.connector = connector;
    }

    @Override
    public void doBatch(DataStream stream, List<AbstractBatchApplication.Data> batch) {
        Map<Object, List<AbstractBatchApplication.Data>> masterMap = this.buildMasterMap(batch);
        if (masterMap.isEmpty()) {
            this.outputRefers(masterMap, Collections.emptyList());
        } else {
            List<Map<String, Object>> filters = this.generateFilters(masterMap.keySet());
            List<Map<String, Object>> list = this.queryRefers(filters, masterMap.size());
            this.outputRefers(masterMap, list);
        }
    }

    private void outputRefers(Map<Object, List<AbstractBatchApplication.Data>> masterMap, List<Map<String, Object>> list) {
        String refAlias = this.reader.getRefAlias();
        String refPK = this.reader.getRefPrimaryKeyField();
        for (Map<String, Object> map : list) {
            List<AbstractBatchApplication.Data> rows = masterMap.remove(map.get(refPK));
            if (rows == null) continue;
            for (AbstractBatchApplication.Data row : rows) {
                row.getInput().put(refAlias, map);
            }
        }
        for (List list2 : masterMap.values()) {
            for (AbstractBatchApplication.Data row : list2) {
                row.getInput().put(refAlias, null);
            }
        }
    }

    private List<Map<String, Object>> queryRefers(List<Map<String, Object>> filters, int maxCount) {
        List<Map<String, Object>> list;
        AbstractDataModel referModel = this.reader.getRefModel();
        try (ConnectionWrapper $src = this.connector.getConnection();){
            DataQuery query = new DataQuery(this.reader.getId(), this.reader.getNumber(), this.reader.getName(), referModel, referModel, this.reader.getRequired(), filters);
            list = DataCompareUtil.queryList($src, query, 0, null);
        }
        return list;
    }

    private Map<Object, List<AbstractBatchApplication.Data>> buildMasterMap(List<AbstractBatchApplication.Data> batch) {
        HashMap<Object, List<AbstractBatchApplication.Data>> masterMap = new HashMap<Object, List<AbstractBatchApplication.Data>>(batch.size());
        for (AbstractBatchApplication.Data row : batch) {
            Object masterFkId = ReferReaderApplication.getMasterFkId(this.reader, row.getInput());
            if (masterFkId == null) continue;
            ArrayList<AbstractBatchApplication.Data> group = (ArrayList<AbstractBatchApplication.Data>)masterMap.get(masterFkId);
            if (group == null) {
                group = new ArrayList<AbstractBatchApplication.Data>();
                masterMap.put(masterFkId, group);
            }
            group.add(row);
        }
        return masterMap;
    }

    private List<Map<String, Object>> generateFilters(Collection<Object> masterFkIds) {
        HashMap<String, Object> item = new HashMap<String, Object>(4);
        item.put("filter_column", this.reader.getRefPrimaryKeyField());
        item.put("filter_compare", "in");
        item.put("filter_value_fixed", new ArrayList<Object>(masterFkIds));
        return Collections.singletonList(item);
    }
}

