/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.ds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscx.platform.core.res.meta.dm.DataTable;
import kd.isc.iscx.platform.core.res.meta.ds.AbstractDataBatchConsumerApplication;
import kd.isc.iscx.platform.core.res.meta.ds.DataTableLoad;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.job.AbstractBatchApplication;
import kd.isc.iscx.platform.core.res.runtime.job.DataStream;

class DataTableBatchLoadApplication
extends AbstractDataBatchConsumerApplication {
    private DataTableLoad dataTableLoad;
    private volatile Table table;

    DataTableBatchLoadApplication(Connector connector, DataTableLoad dataTableLoad, int batchSize) {
        super(connector, dataTableLoad, batchSize);
        this.dataTableLoad = dataTableLoad;
    }

    private final Table getTable(ConnectionWrapper cn) {
        Table table = this.table;
        if (table == null) {
            table = this.initTable(cn);
        }
        return table;
    }

    private synchronized Table initTable(ConnectionWrapper cn) {
        Table table = this.table;
        if (table == null) {
            String tableName = ((DataTable)this.dataTableLoad.getInput()).getTableName();
            this.table = table = ConnectionManager.getTable((ConnectionWrapper)cn, (String)tableName);
        }
        return table;
    }

    @Override
    public void doBatch(DataStream stream, ConnectionWrapper cn, List<AbstractBatchApplication.Data> batch) {
        Table table = this.getTable(cn);
        if ("_INSERT_WITHOUT_CHECK".equals(this.dataTableLoad.getDataAction())) {
            this.batchInsert(cn, table, batch);
        } else if (this.isUpsert()) {
            this.doBatchUpsert(cn, table, batch);
        } else {
            ArrayList<AbstractBatchApplication.Data> for_insert = new ArrayList<AbstractBatchApplication.Data>();
            ArrayList<AbstractBatchApplication.Data> for_update = new ArrayList<AbstractBatchApplication.Data>();
            this.classifyTargets(cn, table, batch, for_insert, for_update);
            this.doBatchAction(cn, table, for_insert, for_update);
        }
    }

    private boolean isUpsert() {
        String action = this.dataTableLoad.getDataAction();
        return TableAction._UPSERT.name().equals(action);
    }

    private void doBatchUpsert(ConnectionWrapper cn, Table table, List<AbstractBatchApplication.Data> batch) {
        List primaryKeys = table.getPrimaryKeys();
        if (primaryKeys.isEmpty()) {
            String msg = String.format(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u8868[%1$s]\u4e0d\u5b58\u5728\u4e3b\u952e\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u6279\u91cfupsert\u64cd\u4f5c\uff0c\u8bf7\u8c03\u6574\u8868\u7ed3\u6784\u521b\u5efa\u597d\u4e3b\u952e\u540e\u518d\u91cd\u65b0\u5c1d\u8bd5\u3002", (String)"DataTableBatchLoadApplication_13", (String)"isc-iscx-platform-core", (Object[])new Object[0]), table.getName());
            throw new IllegalArgumentException(msg);
        }
        ArrayList<Map<String, Object>> batchlist = new ArrayList<Map<String, Object>>(batch.size());
        for (AbstractBatchApplication.Data data : batch) {
            Map<String, Object> input = data.getInput();
            batchlist.add(input);
        }
        List<String> judgeFields = this.dataTableLoad.getJudgeFields();
        List<Column> fields = DataTableBatchLoadApplication.findParams(table, (Map)batchlist.get(0));
        cn.getFactory().doBatchUpsert(cn, table, fields, judgeFields, batchlist);
        this.setFlag(table, batch, SaveDataType.SAVE.name(), null);
    }

    public static List<Column> findParams(Table table, Map<String, Object> row) {
        ArrayList<Column> fields = new ArrayList<Column>(row.size());
        for (String name : row.keySet()) {
            if (!table.hasField(name)) continue;
            fields.add(table.getField(name));
        }
        return fields;
    }

    private void classifyTargets(ConnectionWrapper cn, Table table, List<AbstractBatchApplication.Data> batch, List<AbstractBatchApplication.Data> for_insert, List<AbstractBatchApplication.Data> for_update) {
        List<String> judgeFields = this.dataTableLoad.getJudgeFields();
        if (judgeFields.size() == 1) {
            this.handleOneKey(cn, table, batch, for_insert, for_update, judgeFields.get(0));
        } else {
            this.handleMultiKey(cn, table, batch, for_insert, for_update, judgeFields);
        }
    }

    private void handleMultiKey(ConnectionWrapper cn, Table table, List<AbstractBatchApplication.Data> batch, List<AbstractBatchApplication.Data> for_insert, List<AbstractBatchApplication.Data> for_update, List<String> judgeFields) {
        List<Column> fields = this.getColumns(table, judgeFields);
        List<Map<String, Object>> batch0 = this.getBatch0(batch);
        ArrayList<Map<String, Object>> for_insert0 = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> for_update0 = new ArrayList<Map<String, Object>>();
        cn.classify(table, batch0, fields, for_insert0, for_update0);
        this.collectData(batch, for_insert, for_insert0);
        this.collectData(batch, for_update, for_update0);
    }

    private void collectData(List<AbstractBatchApplication.Data> batch, List<AbstractBatchApplication.Data> for_insert, List<Map<String, Object>> for_insert0) {
        for (Map<String, Object> item : for_insert0) {
            int index = D.i((Object)item.remove("#"));
            for_insert.add(batch.get(index));
        }
    }

    private List<Map<String, Object>> getBatch0(List<AbstractBatchApplication.Data> batch) {
        ArrayList<Map<String, Object>> batch0 = new ArrayList<Map<String, Object>>(batch.size());
        int index = -1;
        for (AbstractBatchApplication.Data data : batch) {
            Map<String, Object> item = data.getInput();
            item.put("#", ++index);
            batch0.add(item);
        }
        return batch0;
    }

    private List<Column> getColumns(Table table, List<String> fields) {
        ArrayList<Column> columns = new ArrayList<Column>(fields.size());
        for (String key : fields) {
            columns.add(table.getField(key));
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOneKey(ConnectionWrapper cn, Table table, List<AbstractBatchApplication.Data> batch, List<AbstractBatchApplication.Data> for_insert, List<AbstractBatchApplication.Data> for_update, String judgeField) {
        Column column = table.getField(judgeField);
        Map<Object, AbstractBatchApplication.Data> key_mapping = this.constructKeyMapping(batch, judgeField, column);
        try (ObjectReader<DataRow> reader = this.queryExistsKeys(cn, table, column, batch, key_mapping);){
            DataRow item = (DataRow)reader.read();
            while (item != null) {
                AbstractBatchApplication.Data data = key_mapping.remove(item.getValue(0));
                if (data != null) {
                    for_update.add(data);
                }
                item = (DataRow)reader.read();
            }
            for_insert.addAll(key_mapping.values());
        }
    }

    private ObjectReader<DataRow> queryExistsKeys(ConnectionWrapper cn, Table table, Column column, List<AbstractBatchApplication.Data> batch, Map<Object, AbstractBatchApplication.Data> key_mapping) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = this.generateJudgeSQL(cn, table, column, key_mapping.keySet(), values, types);
        return cn.executeQuery(sql, values, types);
    }

    private String generateJudgeSQL(ConnectionWrapper cn, Table table, Column column, Set<Object> keys, List<Object> values, List<Integer> types) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(column.getBinding());
        sb.append(" from ");
        sb.append(table.getQuotedName());
        sb.append(" where ");
        sb.append(column.getBinding());
        sb.append(" in ( ");
        DataType dataType = column.getDataType();
        int sqlType = column.getSqlType();
        for (Object key : keys) {
            if (!values.isEmpty()) {
                sb.append(',');
            }
            values.add(dataType.forSave(key));
            types.add(sqlType);
            sb.append(" ? ");
        }
        sb.append(')');
        return sb.toString();
    }

    private Map<Object, AbstractBatchApplication.Data> constructKeyMapping(List<AbstractBatchApplication.Data> batch, String field, Column column) {
        HashMap<Object, AbstractBatchApplication.Data> key_mapping = new HashMap<Object, AbstractBatchApplication.Data>(batch.size());
        for (AbstractBatchApplication.Data data : batch) {
            Object value = data.getInput().get(field);
            AbstractBatchApplication.Data dup = key_mapping.put(column.narrow(value), data);
            if (dup == null) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5b57\u6bb5\uff08%1$s\uff09\u5bf9\u76ee\u6807\u6570\u636e\u8fdb\u884c\u552f\u4e00\u6027\u68c0\u67e5\uff0c\u53d1\u73b0\u5176\u4e2d\u5b58\u5728\u91cd\u590d\u503c\uff08%2$s\uff09\uff0c\u8bf7\u4fee\u6539\u65b9\u6848\u4e2d\u9009\u62e9\u7684\u5019\u9009\u952e\u5b57\u6bb5\u3002", (String)"DataTableBatchLoadApplication_7", (String)"isc-iscx-platform-core", (Object[])new Object[0]), field, value));
        }
        return key_mapping;
    }

    private void doBatchAction(ConnectionWrapper cn, Table table, List<AbstractBatchApplication.Data> for_insert, List<AbstractBatchApplication.Data> for_update) {
        String action;
        switch (action = this.dataTableLoad.getDataAction()) {
            case "_SAVE": {
                this.batchInsert(cn, table, for_insert);
                this.batchUpdate(cn, table, for_update);
                break;
            }
            case "_INSERT": {
                this.batchInsert(cn, table, for_insert);
                this.setFlag(table, for_update, "NOP", ResManager.loadKDString((String)"\u5ffd\u7565\u5df2\u5b58\u5728\u7684\u6570\u636e", (String)"DataTableBatchLoadApplication_10", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
                break;
            }
            case "_UPDATE": {
                this.batchUpdate(cn, table, for_update);
                this.setFlag(table, for_insert, "NOP", ResManager.loadKDString((String)"\u5ffd\u7565\u4e0d\u5b58\u5728\u7684\u6570\u636e", (String)"DataTableBatchLoadApplication_11", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
                break;
            }
            default: {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a%s", (String)"DataTableBatchLoadApplication_8", (String)"isc-iscx-platform-core", (Object[])new Object[0]), action));
            }
        }
    }

    private void batchUpdate(ConnectionWrapper cn, Table table, List<AbstractBatchApplication.Data> for_update) {
        if (for_update.isEmpty()) {
            return;
        }
        List<Column> setFields = this.getColumns(table, this.dataTableLoad.getUpdateFields());
        if (setFields.isEmpty()) {
            this.setFlag(table, for_update, "NOP", ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4fee\u6539\u7684\u5b57\u6bb5", (String)"DataTableBatchLoadApplication_12", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
            return;
        }
        List<Column> judgeFields = this.getColumns(table, this.dataTableLoad.getJudgeFields());
        String sql = DataTableBatchLoadApplication.prepareUpdateSQL(table, setFields, judgeFields);
        List<List<Object>> batch = this.prepareBatchForUpdate(for_update, setFields, judgeFields);
        List<Integer> types = this.prepareParamTypes(setFields, judgeFields);
        cn.executeBatch(sql, batch, types);
        this.setFlag(table, for_update, "UPDATE", null);
    }

    private List<Integer> prepareParamTypes(List<Column> setFields, List<Column> judgeFields) {
        ArrayList<Integer> types = new ArrayList<Integer>(setFields.size());
        for (Column f : setFields) {
            types.add(f.getSqlType());
        }
        for (Column f : judgeFields) {
            types.add(f.getSqlType());
        }
        return types;
    }

    private List<List<Object>> prepareBatchForUpdate(List<AbstractBatchApplication.Data> for_update, List<Column> setFields, List<Column> judgeFields) {
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>(for_update.size());
        for (AbstractBatchApplication.Data data : for_update) {
            ArrayList<Object> row = new ArrayList<Object>(setFields.size() + judgeFields.size());
            Map<String, Object> input = data.getInput();
            for (Column f : setFields) {
                this.readValue(input, f, row);
            }
            for (Column f : judgeFields) {
                this.readValue(input, f, row);
            }
            batch.add(row);
        }
        return batch;
    }

    private void readValue(Map<String, Object> input, Column field, List<Object> row) {
        DataType t = field.getDataType();
        String key = field.getName();
        Object outerValue = input.get(key);
        if (outerValue == null && !input.containsKey(key)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\uff08%1$s\uff09\u7684\u5b57\u6bb5\uff08%2$s\uff09\u6ca1\u6709\u8d4b\u503c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6d41\u4e2d\u5404\u53d6\u6570\u548c\u8f6c\u6362\u8282\u70b9\u7684\u914d\u7f6e\u3002", (String)"DataTableBatchLoadApplication_9", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this.dataTableLoad.getInput(), key));
        }
        row.add(t.forSave(t.narrow(outerValue)));
    }

    private static String prepareUpdateSQL(Table tar_table, List<Column> setFields, List<Column> judgeFields) {
        int i;
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tar_table.getQuotedName()).append(" SET ");
        for (i = 0; i < setFields.size(); ++i) {
            Column c = setFields.get(i);
            if (i > 0) {
                sql.append(',');
            }
            sql.append(c.getBinding()).append("=?");
        }
        sql.append(" WHERE ");
        for (i = 0; i < judgeFields.size(); ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(judgeFields.get(i).getBinding()).append("=?");
        }
        return sql.toString();
    }

    private void batchInsert(ConnectionWrapper cn, Table table, List<AbstractBatchApplication.Data> for_insert) {
        if (for_insert.isEmpty()) {
            return;
        }
        List<String> fields = this.dataTableLoad.getInsertFields();
        String sql = TableUtil.prepareInsertSQL((Table)table, fields);
        ArrayList<Column> params = new ArrayList<Column>(fields.size());
        ArrayList<Integer> types = new ArrayList<Integer>(fields.size());
        for (String name : fields) {
            Column f = table.getField(name);
            params.add(f);
            types.add(f.getSqlType());
        }
        ArrayList<ArrayList<Object>> batch = new ArrayList<ArrayList<Object>>(for_insert.size());
        for (AbstractBatchApplication.Data data : for_insert) {
            ArrayList<Object> row = new ArrayList<Object>(params.size());
            Map<String, Object> input = data.getInput();
            for (Column f : params) {
                this.readValue(input, f, row);
            }
            batch.add(row);
        }
        cn.executeBatch(sql, batch, types);
        this.setFlag(table, for_insert, "INSERT", null);
    }

    private void setFlag(Table table, List<AbstractBatchApplication.Data> list, String flag, String reason) {
        String pk = table.getPrimaryKeyName();
        for (AbstractBatchApplication.Data data : list) {
            Map<String, Object> output = data.getOutput();
            output.put("id", pk == null ? null : data.getInput().get(pk));
            output.put("type", flag);
            output.put("message", reason);
        }
    }
}

