/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.res.meta.ds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.ds.AbstractDataConsumer;
import kd.isc.iscx.platform.core.res.meta.ds.DataTableBatchLoadApplication;
import kd.isc.iscx.platform.core.res.meta.ds.DataTableLoadApplication;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.runtime.BatchSupportable;
import kd.isc.iscx.platform.core.res.runtime.Connector;

public class DataTableLoad
extends AbstractDataConsumer
implements BatchSupportable {
    private int batchSize;
    private String dataAction;
    private List<String> judgeFields;
    private List<String> updateFields;
    private List<String> insertFields;

    private DataTableLoad(long id, String number, String name, ResourceType resourceType, Map<String, Object> details) {
        super(id, number, name, resourceType, details);
        this.batchSize = D.i((Object)details.get("batch_size"));
        this.dataAction = D.s((Object)details.get("data_action"));
        List fields = (List)details.get("fields");
        this.initAssignedFields(fields);
    }

    private void initAssignedFields(List<Map<String, Object>> fields) {
        HashSet<String> judgeFields = new HashSet<String>(fields.size());
        HashSet<String> insertFields = new HashSet<String>(fields.size());
        StructSchema schema = this.getInput().getDataType();
        for (Map<String, Object> map : fields) {
            String name = D.s((Object)map.get("field_name"));
            if (schema.getField(name) != null) {
                insertFields.add(name);
                if (!D.x((Object)map.get("is_candidate_key"))) continue;
                judgeFields.add(name);
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u5f15\u7528\u7684\u5b57\u6bb5\uff08%2$s\uff09\u5728\u4e0d\u5b58\u5728\u3002", (String)"DataTableLoad_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this, name));
        }
        if (judgeFields.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u6307\u5b9a\u5019\u9009\u952e\u5b57\u6bb5\u3002", (String)"DataTableLoad_4", (String)"isc-iscx-platform-core", (Object[])new Object[0]), this));
        }
        this.judgeFields = Collections.unmodifiableList(new ArrayList(judgeFields));
        this.insertFields = Collections.unmodifiableList(new ArrayList(insertFields));
        insertFields.removeAll(judgeFields);
        for (Field field : schema.getPrimaryKeyFields()) {
            insertFields.remove(field.getName());
        }
        this.updateFields = Collections.unmodifiableList(new ArrayList(insertFields));
    }

    @Override
    public boolean isBatchMode() {
        return this.batchSize > 1;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getDataAction() {
        return this.dataAction;
    }

    public List<String> getJudgeFields() {
        return this.judgeFields;
    }

    public List<String> getUpdateFields() {
        return this.updateFields;
    }

    public List<String> getInsertFields() {
        return this.insertFields;
    }

    @Override
    public void build(NodeBuilder node, Map<String, Object> details, Connector $tar, boolean batchMode) {
        if (batchMode) {
            node.biz((Application)new DataTableBatchLoadApplication($tar, this, this.batchSize), WAIT_FOR_BATCH_TASK);
        } else {
            node.biz((Application)new DataTableLoadApplication($tar, this));
        }
    }

    @Override
    public Object getDataConsumerApplication(Connector $tar) {
        if (this.batchSize <= 1) {
            return new DataTableLoadApplication($tar, this);
        }
        return new DataTableBatchLoadApplication($tar, this, this.batchSize);
    }

    public static final class DataTableLoadParser
    extends ResourceType {
        public DataTableLoadParser(String number, String formId) {
            super(number, formId);
        }

        @Override
        public Resource parse(long id, String number, String name, Map<String, Object> details) {
            return new DataTableLoad(id, number, name, this, details);
        }

        @Override
        public boolean isExtensible() {
            return true;
        }
    }
}

